//
//  PPInterfaceOrientationController.h
//  
//
//  Created by Mike on 2011/6/14.
//  Copyright 2011年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_OPTIONS(NSUInteger, PPInterfaceOrientationControllerMask)
{
	PPInterfaceOrientationControllerMask_None				= 0,
	PPInterfaceOrientationControllerMask_Portrait			= 1<<0,
	PPInterfaceOrientationControllerMask_PortraitUpsideDown	= 1<<1,
	PPInterfaceOrientationControllerMask_LandscapeLeft		= 1<<2,
	PPInterfaceOrientationControllerMask_LandscapeRight		= 1<<3,
    PPInterfaceOrientationControllerMask_All                = (PPInterfaceOrientationControllerMask_Portrait|PPInterfaceOrientationControllerMask_PortraitUpsideDown|PPInterfaceOrientationControllerMask_LandscapeLeft|PPInterfaceOrientationControllerMask_LandscapeRight),
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPInterfaceOrientationController : NSObject
{
@private
	PPInterfaceOrientationControllerMask	mask_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,assign) PPInterfaceOrientationControllerMask mask;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Rotation Events

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation fromInterfaceOrientation:(UIInterfaceOrientation)fromInterfaceOrientation;
- (BOOL)shouldAutorotate;
- (UIInterfaceOrientationMask)supportedInterfaceOrientations;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (void)setDefaultMaskForiPad:(PPInterfaceOrientationControllerMask)mask;
+ (void)setDefaultMaskForiPhone:(PPInterfaceOrientationControllerMask)mask;
+ (void)setOrientationLock:(BOOL)lock;
+ (BOOL)orientationLock;
+ (void)setDefaultOrientationMaskLock:(BOOL)lock;
+ (BOOL)defaultOrientationMaskLock;
@end
