//
//  PPImageBrowseViewController.h
//

#import "PPViewController.h"
#import "PPAppearance.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_OPTIONS(NSInteger, PPImageBrowseViewController_Orientation)
{
    PPImageBrowseViewController_Orientation_None = 0,
    PPImageBrowseViewController_Orientation_Left,
    PPImageBrowseViewController_Orientation_Right,
};

////////////////////////////////////////////////////////////////////////////////////////////////////


@interface PPImageBrowseViewController : PPViewController <PPAppearance>

/// Image to browse
@property (nonatomic, retain) UIImage *image;

/// Image browse area inset, default is {0, 0, 0, 0}.
@property (nonatomic, assign) UIEdgeInsets browseAreaInset;

/// Number of touches for moving image, default is 1.
@property (nonatomic, assign) NSUInteger numberOfTouchesForMoving;

/// Zooming when double clicked image, default is YES.
@property (nonatomic, assign) BOOL doubleTapZoomingEnabled;

@property (nonatomic, retain) UIColor *browseViewBackgroundColor PP_APPEARANCE_SELECTOR;

@property (nonatomic, retain) UITapGestureRecognizer *doubleTapGestureRecognizer;

/**
 * Rotate image with animation
 *
 * @param orientation - Turn left or right.
 * @return YES if can rotate, NO if other rotation is on going.
 */
- (BOOL)animateRotateImageViewWithOrientation:(PPImageBrowseViewController_Orientation)orientation;


/**
 * 取得UIImage的imageOrientation修正為UIImageOrientationUp的影像
 *
 * @return Image after rotation
 */
- (UIImage *)imageWithApplyRotation;



/**
 動態調整 layoutConstraint
 使用時機: browseAreaInset 改變時 ex 旋轉
 */
- (void)assignBrowseViewLayuotConstraints;

@end
