//
//  PPGuideView.h
//
//  Created by eddie on 2015/4/2.
//  Copyright (c) 2015年 eddie. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PPGuideAttributeModel.h"
#import "PPGuideDataModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPGuideView;

@protocol PPGuideViewDelegate <NSObject>
@required

/**
 * Check if guide view can be touched through
 *
 * @param point - Touch point in guide view
 */
- (BOOL)guideView:(PPGuideView *)guideView canTouchThroughWithPoint:(CGPoint)point;

/**
 * Did tap guide view
 *
 * @param guideView - Instance of view
 * @param point - Top point in guide view
 */
- (void)guideView:(PPGuideView *)guideView didTapWithPoint:(CGPoint)point;

/**
 * Did click confirm button
 *
 * @param guideView - Instance of view
 * @param button - button instance
 */
- (void)guideView:(PPGuideView *)guideView didClickConfirmButton:(UIButton *)button;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPGuideView : UIView

//@property (nonatomic, assign) UIInterfaceOrientation orientation;


/**
 * Init
 *
 * @param frame - View frame
 * @param delegate - Delegate of PPGuideViewDelegate protocol
 * @return PPGuideView instance
 */
- (id)initWithFrame:(CGRect)frame delegate:(id<PPGuideViewDelegate>)delegate;


/**
 * Setup PPGuideView constraints to superview
 *
 * @param transform - Transform that guideView will use.
 */
- (void)setupLayoutConstraintWithTransform:(CGAffineTransform)transform;


/**
 * Assign guide data
 *
 * @param guideAttribute - Guide attributes model
 * @param guideData - Guide data
 */
- (void)assignGuideAttribute:(PPGuideAttributeModel *)guideAttribute guideData:(PPGuideDataModel *)guideData;


/**
 * Hide/Show guide target image & info
 *
 * @param hidden - Hide/Show
 */
- (void)hideGudieTargetAndInfo:(BOOL)hidden;


/**
 * Remove all layout constraint in guide voew
 */
- (void)removeAllConstraints;



@end


