//
//  PPGuideDataModel.h
//
//  Created by eddie on 2015/4/3.
//  Copyright (c) 2015年 eddie. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "PPGuideFocusModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

/// 內部使用的guideIndex（外部不可設定 0 ~ -100 的guideIndex）
typedef NS_OPTIONS(NSInteger, PPGuideDataModel_ReservedIndex)
{
    PPGuideDataModel_ReservedIndex_Begin = 0,

    PPGuideDataModel_ReservedIndex_NoTarget = -1,
    
    PPGuideDataModel_ReservedIndex_end = -100,
};


/// guide目標與顯示資訊的相對位置 (!! Device方向為portrait)
typedef NS_OPTIONS(NSInteger, PPGuideDataModel_LayoutDirection)
{
    PPGuideDataModel_LayoutDirection_None = 0,
    
    /// guide目標與顯示資訊的相對位置以水平為主
    PPGuideDataModel_LayoutDirection_Vert,
    
    /// guide目標與顯示資訊的相對位置以垂直為主
    PPGuideDataModel_LayoutDirection_Horz,
};


/// 特殊樣式
typedef NS_OPTIONS(NSInteger, PPGuideDataModel_SpecialStyle)
{
    PPGuideDataModel_SpecialStyle_None = 0,
    
    /// 顯示資訊在guide目標內部（Gesture guide大都使用此樣式）
    PPGuideDataModel_SpecialStyle_GuideInfoInTargetView,
};


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPGuideDataModel : NSObject
@property (nonatomic, retain, readonly) PPGuideFocusModel   *guideFocusModel;
@property (nonatomic, retain, readonly) NSString            *className;
@property (nonatomic, assign, readonly) NSInteger           guideIndex;
@property (nonatomic, retain, readonly) NSString            *title;
@property (nonatomic, retain, readonly) NSString            *message;
@property (nonatomic, assign, readonly) PPGuideDataModel_LayoutDirection layoutDirection;
@property (nonatomic, assign, readonly) PPGuideDataModel_SpecialStyle specialStyle;

@property (nonatomic, retain) UIView    *targetView;


/**
 * 建立使用attribute中設定的focus樣式的說明資料
 *（focus樣式使用 [PPGuideController setAttributeWithMaskColor...] 設定）
 *
 * @param className         Class name of target view controller
 * @param guideIndex        Guide index of focus target view
 * @param title             Title of guide info
 * @param message           Message of guide info
 * @param layoutDirection   Focus與訊息的相對位置方向
 *
 * @return PPGuideDataModel instance
 */
+ (PPGuideDataModel *)modelWithTargetClassName:(NSString *)className
                                    guideIndex:(NSInteger)guideIndex
                                         title:(NSString *)title
                                       message:(NSString *)message
                               layoutDirection:(PPGuideDataModel_LayoutDirection)layoutDirection;


/**
 * 建立使用指定focus樣式的說明資料（不使用attribute中設定的focus樣式）
 *
 * @param guideFocusModel   指定的focus樣式
 * @param className         Class name of target view controller
 * @param guideIndex        Guide index of focus target view （如果是PPGuideDataModel_ReservedIndex_NoTarget，則info會顯示在screen中央。）
 * @param title             Title of guide info
 * @param message           Message of guide info
 * @param layoutDirection   Icon與訊息的相對位置方向
 *
 * @return PPGuideDataModel instance
 */
+ (PPGuideDataModel *)modelWithGuideFocusModel:(PPGuideFocusModel *)guideFocusModel
                               targetClassName:(NSString *)className
                                    guideIndex:(NSInteger)guideIndex
                                         title:(NSString *)title
                                       message:(NSString *)message
                               layoutDirection:(PPGuideDataModel_LayoutDirection)layoutDirection;


/**
 * 建立使用指定focus樣式的說明資料（不使用attribute中設定的focus樣式）
 *
 * @param guideFocusModel   指定的focus樣式
 * @param className         Class name of target view controller
 * @param guideIndex        Guide index of focus target view （如果是PPGuideDataModel_ReservedIndex_NoTarget，則info會顯示在screen中央。）
 * @param title             Title of guide info
 * @param message           Message of guide info
 * @param layoutDirection   Icon與訊息的相對位置方向
 * @param specialStyle      特殊樣式
 *
 * @return PPGuideDataModel instance
 */
+ (PPGuideDataModel *)modelWithGuideFocusModel:(PPGuideFocusModel *)guideFocusModel
                               targetClassName:(NSString *)className
                                    guideIndex:(NSInteger)guideIndex
                                         title:(NSString *)title
                                       message:(NSString *)message
                               layoutDirection:(PPGuideDataModel_LayoutDirection)layoutDirection
                                  specialStyle:(PPGuideDataModel_SpecialStyle)specialStyle;

@end
