//
//  PPCloud.h
//  
//
//  Created by Mike on 13/5/14.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPCloudAccountInfo.h"

// Define
#import "CrossPlatformDefine.h"
#import "PPCloud+ParameterDefine.h"

#import "PPCloudMetadata.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

extern NSString *PPCloud_RootPath;

extern NSString *PPCloud_ThumbnailSize_Maximum;
extern NSString *PPCloud_ThumbnailSize_Large;
extern NSString *PPCloud_ThumbnailSize_Medium;
extern NSString *PPCloud_ThumbnailSize_Small;
extern NSString *PPCloud_ThumbnailSize_Minimum;


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPCloud : NSObject
{
@protected
    NSOperationQueue    *operationQueue_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,readonly) NSOperationQueue  *operationQueue;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)initWithOperationQueue:(NSOperationQueue *)operationQueue;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overwrite Methods

- (BOOL)isLinked;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (id)parameterForKey:(NSString *)key;
+ (void)setParameter:(id)parameter forKey:(NSString *)key;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPCloudDelegate_Copy <NSObject>
@required
- (void)ppCloud:(PPCloud *)ppCloud copyPathFailedWithError:(NSError *)error userInfo:(id)userInfo;
- (void)ppCloud:(PPCloud *)ppCloud copiedPath:(NSString *)path to:(PPCloudMetadata *)to userInfo:(id)userInfo;
@end

@protocol PPCloudProtocol_Copy <NSObject>
@required
- (BOOL)copyFrom:(NSString *)fromPath toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Copy>)delegate userInfo:(id)userInfo;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPCloudDelegate_CreateFolder <NSObject>
@required
- (void)ppCloud:(PPCloud *)ppCloud createFolderFailedWithError:(NSError *)error userInfo:(id)userInfo;
- (void)ppCloud:(PPCloud *)ppCloud createdFolder:(PPCloudMetadata *)folder userInfo:(id)userInfo;
@end

@protocol PPCloudProtocol_CreateFolder <NSObject>
@required
- (BOOL)createFolder:(NSString *)createFolder delegate:(id<PPCloudDelegate_CreateFolder>)delegate userInfo:(id)userInfo;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPCloudDelegate_Delete <NSObject>
@required
- (void)ppCloud:(PPCloud *)ppCloud deletePathFailedWithError:(NSError *)error userInfo:(id)userInfo;
- (void)ppCloud:(PPCloud *)ppCloud deletePath:(NSString *)path userInfo:(id)userInfo;
@end

@protocol PPCloudProtocol_Delete <NSObject>
@required
- (BOOL)deletePath:(NSString *)deletePath delegate:(id<PPCloudDelegate_Delete>)delegate userInfo:(id)userInfo;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPCloudDelegate_Link <NSObject>
@required
- (void)ppCloud:(PPCloud *)ppCloud linkFailedWithError:(NSError *)error userInfo:(id)userInfo;
- (void)ppCloud:(PPCloud *)ppCloud linkSuccessWithUserInfo:(id)userInfo;
@end

@protocol PPCloudProtocol_Link <NSObject>
@required
- (BOOL)linkFromController:(CPCLViewController *)viewcontroller delegate:(id<PPCloudDelegate_Link>)delegate userInfo:(id)userInfo;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPCloudDelegate_LoadAccountInfo <NSObject>
@required
- (void)ppCloud:(PPCloud *)ppCloud loadAccountInfoFailedWithError:(NSError *)error userInfo:(id)userInfo;
- (void)ppCloud:(PPCloud *)ppCloud loadedAccountInfo:(PPCloudAccountInfo *)accountInfo userInfo:(id)userInfo;
@end

@protocol PPCloudProtocol_LoadAccountInfo <NSObject>
@required
- (BOOL)loadAccountInfoWithDelegate:(id<PPCloudDelegate_LoadAccountInfo>)delegate userInfo:(id)userInfo;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPCloudDelegate_LoadFile <NSObject>
@required
- (void)ppCloud:(PPCloud *)ppCloud loadFileFailedWithError:(NSError *)error userInfo:(id)userInfo;
- (void)ppCloud:(PPCloud *)ppCloud loadedFile:(NSString *)destPath userInfo:(id)userInfo;
@optional
- (void)ppCloud:(PPCloud *)ppCloud loadProgress:(CGFloat)progress forFile:(NSString *)destPath userInfo:(id)userInfo;
@end

@protocol PPCloudProtocol_LoadFile <NSObject>
@required

- (BOOL)loadFileFromPath:(NSString *)filePath
                orFileID:(NSString *)fileID
                intoPath:(NSString *)intoPath
                delegate:(id<PPCloudDelegate_LoadFile>)delegate
                userInfo:(id)userInfo;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPCloudDelegate_LoadMetadata <NSObject>
@required
- (void)ppCloud:(PPCloud *)ppCloud loadMetadataFailedWithError:(NSError *)error userInfo:(id)userInfo;
- (void)ppCloud:(PPCloud *)ppCloud loadedMetadata:(PPCloudMetadata *)metadata userInfo:(id)userInfo;
@end

@protocol PPCloudProtocol_LoadMetadata <NSObject>
@required
- (BOOL)loadMetadata:(NSString *)loadMetadata delegate:(id<PPCloudDelegate_LoadMetadata>)delegate userInfo:(id)userInfo;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPCloudDelegate_LoadThumbnail <NSObject>
@required
- (void)ppCloud:(PPCloud *)ppCloud loadThumbnailFailedWithError:(NSError *)error userInfo:(id)userInfo;
- (void)ppCloud:(PPCloud *)ppCloud loadedThumbnail:(NSString *)destPath userInfo:(id)userInfo;
@end

@protocol PPCloudProtocol_LoadThumbnail <NSObject>
@required
- (BOOL)loadThumbnail:(NSString *)loadThumbnail ofSize:(NSString *)size intoPath:(NSString *)intoPath delegate:(id<PPCloudDelegate_LoadThumbnail>)delegate userInfo:(id)userInfo;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPCloudDelegate_Move <NSObject>
@required
- (void)ppCloud:(PPCloud *)ppCloud movePathFailedWithError:(NSError *)error userInfo:(id)userInfo;
- (void)ppCloud:(PPCloud *)ppCloud movedPath:(NSString *)path to:(PPCloudMetadata *)to userInfo:(id)userInfo;
@end

@protocol PPCloudProtocol_Move <NSObject>
@required
- (BOOL)moveFrom:(NSString *)moveFrom toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Move>)delegate userInfo:(id)userInfo;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPCloudDelegate_Unlink <NSObject>
@required
- (void)ppCloud:(PPCloud *)ppCloud unlinkFailedWithError:(NSError *)error userInfo:(id)userInfo;
- (void)ppCloud:(PPCloud *)ppCloud unlinkSuccessWithUserInfo:(id)userInfo;
@end

@protocol PPCloudProtocol_Unlink <NSObject>
@required
- (BOOL)unlinkWithDelegate:(id<PPCloudDelegate_Unlink>)delegate userInfo:(id)userInfo;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPCloudDelegate_UploadFile <NSObject>
@required
- (void)ppCloud:(PPCloud *)ppCloud uploadFileFailedWithError:(NSError *)error userInfo:(id)userInfo;
- (void)ppCloud:(PPCloud *)ppCloud uploadedFile:(NSString *)destPath from:(NSString *)srcPath metadata:(PPCloudMetadata *)metadata userInfo:(id)userInfo;
@optional
- (void)ppCloud:(PPCloud *)ppCloud uploadProgress:(CGFloat)progress forFile:(NSString *)destPath from:(NSString *)srcPath userInfo:(id)userInfo;
@end

@protocol PPCloudProtocol_UploadFile <NSObject>
@required
- (BOOL)uploadFile:(NSString *)filename toPath:(NSString *)toPath fromPath:(NSString *)fromPath delegate:(id<PPCloudDelegate_UploadFile>)delegate userInfo:(id)userInfo;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPCloudDelegate_Sharedlink <NSObject>
@required
- (void)ppCloud:(PPCloud *)ppCloud sharedlinkFailedWithError:(NSError *)error userInfo:(id)userInfo;
- (void)ppCloud:(PPCloud *)ppCloud sharedlinkString:(NSString *)sharedlink userInfo:(id)userInfo;
@end

@protocol PPCloudProtocol_Sharedlink <NSObject>
@required
- (BOOL)sharedlinkFile:(NSString *)sharedlinkFile delegate:(id<PPCloudDelegate_Sharedlink>)delegate userInfo:(id)userInfo;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////
