//
//  CardImageBottomBarView.h
//  
//
//  Created by Howard.Lin on 13/12/25.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPBarView.h"
#import "PPButton.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, CardImageBottomBarViewButtonTag)
{
    CardImageBottomBarViewButtonTag_More,
    CardImageBottomBarViewButtonTag_Replace,
    CardImageBottomBarViewButtonTag_RotateLeft,
    CardImageBottomBarViewButtonTag_RotateRight,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@class CardImageBottomBarView;

@protocol CardImageBottomBarViewDelegate <NSObject>

@required

- (void)cardImageBottomBarView:(CardImageBottomBarView *)cardImageBottomBarView
                       ppButton:(PPButton *)button
                   controlEvent:(UIControlEvents)controlEvent;
    
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface CardImageBottomBarView : PPBarView <PPButtonDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)   id<CardImageBottomBarViewDelegate> delegate;
@property (nonatomic,readonly) PPButton *moreButton;
@property (nonatomic,readonly) PPButton *replaceImageButton;
@property (nonatomic,readonly) PPButton *rotateLeftButton;
@property (nonatomic,readonly) PPButton *rotateRightButton;

@end