//
//  PPCameraView+iOS.h
//  
//
//  Created by Howard on 2017/7/31.
//
//

#import <PPCameraView/PPCameraView.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 檢查相機權限結果處理函式定義
 
 @param granted 是否有權限
 */
typedef void (^CheckAuthorizationCompletionHandler)(BOOL granted);

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPCameraView (iOS)

#pragma mark - Instance Method

- (UIImage *)copyImageFromSampleBuffer:(CMSampleBufferRef)sampleBuffer;

- (UIImage *)copyOrientationAdjustedImageFromImage:(UIImage *)srcImage;

- (UIImage *)cropImageWithPreviewSize:(CGSize)previewSize image:(UIImage *)image;

/**
 檢查相機權限

 @param viewController 顯示alert的viewController
 @param handler 完成時的處理block，請參考CheckAuthorizationCompletionHandler說明
 */
+ (void)checkCameraAuthorizationWithViewController:(UIViewController *)viewController
                                completionHanadler:(CheckAuthorizationCompletionHandler)handler;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - 鏡頭相關

/**
 * 取得超廣角鏡頭
 * @return AVCaptureDevice
 */
+ (AVCaptureDevice *)ultraWideCamera;

/**
 * 取得廣角鏡頭
 * @return AVCaptureDevice
 */
+ (AVCaptureDevice *)wideAngleCamera;

/**
 * 判斷是否為三鏡頭相機
 * @return 可用相機類型
 */
+ (BOOL)isSupportTripleCamera;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - 設定PPCameraView中可支援的鏡頭

/**
 * 設定可用的相機類型，依順序，可取得的優先, 需在 | startCameraPreview |前設定
 * 預設為nil，使用廣角鏡頭
 * @param availableDeviceTypes
 */
+ (void)setAvailableDeviceTypes:(NSArray *)availableDeviceTypes;

/**
 * 取得可用相機類型
 * @return 可用相機類型
 */
+ (NSArray *)availableDeviceTypes;


@end
