//
//  MetalFunctionGenerateHDR.h
//  PPCameraView
//
//  Created by sanhue cheng on 2020/6/2.
//

#import <Foundation/Foundation.h>
#import <Metal/Metal.h>


NS_ASSUME_NONNULL_BEGIN

@interface MetalFunctionGenerateHDR : NSObject
- (nullable instancetype)initWithDevice:(nonnull id <MTLDevice>)device libray:(nonnull id<MTLLibrary>)library;

- (void)encodeToCommandBuffer:(nonnull id <MTLCommandBuffer>)commandBuffer
                  withOffsetX:(int *)offsetX
                      offsetY:(int *)offsetY
                   parameterA:(float *)parameterA
                   parameterB:(float *)parameterB
               sourceTexture0:(id<MTLTexture>)sourceTexture0
               sourceTexture1:(id<MTLTexture>)sourceTexture1
               sourceTexture2:(id<MTLTexture>)sourceTexture2
                resultTexture:(id<MTLTexture>)resultTexture
                    imageSize:(CGSize)imageSize;


@end

NS_ASSUME_NONNULL_END
