//
//  MetalFunctionAlignmentOffset.h
//  PPCameraView
//
//  Created by sanhue cheng on 2020/6/2.
//

#import <Foundation/Foundation.h>
#import <Metal/Metal.h>


NS_ASSUME_NONNULL_BEGIN

@interface MetalFunctionAlignmentOffset : NSObject
- (nullable instancetype)initWithDevice:(nonnull id <MTLDevice>)device libray:(nonnull id<MTLLibrary>)library;

- (void)encodeToCommandBuffer:(nonnull id <MTLCommandBuffer>)commandBuffer
            withStartPosition:(CGPoint)startPosition
                 stopPosition:(CGPoint)stopPosition
               offsetPosition:(CGPoint)offsetPosition
                     stepSize:(int)stepSize
                  baseTexture:(id<MTLTexture>)baseTexture
               compareTexture:(id<MTLTexture>)compareTexture
                 resultBuffer:(id<MTLBuffer>)resultBuffer
                    imageSize:(CGSize)imageSize;


@end

NS_ASSUME_NONNULL_END
