//
//  PPAutoResizedLabel.h
//
//  NOTE:
//  ------------------------------
//  1. 用constraint layout時，系統還是以原始大小做layout，
//     如果有物件用PPAutoResizedLabel的width/height/right/buttom做參照位置，顯示時會偏移。
//     （偏移量就是加入的contentInset）
//

#import <UIKit/UIKit.h>

@interface PPAutoResizedLabel : UILabel

/// 最大大小，預設為{0,0}，沒有限制。
@property (nonatomic, assign) CGSize maxSize;

/// 文字內容內縮大小
@property (nonatomic, assign) UIEdgeInsets contentInsets;

/// 寬度是否一定要大於高度，預設為NO。
@property (nonatomic, assign) BOOL widthMustLargerThenHeight;

/// 圓形顯示，預設為NO。
@property (nonatomic, assign) BOOL isCircleShape;


@end
