//
//  PPAlertController.h
//
//  Created by Howard.Lin on 2014/8/14.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>

#ifdef __IPHONE_8_0

NS_CLASS_AVAILABLE_IOS(8_0) @interface PPAlertController : UIAlertController


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (void)setAllowMultiAlert:(BOOL)allow;
+ (BOOL)isAllowMultiAlert;
+ (BOOL)canAlert;

+ (BOOL)alertController:(PPAlertController *)alertController addTextFieldHandle:(void (^)(UITextField *textField))configurationHandler ,... NS_REQUIRES_NIL_TERMINATION;


+ (PPAlertController *)alertControllerWithAlertControllerStyle:(UIAlertControllerStyle)alertControllerStyle
                                                         title:(NSString *)title
                                                       message:(NSString *)message
                                              alertActionStyle:(UIAlertActionStyle)alertActionStyle;

+ (PPAlertController *)alertControllerWithAlertControllerStyle:(UIAlertControllerStyle)alertControllerStyle
                                                         title:(NSString *)title
                                                       message:(NSString *)message
                                                   alertAction:(UIAlertAction *)alertAction, ... NS_REQUIRES_NIL_TERMINATION;



+ (BOOL)showWithAlertControllerStyle:(UIAlertControllerStyle)alertControllerStyle
                               title:(NSString *)title
                             message:(NSString *)message
                    alertActionStyle:(UIAlertActionStyle)alertActionStyle
              showFromViewController:(UIViewController *)viewController
                            animated:(BOOL)animated;


+ (BOOL)showWithAlertControllerStyle:(UIAlertControllerStyle)alertControllerStyle
                               title:(NSString *)title
                             message:(NSString *)message
              showFromViewController:(UIViewController *)viewController
                            animated:(BOOL)animated
                         alertAction:(UIAlertAction *)alertAction, ... NS_REQUIRES_NIL_TERMINATION;


@end

#endif