//
//  AlbumCollectionViewCell.h
//
//  Created by howard.lin on 13/3/11.
//  Copyright (c) 2013年 penpower. All rights reserved.
//

#import <UIKit/UIKit.h>

// View
#import "PPButton.h"
#import "PPSelectImageView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AlbumColletcionViewCellDelegate

@class AlbumCollectionViewCell;

@protocol AlbumColletcionViewCellDelegate <NSObject>

- (BOOL)albumViewCollectionCellShouldTouch:(AlbumCollectionViewCell *)albumCollectionViewCell;
- (void)albumViewCollectionCellTouchBegin:(AlbumCollectionViewCell *)albumCollectionViewCell;
- (void)albumViewCollectionCellTouchEnd:(AlbumCollectionViewCell *)albumCollectionViewCell;

@end



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - AlbumCollectionViewCell

@interface AlbumCollectionViewCell : UIView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property
@property (nonatomic,assign) id<AlbumColletcionViewCellDelegate> delegate;

@property (nonatomic,assign) BOOL      shouldSendTouchEnd;
@property (nonatomic,assign) NSInteger index;
@property (nonatomic,retain) UIImage   *cellImage;
@property (nonatomic,retain) PPSelectImageView *selectImageView;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (void)prepareForReuse;

- (void)enable;
- (void)disable;

- (void)refresh;

@end
