//
//  PPActivityIndicatorView.h
//

#import <UIKit/UIKit.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

/// GradientCircleStyle的預設大小
static CGFloat const PPAIV_GradientCircleStyleDefaultSize = 40.0;

/// SystemStyle的預設大小
static CGFloat const PPAIV_SystemStyleDefaultSize = 30.0;

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_OPTIONS(NSInteger, PPActivityIndicatorViewStyle)
{
    PPActivityIndicatorViewStyleNone = 0,
    PPActivityIndicatorViewStyleSystem,
    PPActivityIndicatorViewStyleGradientCircle,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

/// Simulate UIActivityIndicatorView
@interface PPActivityIndicatorView : UIView



//////////////////////////////////////////////////
#pragma mark - Property

/// 顯示樣式(Number of PPActivityIndicatorViewStyle) (支援appearance)
@property (nonatomic, assign) PPActivityIndicatorViewStyle style UI_APPEARANCE_SELECTOR;

/// 線條顏色 (支援appearance)
@property (nonatomic, retain) UIColor *lineColor UI_APPEARANCE_SELECTOR;

/// 目前顯示的步驟 (0.0 ~ 1.0)
@property (nonatomic, readonly) CGFloat currentProgress;



//////////////////////////////////////////////////
#pragma mark - Instance methods

/**
 * Start animatiing (async)
 */
- (void)startAnimating;

/**
 * Stop animatiing (async)
 */
- (void)stopAnimating;

/**
 * Check if indicator is animation
 */
- (BOOL)isAnimating;

/**
 * Update display progress (async)
 *
 * @param currentProgress - Current progress from 0.0 to 1.0.
 * @param visibleHeight - 最大可見高度，超過這個高度的部分不會顯示。nil代表不檢查，全部顯示。
 *
 */
- (void)updateCurrentProgress:(CGFloat)currentProgress withVisibleHeight:(NSNumber *)visibleHeight;


@end
