///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBUSERSPaperAsFilesValue;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperAsFilesValue` union.
///
/// The value for `paperAsFiles` in `DBUSERSUserFeature`.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBUSERSPaperAsFilesValue : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBUSERSPaperAsFilesValueTag` enum type represents the possible tag
/// states with which the `DBUSERSPaperAsFilesValue` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBUSERSPaperAsFilesValueTag){
    /// When this value is true, the user's Paper docs are accessible in Dropbox
    /// with the .paper extension and must be accessed via the /files endpoints.
    /// When this value is false, the user's Paper docs are stored separate from
    /// Dropbox files and folders and should be accessed via the /paper
    /// endpoints.
    DBUSERSPaperAsFilesValueEnabled,

    /// (no description).
    DBUSERSPaperAsFilesValueOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBUSERSPaperAsFilesValueTag tag;

/// When this value is true, the user's Paper docs are accessible in Dropbox
/// with the .paper extension and must be accessed via the /files endpoints.
/// When this value is false, the user's Paper docs are stored separate from
/// Dropbox files and folders and should be accessed via the /paper endpoints.
/// @note Ensure the `isEnabled` method returns true before accessing, otherwise
/// a runtime exception will be raised.
@property (nonatomic, readonly) NSNumber *enabled;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "enabled".
///
/// Description of the "enabled" tag state: When this value is true, the user's
/// Paper docs are accessible in Dropbox with the .paper extension and must be
/// accessed via the /files endpoints.  When this value is false, the user's
/// Paper docs are stored separate from Dropbox files and folders and should be
/// accessed via the /paper endpoints.
///
/// @param enabled When this value is true, the user's Paper docs are accessible
/// in Dropbox with the .paper extension and must be accessed via the /files
/// endpoints.  When this value is false, the user's Paper docs are stored
/// separate from Dropbox files and folders and should be accessed via the
/// /paper endpoints.
///
/// @return An initialized instance.
///
- (instancetype)initWithEnabled:(NSNumber *)enabled;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "enabled".
///
/// @note Call this method and ensure it returns true before accessing the
/// `enabled` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "enabled".
///
- (BOOL)isEnabled;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBUSERSPaperAsFilesValue` union.
///
@interface DBUSERSPaperAsFilesValueSerializer : NSObject

///
/// Serializes `DBUSERSPaperAsFilesValue` instances.
///
/// @param instance An instance of the `DBUSERSPaperAsFilesValue` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBUSERSPaperAsFilesValue` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBUSERSPaperAsFilesValue *)instance;

///
/// Deserializes `DBUSERSPaperAsFilesValue` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBUSERSPaperAsFilesValue` API object.
///
/// @return An instantiation of the `DBUSERSPaperAsFilesValue` object.
///
+ (DBUSERSPaperAsFilesValue *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
