///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMUserCustomQuotaResult;
@class DBTEAMUserSelectorArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UserCustomQuotaResult` struct.
///
/// User and their custom quota in GB (1 TB = 1024 GB).  No quota returns if the
/// user has no custom quota set.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMUserCustomQuotaResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// (no description).
@property (nonatomic, readonly) DBTEAMUserSelectorArg *user;

/// (no description).
@property (nonatomic, readonly, nullable) NSNumber *quotaGb;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param user (no description).
/// @param quotaGb (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user quotaGb:(nullable NSNumber *)quotaGb;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param user (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `UserCustomQuotaResult` struct.
///
@interface DBTEAMUserCustomQuotaResultSerializer : NSObject

///
/// Serializes `DBTEAMUserCustomQuotaResult` instances.
///
/// @param instance An instance of the `DBTEAMUserCustomQuotaResult` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMUserCustomQuotaResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMUserCustomQuotaResult *)instance;

///
/// Deserializes `DBTEAMUserCustomQuotaResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMUserCustomQuotaResult` API object.
///
/// @return An instantiation of the `DBTEAMUserCustomQuotaResult` object.
///
+ (DBTEAMUserCustomQuotaResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
