///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMResendSecondaryEmailResult;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ResendSecondaryEmailResult` union.
///
/// Result of trying to resend verification email to a secondary email address.
/// 'success' is the only value indicating that a verification email was
/// successfully sent. The other values explain the type of error that occurred,
/// and include the email for which the error occured.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMResendSecondaryEmailResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMResendSecondaryEmailResultTag` enum type represents the possible
/// tag states with which the `DBTEAMResendSecondaryEmailResult` union can
/// exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMResendSecondaryEmailResultTag){
    /// A verification email was successfully sent to the secondary email
    /// address.
    DBTEAMResendSecondaryEmailResultSuccess,

    /// This secondary email address is not pending for the user.
    DBTEAMResendSecondaryEmailResultNotPending,

    /// Too many emails are being sent to this email address. Please try again
    /// later.
    DBTEAMResendSecondaryEmailResultRateLimited,

    /// (no description).
    DBTEAMResendSecondaryEmailResultOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMResendSecondaryEmailResultTag tag;

/// A verification email was successfully sent to the secondary email address.
/// @note Ensure the `isSuccess` method returns true before accessing, otherwise
/// a runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *success;

/// This secondary email address is not pending for the user. @note Ensure the
/// `isNotPending` method returns true before accessing, otherwise a runtime
/// exception will be raised.
@property (nonatomic, readonly, copy) NSString *notPending;

/// Too many emails are being sent to this email address. Please try again
/// later. @note Ensure the `isRateLimited` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *rateLimited;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "success".
///
/// Description of the "success" tag state: A verification email was
/// successfully sent to the secondary email address.
///
/// @param success A verification email was successfully sent to the secondary
/// email address.
///
/// @return An initialized instance.
///
- (instancetype)initWithSuccess:(NSString *)success;

///
/// Initializes union class with tag state of "not_pending".
///
/// Description of the "not_pending" tag state: This secondary email address is
/// not pending for the user.
///
/// @param notPending This secondary email address is not pending for the user.
///
/// @return An initialized instance.
///
- (instancetype)initWithNotPending:(NSString *)notPending;

///
/// Initializes union class with tag state of "rate_limited".
///
/// Description of the "rate_limited" tag state: Too many emails are being sent
/// to this email address. Please try again later.
///
/// @param rateLimited Too many emails are being sent to this email address.
/// Please try again later.
///
/// @return An initialized instance.
///
- (instancetype)initWithRateLimited:(NSString *)rateLimited;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "success".
///
/// @note Call this method and ensure it returns true before accessing the
/// `success` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "success".
///
- (BOOL)isSuccess;

///
/// Retrieves whether the union's current tag state has value "not_pending".
///
/// @note Call this method and ensure it returns true before accessing the
/// `notPending` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "not_pending".
///
- (BOOL)isNotPending;

///
/// Retrieves whether the union's current tag state has value "rate_limited".
///
/// @note Call this method and ensure it returns true before accessing the
/// `rateLimited` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "rate_limited".
///
- (BOOL)isRateLimited;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMResendSecondaryEmailResult` union.
///
@interface DBTEAMResendSecondaryEmailResultSerializer : NSObject

///
/// Serializes `DBTEAMResendSecondaryEmailResult` instances.
///
/// @param instance An instance of the `DBTEAMResendSecondaryEmailResult` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMResendSecondaryEmailResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMResendSecondaryEmailResult *)instance;

///
/// Deserializes `DBTEAMResendSecondaryEmailResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMResendSecondaryEmailResult` API object.
///
/// @return An instantiation of the `DBTEAMResendSecondaryEmailResult` object.
///
+ (DBTEAMResendSecondaryEmailResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
