///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMMembersTransferFormerMembersFilesError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MembersTransferFormerMembersFilesError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMMembersTransferFormerMembersFilesError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMMembersTransferFormerMembersFilesErrorTag` enum type represents
/// the possible tag states with which the
/// `DBTEAMMembersTransferFormerMembersFilesError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMMembersTransferFormerMembersFilesErrorTag){
    /// No matching user found. The provided team_member_id, email, or
    /// external_id does not exist on this team.
    DBTEAMMembersTransferFormerMembersFilesErrorUserNotFound,

    /// The user is not a member of the team.
    DBTEAMMembersTransferFormerMembersFilesErrorUserNotInTeam,

    /// (no description).
    DBTEAMMembersTransferFormerMembersFilesErrorOther,

    /// Expected removed user and transfer_dest user to be different.
    DBTEAMMembersTransferFormerMembersFilesErrorRemovedAndTransferDestShouldDiffer,

    /// Expected removed user and transfer_admin user to be different.
    DBTEAMMembersTransferFormerMembersFilesErrorRemovedAndTransferAdminShouldDiffer,

    /// No matching user found for the argument transfer_dest_id.
    DBTEAMMembersTransferFormerMembersFilesErrorTransferDestUserNotFound,

    /// The provided transfer_dest_id does not exist on this team.
    DBTEAMMembersTransferFormerMembersFilesErrorTransferDestUserNotInTeam,

    /// The provided transfer_admin_id does not exist on this team.
    DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminUserNotInTeam,

    /// No matching user found for the argument transfer_admin_id.
    DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminUserNotFound,

    /// The transfer_admin_id argument must be provided when file transfer is
    /// requested.
    DBTEAMMembersTransferFormerMembersFilesErrorUnspecifiedTransferAdminId,

    /// Specified transfer_admin user is not a team admin.
    DBTEAMMembersTransferFormerMembersFilesErrorTransferAdminIsNotAdmin,

    /// The recipient user's email is not verified.
    DBTEAMMembersTransferFormerMembersFilesErrorRecipientNotVerified,

    /// The user's data is being transferred. Please wait some time before
    /// retrying.
    DBTEAMMembersTransferFormerMembersFilesErrorUserDataIsBeingTransferred,

    /// No matching removed user found for the argument user.
    DBTEAMMembersTransferFormerMembersFilesErrorUserNotRemoved,

    /// User files aren't transferable anymore.
    DBTEAMMembersTransferFormerMembersFilesErrorUserDataCannotBeTransferred,

    /// User's data has already been transferred to another user.
    DBTEAMMembersTransferFormerMembersFilesErrorUserDataAlreadyTransferred,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMMembersTransferFormerMembersFilesErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "user_not_found".
///
/// Description of the "user_not_found" tag state: No matching user found. The
/// provided team_member_id, email, or external_id does not exist on this team.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserNotFound;

///
/// Initializes union class with tag state of "user_not_in_team".
///
/// Description of the "user_not_in_team" tag state: The user is not a member of
/// the team.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserNotInTeam;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

///
/// Initializes union class with tag state of
/// "removed_and_transfer_dest_should_differ".
///
/// Description of the "removed_and_transfer_dest_should_differ" tag state:
/// Expected removed user and transfer_dest user to be different.
///
/// @return An initialized instance.
///
- (instancetype)initWithRemovedAndTransferDestShouldDiffer;

///
/// Initializes union class with tag state of
/// "removed_and_transfer_admin_should_differ".
///
/// Description of the "removed_and_transfer_admin_should_differ" tag state:
/// Expected removed user and transfer_admin user to be different.
///
/// @return An initialized instance.
///
- (instancetype)initWithRemovedAndTransferAdminShouldDiffer;

///
/// Initializes union class with tag state of "transfer_dest_user_not_found".
///
/// Description of the "transfer_dest_user_not_found" tag state: No matching
/// user found for the argument transfer_dest_id.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransferDestUserNotFound;

///
/// Initializes union class with tag state of "transfer_dest_user_not_in_team".
///
/// Description of the "transfer_dest_user_not_in_team" tag state: The provided
/// transfer_dest_id does not exist on this team.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransferDestUserNotInTeam;

///
/// Initializes union class with tag state of "transfer_admin_user_not_in_team".
///
/// Description of the "transfer_admin_user_not_in_team" tag state: The provided
/// transfer_admin_id does not exist on this team.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransferAdminUserNotInTeam;

///
/// Initializes union class with tag state of "transfer_admin_user_not_found".
///
/// Description of the "transfer_admin_user_not_found" tag state: No matching
/// user found for the argument transfer_admin_id.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransferAdminUserNotFound;

///
/// Initializes union class with tag state of "unspecified_transfer_admin_id".
///
/// Description of the "unspecified_transfer_admin_id" tag state: The
/// transfer_admin_id argument must be provided when file transfer is requested.
///
/// @return An initialized instance.
///
- (instancetype)initWithUnspecifiedTransferAdminId;

///
/// Initializes union class with tag state of "transfer_admin_is_not_admin".
///
/// Description of the "transfer_admin_is_not_admin" tag state: Specified
/// transfer_admin user is not a team admin.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransferAdminIsNotAdmin;

///
/// Initializes union class with tag state of "recipient_not_verified".
///
/// Description of the "recipient_not_verified" tag state: The recipient user's
/// email is not verified.
///
/// @return An initialized instance.
///
- (instancetype)initWithRecipientNotVerified;

///
/// Initializes union class with tag state of "user_data_is_being_transferred".
///
/// Description of the "user_data_is_being_transferred" tag state: The user's
/// data is being transferred. Please wait some time before retrying.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserDataIsBeingTransferred;

///
/// Initializes union class with tag state of "user_not_removed".
///
/// Description of the "user_not_removed" tag state: No matching removed user
/// found for the argument user.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserNotRemoved;

///
/// Initializes union class with tag state of "user_data_cannot_be_transferred".
///
/// Description of the "user_data_cannot_be_transferred" tag state: User files
/// aren't transferable anymore.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserDataCannotBeTransferred;

///
/// Initializes union class with tag state of "user_data_already_transferred".
///
/// Description of the "user_data_already_transferred" tag state: User's data
/// has already been transferred to another user.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserDataAlreadyTransferred;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "user_not_found".
///
/// @return Whether the union's current tag state has value "user_not_found".
///
- (BOOL)isUserNotFound;

///
/// Retrieves whether the union's current tag state has value
/// "user_not_in_team".
///
/// @return Whether the union's current tag state has value "user_not_in_team".
///
- (BOOL)isUserNotInTeam;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves whether the union's current tag state has value
/// "removed_and_transfer_dest_should_differ".
///
/// @return Whether the union's current tag state has value
/// "removed_and_transfer_dest_should_differ".
///
- (BOOL)isRemovedAndTransferDestShouldDiffer;

///
/// Retrieves whether the union's current tag state has value
/// "removed_and_transfer_admin_should_differ".
///
/// @return Whether the union's current tag state has value
/// "removed_and_transfer_admin_should_differ".
///
- (BOOL)isRemovedAndTransferAdminShouldDiffer;

///
/// Retrieves whether the union's current tag state has value
/// "transfer_dest_user_not_found".
///
/// @return Whether the union's current tag state has value
/// "transfer_dest_user_not_found".
///
- (BOOL)isTransferDestUserNotFound;

///
/// Retrieves whether the union's current tag state has value
/// "transfer_dest_user_not_in_team".
///
/// @return Whether the union's current tag state has value
/// "transfer_dest_user_not_in_team".
///
- (BOOL)isTransferDestUserNotInTeam;

///
/// Retrieves whether the union's current tag state has value
/// "transfer_admin_user_not_in_team".
///
/// @return Whether the union's current tag state has value
/// "transfer_admin_user_not_in_team".
///
- (BOOL)isTransferAdminUserNotInTeam;

///
/// Retrieves whether the union's current tag state has value
/// "transfer_admin_user_not_found".
///
/// @return Whether the union's current tag state has value
/// "transfer_admin_user_not_found".
///
- (BOOL)isTransferAdminUserNotFound;

///
/// Retrieves whether the union's current tag state has value
/// "unspecified_transfer_admin_id".
///
/// @return Whether the union's current tag state has value
/// "unspecified_transfer_admin_id".
///
- (BOOL)isUnspecifiedTransferAdminId;

///
/// Retrieves whether the union's current tag state has value
/// "transfer_admin_is_not_admin".
///
/// @return Whether the union's current tag state has value
/// "transfer_admin_is_not_admin".
///
- (BOOL)isTransferAdminIsNotAdmin;

///
/// Retrieves whether the union's current tag state has value
/// "recipient_not_verified".
///
/// @return Whether the union's current tag state has value
/// "recipient_not_verified".
///
- (BOOL)isRecipientNotVerified;

///
/// Retrieves whether the union's current tag state has value
/// "user_data_is_being_transferred".
///
/// @return Whether the union's current tag state has value
/// "user_data_is_being_transferred".
///
- (BOOL)isUserDataIsBeingTransferred;

///
/// Retrieves whether the union's current tag state has value
/// "user_not_removed".
///
/// @return Whether the union's current tag state has value "user_not_removed".
///
- (BOOL)isUserNotRemoved;

///
/// Retrieves whether the union's current tag state has value
/// "user_data_cannot_be_transferred".
///
/// @return Whether the union's current tag state has value
/// "user_data_cannot_be_transferred".
///
- (BOOL)isUserDataCannotBeTransferred;

///
/// Retrieves whether the union's current tag state has value
/// "user_data_already_transferred".
///
/// @return Whether the union's current tag state has value
/// "user_data_already_transferred".
///
- (BOOL)isUserDataAlreadyTransferred;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the
/// `DBTEAMMembersTransferFormerMembersFilesError` union.
///
@interface DBTEAMMembersTransferFormerMembersFilesErrorSerializer : NSObject

///
/// Serializes `DBTEAMMembersTransferFormerMembersFilesError` instances.
///
/// @param instance An instance of the
/// `DBTEAMMembersTransferFormerMembersFilesError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMMembersTransferFormerMembersFilesError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersTransferFormerMembersFilesError *)instance;

///
/// Deserializes `DBTEAMMembersTransferFormerMembersFilesError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMMembersTransferFormerMembersFilesError` API object.
///
/// @return An instantiation of the
/// `DBTEAMMembersTransferFormerMembersFilesError` object.
///
+ (DBTEAMMembersTransferFormerMembersFilesError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
