///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMMembersTransferFilesError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MembersTransferFilesError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMMembersTransferFilesError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMMembersTransferFilesErrorTag` enum type represents the possible
/// tag states with which the `DBTEAMMembersTransferFilesError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMMembersTransferFilesErrorTag){
    /// No matching user found. The provided team_member_id, email, or
    /// external_id does not exist on this team.
    DBTEAMMembersTransferFilesErrorUserNotFound,

    /// The user is not a member of the team.
    DBTEAMMembersTransferFilesErrorUserNotInTeam,

    /// (no description).
    DBTEAMMembersTransferFilesErrorOther,

    /// Expected removed user and transfer_dest user to be different.
    DBTEAMMembersTransferFilesErrorRemovedAndTransferDestShouldDiffer,

    /// Expected removed user and transfer_admin user to be different.
    DBTEAMMembersTransferFilesErrorRemovedAndTransferAdminShouldDiffer,

    /// No matching user found for the argument transfer_dest_id.
    DBTEAMMembersTransferFilesErrorTransferDestUserNotFound,

    /// The provided transfer_dest_id does not exist on this team.
    DBTEAMMembersTransferFilesErrorTransferDestUserNotInTeam,

    /// The provided transfer_admin_id does not exist on this team.
    DBTEAMMembersTransferFilesErrorTransferAdminUserNotInTeam,

    /// No matching user found for the argument transfer_admin_id.
    DBTEAMMembersTransferFilesErrorTransferAdminUserNotFound,

    /// The transfer_admin_id argument must be provided when file transfer is
    /// requested.
    DBTEAMMembersTransferFilesErrorUnspecifiedTransferAdminId,

    /// Specified transfer_admin user is not a team admin.
    DBTEAMMembersTransferFilesErrorTransferAdminIsNotAdmin,

    /// The recipient user's email is not verified.
    DBTEAMMembersTransferFilesErrorRecipientNotVerified,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMMembersTransferFilesErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "user_not_found".
///
/// Description of the "user_not_found" tag state: No matching user found. The
/// provided team_member_id, email, or external_id does not exist on this team.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserNotFound;

///
/// Initializes union class with tag state of "user_not_in_team".
///
/// Description of the "user_not_in_team" tag state: The user is not a member of
/// the team.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserNotInTeam;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

///
/// Initializes union class with tag state of
/// "removed_and_transfer_dest_should_differ".
///
/// Description of the "removed_and_transfer_dest_should_differ" tag state:
/// Expected removed user and transfer_dest user to be different.
///
/// @return An initialized instance.
///
- (instancetype)initWithRemovedAndTransferDestShouldDiffer;

///
/// Initializes union class with tag state of
/// "removed_and_transfer_admin_should_differ".
///
/// Description of the "removed_and_transfer_admin_should_differ" tag state:
/// Expected removed user and transfer_admin user to be different.
///
/// @return An initialized instance.
///
- (instancetype)initWithRemovedAndTransferAdminShouldDiffer;

///
/// Initializes union class with tag state of "transfer_dest_user_not_found".
///
/// Description of the "transfer_dest_user_not_found" tag state: No matching
/// user found for the argument transfer_dest_id.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransferDestUserNotFound;

///
/// Initializes union class with tag state of "transfer_dest_user_not_in_team".
///
/// Description of the "transfer_dest_user_not_in_team" tag state: The provided
/// transfer_dest_id does not exist on this team.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransferDestUserNotInTeam;

///
/// Initializes union class with tag state of "transfer_admin_user_not_in_team".
///
/// Description of the "transfer_admin_user_not_in_team" tag state: The provided
/// transfer_admin_id does not exist on this team.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransferAdminUserNotInTeam;

///
/// Initializes union class with tag state of "transfer_admin_user_not_found".
///
/// Description of the "transfer_admin_user_not_found" tag state: No matching
/// user found for the argument transfer_admin_id.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransferAdminUserNotFound;

///
/// Initializes union class with tag state of "unspecified_transfer_admin_id".
///
/// Description of the "unspecified_transfer_admin_id" tag state: The
/// transfer_admin_id argument must be provided when file transfer is requested.
///
/// @return An initialized instance.
///
- (instancetype)initWithUnspecifiedTransferAdminId;

///
/// Initializes union class with tag state of "transfer_admin_is_not_admin".
///
/// Description of the "transfer_admin_is_not_admin" tag state: Specified
/// transfer_admin user is not a team admin.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransferAdminIsNotAdmin;

///
/// Initializes union class with tag state of "recipient_not_verified".
///
/// Description of the "recipient_not_verified" tag state: The recipient user's
/// email is not verified.
///
/// @return An initialized instance.
///
- (instancetype)initWithRecipientNotVerified;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "user_not_found".
///
/// @return Whether the union's current tag state has value "user_not_found".
///
- (BOOL)isUserNotFound;

///
/// Retrieves whether the union's current tag state has value
/// "user_not_in_team".
///
/// @return Whether the union's current tag state has value "user_not_in_team".
///
- (BOOL)isUserNotInTeam;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves whether the union's current tag state has value
/// "removed_and_transfer_dest_should_differ".
///
/// @return Whether the union's current tag state has value
/// "removed_and_transfer_dest_should_differ".
///
- (BOOL)isRemovedAndTransferDestShouldDiffer;

///
/// Retrieves whether the union's current tag state has value
/// "removed_and_transfer_admin_should_differ".
///
/// @return Whether the union's current tag state has value
/// "removed_and_transfer_admin_should_differ".
///
- (BOOL)isRemovedAndTransferAdminShouldDiffer;

///
/// Retrieves whether the union's current tag state has value
/// "transfer_dest_user_not_found".
///
/// @return Whether the union's current tag state has value
/// "transfer_dest_user_not_found".
///
- (BOOL)isTransferDestUserNotFound;

///
/// Retrieves whether the union's current tag state has value
/// "transfer_dest_user_not_in_team".
///
/// @return Whether the union's current tag state has value
/// "transfer_dest_user_not_in_team".
///
- (BOOL)isTransferDestUserNotInTeam;

///
/// Retrieves whether the union's current tag state has value
/// "transfer_admin_user_not_in_team".
///
/// @return Whether the union's current tag state has value
/// "transfer_admin_user_not_in_team".
///
- (BOOL)isTransferAdminUserNotInTeam;

///
/// Retrieves whether the union's current tag state has value
/// "transfer_admin_user_not_found".
///
/// @return Whether the union's current tag state has value
/// "transfer_admin_user_not_found".
///
- (BOOL)isTransferAdminUserNotFound;

///
/// Retrieves whether the union's current tag state has value
/// "unspecified_transfer_admin_id".
///
/// @return Whether the union's current tag state has value
/// "unspecified_transfer_admin_id".
///
- (BOOL)isUnspecifiedTransferAdminId;

///
/// Retrieves whether the union's current tag state has value
/// "transfer_admin_is_not_admin".
///
/// @return Whether the union's current tag state has value
/// "transfer_admin_is_not_admin".
///
- (BOOL)isTransferAdminIsNotAdmin;

///
/// Retrieves whether the union's current tag state has value
/// "recipient_not_verified".
///
/// @return Whether the union's current tag state has value
/// "recipient_not_verified".
///
- (BOOL)isRecipientNotVerified;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMMembersTransferFilesError` union.
///
@interface DBTEAMMembersTransferFilesErrorSerializer : NSObject

///
/// Serializes `DBTEAMMembersTransferFilesError` instances.
///
/// @param instance An instance of the `DBTEAMMembersTransferFilesError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMMembersTransferFilesError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersTransferFilesError *)instance;

///
/// Deserializes `DBTEAMMembersTransferFilesError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMMembersTransferFilesError` API object.
///
/// @return An instantiation of the `DBTEAMMembersTransferFilesError` object.
///
+ (DBTEAMMembersTransferFilesError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
