///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMListTeamAppsError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ListTeamAppsError` union.
///
/// Error returned by `linkedAppsListTeamLinkedApps`.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMListTeamAppsError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMListTeamAppsErrorTag` enum type represents the possible tag
/// states with which the `DBTEAMListTeamAppsError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMListTeamAppsErrorTag){
    /// Indicates that the cursor has been invalidated. Call
    /// `linkedAppsListTeamLinkedApps` again with an empty cursor to obtain a
    /// new cursor.
    DBTEAMListTeamAppsErrorReset,

    /// (no description).
    DBTEAMListTeamAppsErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMListTeamAppsErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "reset".
///
/// Description of the "reset" tag state: Indicates that the cursor has been
/// invalidated. Call `linkedAppsListTeamLinkedApps` again with an empty cursor
/// to obtain a new cursor.
///
/// @return An initialized instance.
///
- (instancetype)initWithReset;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "reset".
///
/// @return Whether the union's current tag state has value "reset".
///
- (BOOL)isReset;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMListTeamAppsError` union.
///
@interface DBTEAMListTeamAppsErrorSerializer : NSObject

///
/// Serializes `DBTEAMListTeamAppsError` instances.
///
/// @param instance An instance of the `DBTEAMListTeamAppsError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMListTeamAppsError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMListTeamAppsError *)instance;

///
/// Deserializes `DBTEAMListTeamAppsError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMListTeamAppsError` API object.
///
/// @return An instantiation of the `DBTEAMListTeamAppsError` object.
///
+ (DBTEAMListTeamAppsError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
