///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMListMembersDevicesResult;
@class DBTEAMMemberDevices;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ListMembersDevicesResult` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMListMembersDevicesResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The devices of each member of the team.
@property (nonatomic, readonly) NSArray<DBTEAMMemberDevices *> *devices;

/// If true, then there are more devices available. Pass the cursor to
/// `devicesListMembersDevices` to retrieve the rest.
@property (nonatomic, readonly) NSNumber *hasMore;

/// Pass the cursor into `devicesListMembersDevices` to receive the next sub
/// list of team's devices.
@property (nonatomic, readonly, copy, nullable) NSString *cursor;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param devices The devices of each member of the team.
/// @param hasMore If true, then there are more devices available. Pass the
/// cursor to `devicesListMembersDevices` to retrieve the rest.
/// @param cursor Pass the cursor into `devicesListMembersDevices` to receive
/// the next sub list of team's devices.
///
/// @return An initialized instance.
///
- (instancetype)initWithDevices:(NSArray<DBTEAMMemberDevices *> *)devices
                        hasMore:(NSNumber *)hasMore
                         cursor:(nullable NSString *)cursor;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param devices The devices of each member of the team.
/// @param hasMore If true, then there are more devices available. Pass the
/// cursor to `devicesListMembersDevices` to retrieve the rest.
///
/// @return An initialized instance.
///
- (instancetype)initWithDevices:(NSArray<DBTEAMMemberDevices *> *)devices hasMore:(NSNumber *)hasMore;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ListMembersDevicesResult` struct.
///
@interface DBTEAMListMembersDevicesResultSerializer : NSObject

///
/// Serializes `DBTEAMListMembersDevicesResult` instances.
///
/// @param instance An instance of the `DBTEAMListMembersDevicesResult` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMListMembersDevicesResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMListMembersDevicesResult *)instance;

///
/// Deserializes `DBTEAMListMembersDevicesResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMListMembersDevicesResult` API object.
///
/// @return An instantiation of the `DBTEAMListMembersDevicesResult` object.
///
+ (DBTEAMListMembersDevicesResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
