///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLegalHoldsPolicyCreateError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `LegalHoldsPolicyCreateError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLegalHoldsPolicyCreateError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLegalHoldsPolicyCreateErrorTag` enum type represents the possible
/// tag states with which the `DBTEAMLegalHoldsPolicyCreateError` union can
/// exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLegalHoldsPolicyCreateErrorTag){
    /// There has been an unknown legal hold error.
    DBTEAMLegalHoldsPolicyCreateErrorUnknownLegalHoldError,

    /// You don't have permissions to perform this action.
    DBTEAMLegalHoldsPolicyCreateErrorInsufficientPermissions,

    /// (no description).
    DBTEAMLegalHoldsPolicyCreateErrorOther,

    /// Start date must be earlier than end date.
    DBTEAMLegalHoldsPolicyCreateErrorStartDateIsLaterThanEndDate,

    /// The users list must have at least one user.
    DBTEAMLegalHoldsPolicyCreateErrorEmptyMembersList,

    /// Some members in the members list are not valid to be placed under legal
    /// hold.
    DBTEAMLegalHoldsPolicyCreateErrorInvalidMembers,

    /// You cannot add more than 5 users in a legal hold.
    DBTEAMLegalHoldsPolicyCreateErrorNumberOfUsersOnHoldIsGreaterThanHoldLimitation,

    /// Temporary infrastructure failure, please retry.
    DBTEAMLegalHoldsPolicyCreateErrorTransientError,

    /// The name provided is already in use by another legal hold.
    DBTEAMLegalHoldsPolicyCreateErrorNameMustBeUnique,

    /// Team exceeded legal hold quota.
    DBTEAMLegalHoldsPolicyCreateErrorTeamExceededLegalHoldQuota,

    /// The provided date is invalid.
    DBTEAMLegalHoldsPolicyCreateErrorInvalidDate,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLegalHoldsPolicyCreateErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "unknown_legal_hold_error".
///
/// Description of the "unknown_legal_hold_error" tag state: There has been an
/// unknown legal hold error.
///
/// @return An initialized instance.
///
- (instancetype)initWithUnknownLegalHoldError;

///
/// Initializes union class with tag state of "insufficient_permissions".
///
/// Description of the "insufficient_permissions" tag state: You don't have
/// permissions to perform this action.
///
/// @return An initialized instance.
///
- (instancetype)initWithInsufficientPermissions;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

///
/// Initializes union class with tag state of
/// "start_date_is_later_than_end_date".
///
/// Description of the "start_date_is_later_than_end_date" tag state: Start date
/// must be earlier than end date.
///
/// @return An initialized instance.
///
- (instancetype)initWithStartDateIsLaterThanEndDate;

///
/// Initializes union class with tag state of "empty_members_list".
///
/// Description of the "empty_members_list" tag state: The users list must have
/// at least one user.
///
/// @return An initialized instance.
///
- (instancetype)initWithEmptyMembersList;

///
/// Initializes union class with tag state of "invalid_members".
///
/// Description of the "invalid_members" tag state: Some members in the members
/// list are not valid to be placed under legal hold.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidMembers;

///
/// Initializes union class with tag state of
/// "number_of_users_on_hold_is_greater_than_hold_limitation".
///
/// Description of the "number_of_users_on_hold_is_greater_than_hold_limitation"
/// tag state: You cannot add more than 5 users in a legal hold.
///
/// @return An initialized instance.
///
- (instancetype)initWithNumberOfUsersOnHoldIsGreaterThanHoldLimitation;

///
/// Initializes union class with tag state of "transient_error".
///
/// Description of the "transient_error" tag state: Temporary infrastructure
/// failure, please retry.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransientError;

///
/// Initializes union class with tag state of "name_must_be_unique".
///
/// Description of the "name_must_be_unique" tag state: The name provided is
/// already in use by another legal hold.
///
/// @return An initialized instance.
///
- (instancetype)initWithNameMustBeUnique;

///
/// Initializes union class with tag state of "team_exceeded_legal_hold_quota".
///
/// Description of the "team_exceeded_legal_hold_quota" tag state: Team exceeded
/// legal hold quota.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamExceededLegalHoldQuota;

///
/// Initializes union class with tag state of "invalid_date".
///
/// Description of the "invalid_date" tag state: The provided date is invalid.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidDate;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "unknown_legal_hold_error".
///
/// @return Whether the union's current tag state has value
/// "unknown_legal_hold_error".
///
- (BOOL)isUnknownLegalHoldError;

///
/// Retrieves whether the union's current tag state has value
/// "insufficient_permissions".
///
/// @return Whether the union's current tag state has value
/// "insufficient_permissions".
///
- (BOOL)isInsufficientPermissions;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves whether the union's current tag state has value
/// "start_date_is_later_than_end_date".
///
/// @return Whether the union's current tag state has value
/// "start_date_is_later_than_end_date".
///
- (BOOL)isStartDateIsLaterThanEndDate;

///
/// Retrieves whether the union's current tag state has value
/// "empty_members_list".
///
/// @return Whether the union's current tag state has value
/// "empty_members_list".
///
- (BOOL)isEmptyMembersList;

///
/// Retrieves whether the union's current tag state has value "invalid_members".
///
/// @return Whether the union's current tag state has value "invalid_members".
///
- (BOOL)isInvalidMembers;

///
/// Retrieves whether the union's current tag state has value
/// "number_of_users_on_hold_is_greater_than_hold_limitation".
///
/// @return Whether the union's current tag state has value
/// "number_of_users_on_hold_is_greater_than_hold_limitation".
///
- (BOOL)isNumberOfUsersOnHoldIsGreaterThanHoldLimitation;

///
/// Retrieves whether the union's current tag state has value "transient_error".
///
/// @return Whether the union's current tag state has value "transient_error".
///
- (BOOL)isTransientError;

///
/// Retrieves whether the union's current tag state has value
/// "name_must_be_unique".
///
/// @return Whether the union's current tag state has value
/// "name_must_be_unique".
///
- (BOOL)isNameMustBeUnique;

///
/// Retrieves whether the union's current tag state has value
/// "team_exceeded_legal_hold_quota".
///
/// @return Whether the union's current tag state has value
/// "team_exceeded_legal_hold_quota".
///
- (BOOL)isTeamExceededLegalHoldQuota;

///
/// Retrieves whether the union's current tag state has value "invalid_date".
///
/// @return Whether the union's current tag state has value "invalid_date".
///
- (BOOL)isInvalidDate;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLegalHoldsPolicyCreateError` union.
///
@interface DBTEAMLegalHoldsPolicyCreateErrorSerializer : NSObject

///
/// Serializes `DBTEAMLegalHoldsPolicyCreateError` instances.
///
/// @param instance An instance of the `DBTEAMLegalHoldsPolicyCreateError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLegalHoldsPolicyCreateError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsPolicyCreateError *)instance;

///
/// Deserializes `DBTEAMLegalHoldsPolicyCreateError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLegalHoldsPolicyCreateError` API object.
///
/// @return An instantiation of the `DBTEAMLegalHoldsPolicyCreateError` object.
///
+ (DBTEAMLegalHoldsPolicyCreateError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
