///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGTwoAccountPolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TwoAccountPolicy` union.
///
/// Policy for pairing personal account to work account
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGTwoAccountPolicy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGTwoAccountPolicyTag` enum type represents the possible tag
/// states with which the `DBTEAMLOGTwoAccountPolicy` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGTwoAccountPolicyTag){
    /// (no description).
    DBTEAMLOGTwoAccountPolicyDisabled,

    /// (no description).
    DBTEAMLOGTwoAccountPolicyEnabled,

    /// (no description).
    DBTEAMLOGTwoAccountPolicyOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGTwoAccountPolicyTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "disabled".
///
/// @return An initialized instance.
///
- (instancetype)initWithDisabled;

///
/// Initializes union class with tag state of "enabled".
///
/// @return An initialized instance.
///
- (instancetype)initWithEnabled;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "disabled".
///
/// @return Whether the union's current tag state has value "disabled".
///
- (BOOL)isDisabled;

///
/// Retrieves whether the union's current tag state has value "enabled".
///
/// @return Whether the union's current tag state has value "enabled".
///
- (BOOL)isEnabled;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGTwoAccountPolicy` union.
///
@interface DBTEAMLOGTwoAccountPolicySerializer : NSObject

///
/// Serializes `DBTEAMLOGTwoAccountPolicy` instances.
///
/// @param instance An instance of the `DBTEAMLOGTwoAccountPolicy` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGTwoAccountPolicy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGTwoAccountPolicy *)instance;

///
/// Deserializes `DBTEAMLOGTwoAccountPolicy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGTwoAccountPolicy` API object.
///
/// @return An instantiation of the `DBTEAMLOGTwoAccountPolicy` object.
///
+ (DBTEAMLOGTwoAccountPolicy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
