///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGTimeUnit;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TimeUnit` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGTimeUnit : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGTimeUnitTag` enum type represents the possible tag states with
/// which the `DBTEAMLOGTimeUnit` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGTimeUnitTag){
    /// (no description).
    DBTEAMLOGTimeUnitDays,

    /// (no description).
    DBTEAMLOGTimeUnitHours,

    /// (no description).
    DBTEAMLOGTimeUnitMilliseconds,

    /// (no description).
    DBTEAMLOGTimeUnitMinutes,

    /// (no description).
    DBTEAMLOGTimeUnitMonths,

    /// (no description).
    DBTEAMLOGTimeUnitSeconds,

    /// (no description).
    DBTEAMLOGTimeUnitWeeks,

    /// (no description).
    DBTEAMLOGTimeUnitYears,

    /// (no description).
    DBTEAMLOGTimeUnitOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGTimeUnitTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "days".
///
/// @return An initialized instance.
///
- (instancetype)initWithDays;

///
/// Initializes union class with tag state of "hours".
///
/// @return An initialized instance.
///
- (instancetype)initWithHours;

///
/// Initializes union class with tag state of "milliseconds".
///
/// @return An initialized instance.
///
- (instancetype)initWithMilliseconds;

///
/// Initializes union class with tag state of "minutes".
///
/// @return An initialized instance.
///
- (instancetype)initWithMinutes;

///
/// Initializes union class with tag state of "months".
///
/// @return An initialized instance.
///
- (instancetype)initWithMonths;

///
/// Initializes union class with tag state of "seconds".
///
/// @return An initialized instance.
///
- (instancetype)initWithSeconds;

///
/// Initializes union class with tag state of "weeks".
///
/// @return An initialized instance.
///
- (instancetype)initWithWeeks;

///
/// Initializes union class with tag state of "years".
///
/// @return An initialized instance.
///
- (instancetype)initWithYears;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "days".
///
/// @return Whether the union's current tag state has value "days".
///
- (BOOL)isDays;

///
/// Retrieves whether the union's current tag state has value "hours".
///
/// @return Whether the union's current tag state has value "hours".
///
- (BOOL)isHours;

///
/// Retrieves whether the union's current tag state has value "milliseconds".
///
/// @return Whether the union's current tag state has value "milliseconds".
///
- (BOOL)isMilliseconds;

///
/// Retrieves whether the union's current tag state has value "minutes".
///
/// @return Whether the union's current tag state has value "minutes".
///
- (BOOL)isMinutes;

///
/// Retrieves whether the union's current tag state has value "months".
///
/// @return Whether the union's current tag state has value "months".
///
- (BOOL)isMonths;

///
/// Retrieves whether the union's current tag state has value "seconds".
///
/// @return Whether the union's current tag state has value "seconds".
///
- (BOOL)isSeconds;

///
/// Retrieves whether the union's current tag state has value "weeks".
///
/// @return Whether the union's current tag state has value "weeks".
///
- (BOOL)isWeeks;

///
/// Retrieves whether the union's current tag state has value "years".
///
/// @return Whether the union's current tag state has value "years".
///
- (BOOL)isYears;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGTimeUnit` union.
///
@interface DBTEAMLOGTimeUnitSerializer : NSObject

///
/// Serializes `DBTEAMLOGTimeUnit` instances.
///
/// @param instance An instance of the `DBTEAMLOGTimeUnit` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGTimeUnit` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGTimeUnit *)instance;

///
/// Deserializes `DBTEAMLOGTimeUnit` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGTimeUnit` API object.
///
/// @return An instantiation of the `DBTEAMLOGTimeUnit` object.
///
+ (DBTEAMLOGTimeUnit *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
