///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGPaperDownloadFormat;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperDownloadFormat` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGPaperDownloadFormat : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGPaperDownloadFormatTag` enum type represents the possible tag
/// states with which the `DBTEAMLOGPaperDownloadFormat` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGPaperDownloadFormatTag){
    /// (no description).
    DBTEAMLOGPaperDownloadFormatDocx,

    /// (no description).
    DBTEAMLOGPaperDownloadFormatHtml,

    /// (no description).
    DBTEAMLOGPaperDownloadFormatMarkdown,

    /// (no description).
    DBTEAMLOGPaperDownloadFormatPdf,

    /// (no description).
    DBTEAMLOGPaperDownloadFormatOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGPaperDownloadFormatTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "docx".
///
/// @return An initialized instance.
///
- (instancetype)initWithDocx;

///
/// Initializes union class with tag state of "html".
///
/// @return An initialized instance.
///
- (instancetype)initWithHtml;

///
/// Initializes union class with tag state of "markdown".
///
/// @return An initialized instance.
///
- (instancetype)initWithMarkdown;

///
/// Initializes union class with tag state of "pdf".
///
/// @return An initialized instance.
///
- (instancetype)initWithPdf;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "docx".
///
/// @return Whether the union's current tag state has value "docx".
///
- (BOOL)isDocx;

///
/// Retrieves whether the union's current tag state has value "html".
///
/// @return Whether the union's current tag state has value "html".
///
- (BOOL)isHtml;

///
/// Retrieves whether the union's current tag state has value "markdown".
///
/// @return Whether the union's current tag state has value "markdown".
///
- (BOOL)isMarkdown;

///
/// Retrieves whether the union's current tag state has value "pdf".
///
/// @return Whether the union's current tag state has value "pdf".
///
- (BOOL)isPdf;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGPaperDownloadFormat` union.
///
@interface DBTEAMLOGPaperDownloadFormatSerializer : NSObject

///
/// Serializes `DBTEAMLOGPaperDownloadFormat` instances.
///
/// @param instance An instance of the `DBTEAMLOGPaperDownloadFormat` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGPaperDownloadFormat` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGPaperDownloadFormat *)instance;

///
/// Deserializes `DBTEAMLOGPaperDownloadFormat` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGPaperDownloadFormat` API object.
///
/// @return An instantiation of the `DBTEAMLOGPaperDownloadFormat` object.
///
+ (DBTEAMLOGPaperDownloadFormat *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
