///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGPaperDocumentLogInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperDocumentLogInfo` struct.
///
/// Paper document's logged information.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGPaperDocumentLogInfo : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Papers document Id.
@property (nonatomic, readonly, copy) NSString *docId;

/// Paper document title.
@property (nonatomic, readonly, copy) NSString *docTitle;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param docId Papers document Id.
/// @param docTitle Paper document title.
///
/// @return An initialized instance.
///
- (instancetype)initWithDocId:(NSString *)docId docTitle:(NSString *)docTitle;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `PaperDocumentLogInfo` struct.
///
@interface DBTEAMLOGPaperDocumentLogInfoSerializer : NSObject

///
/// Serializes `DBTEAMLOGPaperDocumentLogInfo` instances.
///
/// @param instance An instance of the `DBTEAMLOGPaperDocumentLogInfo` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGPaperDocumentLogInfo` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGPaperDocumentLogInfo *)instance;

///
/// Deserializes `DBTEAMLOGPaperDocumentLogInfo` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGPaperDocumentLogInfo` API object.
///
/// @return An instantiation of the `DBTEAMLOGPaperDocumentLogInfo` object.
///
+ (DBTEAMLOGPaperDocumentLogInfo *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
