///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGPaperDesktopPolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperDesktopPolicy` union.
///
/// Policy for controlling if team members can use Paper Desktop
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGPaperDesktopPolicy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGPaperDesktopPolicyTag` enum type represents the possible tag
/// states with which the `DBTEAMLOGPaperDesktopPolicy` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGPaperDesktopPolicyTag){
    /// (no description).
    DBTEAMLOGPaperDesktopPolicyDisabled,

    /// (no description).
    DBTEAMLOGPaperDesktopPolicyEnabled,

    /// (no description).
    DBTEAMLOGPaperDesktopPolicyOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGPaperDesktopPolicyTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "disabled".
///
/// @return An initialized instance.
///
- (instancetype)initWithDisabled;

///
/// Initializes union class with tag state of "enabled".
///
/// @return An initialized instance.
///
- (instancetype)initWithEnabled;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "disabled".
///
/// @return Whether the union's current tag state has value "disabled".
///
- (BOOL)isDisabled;

///
/// Retrieves whether the union's current tag state has value "enabled".
///
/// @return Whether the union's current tag state has value "enabled".
///
- (BOOL)isEnabled;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGPaperDesktopPolicy` union.
///
@interface DBTEAMLOGPaperDesktopPolicySerializer : NSObject

///
/// Serializes `DBTEAMLOGPaperDesktopPolicy` instances.
///
/// @param instance An instance of the `DBTEAMLOGPaperDesktopPolicy` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGPaperDesktopPolicy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGPaperDesktopPolicy *)instance;

///
/// Deserializes `DBTEAMLOGPaperDesktopPolicy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGPaperDesktopPolicy` API object.
///
/// @return An instantiation of the `DBTEAMLOGPaperDesktopPolicy` object.
///
+ (DBTEAMLOGPaperDesktopPolicy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
