///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGMemberSpaceLimitsChangePolicyDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MemberSpaceLimitsChangePolicyDetails` struct.
///
/// Changed team default member space limit.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGMemberSpaceLimitsChangePolicyDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Previous team default limit value in bytes. Might be missing due to
/// historical data gap.
@property (nonatomic, readonly, nullable) NSNumber *previousValue;

/// New team default limit value in bytes. Might be missing due to historical
/// data gap.
@property (nonatomic, readonly, nullable) NSNumber *dNewValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param previousValue Previous team default limit value in bytes. Might be
/// missing due to historical data gap.
/// @param dNewValue New team default limit value in bytes. Might be missing due
/// to historical data gap.
///
/// @return An initialized instance.
///
- (instancetype)initWithPreviousValue:(nullable NSNumber *)previousValue dNewValue:(nullable NSNumber *)dNewValue;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `MemberSpaceLimitsChangePolicyDetails`
/// struct.
///
@interface DBTEAMLOGMemberSpaceLimitsChangePolicyDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGMemberSpaceLimitsChangePolicyDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGMemberSpaceLimitsChangePolicyDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGMemberSpaceLimitsChangePolicyDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGMemberSpaceLimitsChangePolicyDetails *)instance;

///
/// Deserializes `DBTEAMLOGMemberSpaceLimitsChangePolicyDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGMemberSpaceLimitsChangePolicyDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGMemberSpaceLimitsChangePolicyDetails` object.
///
+ (DBTEAMLOGMemberSpaceLimitsChangePolicyDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
