///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGLockStatus;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `LockStatus` union.
///
/// File lock status
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGLockStatus : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGLockStatusTag` enum type represents the possible tag states
/// with which the `DBTEAMLOGLockStatus` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGLockStatusTag){
    /// (no description).
    DBTEAMLOGLockStatusLocked,

    /// (no description).
    DBTEAMLOGLockStatusUnlocked,

    /// (no description).
    DBTEAMLOGLockStatusOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGLockStatusTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "locked".
///
/// @return An initialized instance.
///
- (instancetype)initWithLocked;

///
/// Initializes union class with tag state of "unlocked".
///
/// @return An initialized instance.
///
- (instancetype)initWithUnlocked;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "locked".
///
/// @return Whether the union's current tag state has value "locked".
///
- (BOOL)isLocked;

///
/// Retrieves whether the union's current tag state has value "unlocked".
///
/// @return Whether the union's current tag state has value "unlocked".
///
- (BOOL)isUnlocked;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGLockStatus` union.
///
@interface DBTEAMLOGLockStatusSerializer : NSObject

///
/// Serializes `DBTEAMLOGLockStatus` instances.
///
/// @param instance An instance of the `DBTEAMLOGLockStatus` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGLockStatus` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGLockStatus *)instance;

///
/// Deserializes `DBTEAMLOGLockStatus` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGLockStatus` API object.
///
/// @return An instantiation of the `DBTEAMLOGLockStatus` object.
///
+ (DBTEAMLOGLockStatus *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
