///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGDurationLogInfo;
@class DBTEAMLOGGovernancePolicyEditDurationDetails;
@class DBTEAMLOGPolicyType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GovernancePolicyEditDurationDetails` struct.
///
/// Changed policy duration.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGGovernancePolicyEditDurationDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Policy ID.
@property (nonatomic, readonly, copy) NSString *governancePolicyId;

/// Policy name.
@property (nonatomic, readonly, copy) NSString *name;

/// Policy type.
@property (nonatomic, readonly, nullable) DBTEAMLOGPolicyType *policyType;

/// From.
@property (nonatomic, readonly) DBTEAMLOGDurationLogInfo *previousValue;

/// To.
@property (nonatomic, readonly) DBTEAMLOGDurationLogInfo *dNewValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param governancePolicyId Policy ID.
/// @param name Policy name.
/// @param previousValue From.
/// @param dNewValue To.
/// @param policyType Policy type.
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyId:(NSString *)governancePolicyId
                                      name:(NSString *)name
                             previousValue:(DBTEAMLOGDurationLogInfo *)previousValue
                                 dNewValue:(DBTEAMLOGDurationLogInfo *)dNewValue
                                policyType:(nullable DBTEAMLOGPolicyType *)policyType;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param governancePolicyId Policy ID.
/// @param name Policy name.
/// @param previousValue From.
/// @param dNewValue To.
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyId:(NSString *)governancePolicyId
                                      name:(NSString *)name
                             previousValue:(DBTEAMLOGDurationLogInfo *)previousValue
                                 dNewValue:(DBTEAMLOGDurationLogInfo *)dNewValue;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `GovernancePolicyEditDurationDetails`
/// struct.
///
@interface DBTEAMLOGGovernancePolicyEditDurationDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGGovernancePolicyEditDurationDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGGovernancePolicyEditDurationDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGGovernancePolicyEditDurationDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGGovernancePolicyEditDurationDetails *)instance;

///
/// Deserializes `DBTEAMLOGGovernancePolicyEditDurationDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGGovernancePolicyEditDurationDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGGovernancePolicyEditDurationDetails` object.
///
+ (DBTEAMLOGGovernancePolicyEditDurationDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
