///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGFileTransfersPolicy;
@class DBTEAMLOGFileTransfersPolicyChangedDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `FileTransfersPolicyChangedDetails` struct.
///
/// Changed file transfers policy for team.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGFileTransfersPolicyChangedDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// New file transfers policy.
@property (nonatomic, readonly) DBTEAMLOGFileTransfersPolicy *dNewValue;

/// Previous file transfers policy.
@property (nonatomic, readonly) DBTEAMLOGFileTransfersPolicy *previousValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dNewValue New file transfers policy.
/// @param previousValue Previous file transfers policy.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(DBTEAMLOGFileTransfersPolicy *)dNewValue
                    previousValue:(DBTEAMLOGFileTransfersPolicy *)previousValue;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `FileTransfersPolicyChangedDetails` struct.
///
@interface DBTEAMLOGFileTransfersPolicyChangedDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGFileTransfersPolicyChangedDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGFileTransfersPolicyChangedDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGFileTransfersPolicyChangedDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGFileTransfersPolicyChangedDetails *)instance;

///
/// Deserializes `DBTEAMLOGFileTransfersPolicyChangedDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGFileTransfersPolicyChangedDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGFileTransfersPolicyChangedDetails`
/// object.
///
+ (DBTEAMLOGFileTransfersPolicyChangedDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
