///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGFedAdminRole;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `FedAdminRole` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGFedAdminRole : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGFedAdminRoleTag` enum type represents the possible tag states
/// with which the `DBTEAMLOGFedAdminRole` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGFedAdminRoleTag){
    /// (no description).
    DBTEAMLOGFedAdminRoleEnterpriseAdmin,

    /// (no description).
    DBTEAMLOGFedAdminRoleNotEnterpriseAdmin,

    /// (no description).
    DBTEAMLOGFedAdminRoleOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGFedAdminRoleTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "enterprise_admin".
///
/// @return An initialized instance.
///
- (instancetype)initWithEnterpriseAdmin;

///
/// Initializes union class with tag state of "not_enterprise_admin".
///
/// @return An initialized instance.
///
- (instancetype)initWithNotEnterpriseAdmin;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "enterprise_admin".
///
/// @return Whether the union's current tag state has value "enterprise_admin".
///
- (BOOL)isEnterpriseAdmin;

///
/// Retrieves whether the union's current tag state has value
/// "not_enterprise_admin".
///
/// @return Whether the union's current tag state has value
/// "not_enterprise_admin".
///
- (BOOL)isNotEnterpriseAdmin;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGFedAdminRole` union.
///
@interface DBTEAMLOGFedAdminRoleSerializer : NSObject

///
/// Serializes `DBTEAMLOGFedAdminRole` instances.
///
/// @param instance An instance of the `DBTEAMLOGFedAdminRole` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGFedAdminRole` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGFedAdminRole *)instance;

///
/// Deserializes `DBTEAMLOGFedAdminRole` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGFedAdminRole` API object.
///
/// @return An instantiation of the `DBTEAMLOGFedAdminRole` object.
///
+ (DBTEAMLOGFedAdminRole *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
