///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGFailureDetailsLogInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `FailureDetailsLogInfo` struct.
///
/// Provides details about a failure
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGFailureDetailsLogInfo : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// A user friendly explanation of the error.
@property (nonatomic, readonly, copy, nullable) NSString *userFriendlyMessage;

/// A technical explanation of the error. This is relevant for some errors.
@property (nonatomic, readonly, copy, nullable) NSString *technicalErrorMessage;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param userFriendlyMessage A user friendly explanation of the error.
/// @param technicalErrorMessage A technical explanation of the error. This is
/// relevant for some errors.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserFriendlyMessage:(nullable NSString *)userFriendlyMessage
                      technicalErrorMessage:(nullable NSString *)technicalErrorMessage;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `FailureDetailsLogInfo` struct.
///
@interface DBTEAMLOGFailureDetailsLogInfoSerializer : NSObject

///
/// Serializes `DBTEAMLOGFailureDetailsLogInfo` instances.
///
/// @param instance An instance of the `DBTEAMLOGFailureDetailsLogInfo` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGFailureDetailsLogInfo` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGFailureDetailsLogInfo *)instance;

///
/// Deserializes `DBTEAMLOGFailureDetailsLogInfo` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGFailureDetailsLogInfo` API object.
///
/// @return An instantiation of the `DBTEAMLOGFailureDetailsLogInfo` object.
///
+ (DBTEAMLOGFailureDetailsLogInfo *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
