///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGEventTypeArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `EventTypeArg` union.
///
/// The type of the event.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGEventTypeArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGEventTypeArgTag` enum type represents the possible tag states
/// with which the `DBTEAMLOGEventTypeArg` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGEventTypeArgTag){
    /// (admin_alerting) Changed an alert setting
    DBTEAMLOGEventTypeArgAdminAlertingChangedAlertConfig,

    /// (admin_alerting) Triggered security alert
    DBTEAMLOGEventTypeArgAdminAlertingTriggeredAlert,

    /// (apps) Linked app for team
    DBTEAMLOGEventTypeArgAppLinkTeam,

    /// (apps) Linked app for member
    DBTEAMLOGEventTypeArgAppLinkUser,

    /// (apps) Unlinked app for team
    DBTEAMLOGEventTypeArgAppUnlinkTeam,

    /// (apps) Unlinked app for member
    DBTEAMLOGEventTypeArgAppUnlinkUser,

    /// (apps) Connected integration for member
    DBTEAMLOGEventTypeArgIntegrationConnected,

    /// (apps) Disconnected integration for member
    DBTEAMLOGEventTypeArgIntegrationDisconnected,

    /// (comments) Added file comment
    DBTEAMLOGEventTypeArgFileAddComment,

    /// (comments) Subscribed to or unsubscribed from comment notifications for
    /// file
    DBTEAMLOGEventTypeArgFileChangeCommentSubscription,

    /// (comments) Deleted file comment
    DBTEAMLOGEventTypeArgFileDeleteComment,

    /// (comments) Edited file comment
    DBTEAMLOGEventTypeArgFileEditComment,

    /// (comments) Liked file comment (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgFileLikeComment,

    /// (comments) Resolved file comment
    DBTEAMLOGEventTypeArgFileResolveComment,

    /// (comments) Unliked file comment (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgFileUnlikeComment,

    /// (comments) Unresolved file comment
    DBTEAMLOGEventTypeArgFileUnresolveComment,

    /// (data_governance) Added folders to policy
    DBTEAMLOGEventTypeArgGovernancePolicyAddFolders,

    /// (data_governance) Couldn't add a folder to a policy
    DBTEAMLOGEventTypeArgGovernancePolicyAddFolderFailed,

    /// (data_governance) Content disposed
    DBTEAMLOGEventTypeArgGovernancePolicyContentDisposed,

    /// (data_governance) Activated a new policy
    DBTEAMLOGEventTypeArgGovernancePolicyCreate,

    /// (data_governance) Deleted a policy
    DBTEAMLOGEventTypeArgGovernancePolicyDelete,

    /// (data_governance) Edited policy
    DBTEAMLOGEventTypeArgGovernancePolicyEditDetails,

    /// (data_governance) Changed policy duration
    DBTEAMLOGEventTypeArgGovernancePolicyEditDuration,

    /// (data_governance) Created a policy download
    DBTEAMLOGEventTypeArgGovernancePolicyExportCreated,

    /// (data_governance) Removed a policy download
    DBTEAMLOGEventTypeArgGovernancePolicyExportRemoved,

    /// (data_governance) Removed folders from policy
    DBTEAMLOGEventTypeArgGovernancePolicyRemoveFolders,

    /// (data_governance) Created a summary report for a policy
    DBTEAMLOGEventTypeArgGovernancePolicyReportCreated,

    /// (data_governance) Downloaded content from a policy
    DBTEAMLOGEventTypeArgGovernancePolicyZipPartDownloaded,

    /// (data_governance) Activated a hold
    DBTEAMLOGEventTypeArgLegalHoldsActivateAHold,

    /// (data_governance) Added members to a hold
    DBTEAMLOGEventTypeArgLegalHoldsAddMembers,

    /// (data_governance) Edited details for a hold
    DBTEAMLOGEventTypeArgLegalHoldsChangeHoldDetails,

    /// (data_governance) Renamed a hold
    DBTEAMLOGEventTypeArgLegalHoldsChangeHoldName,

    /// (data_governance) Exported hold
    DBTEAMLOGEventTypeArgLegalHoldsExportAHold,

    /// (data_governance) Canceled export for a hold
    DBTEAMLOGEventTypeArgLegalHoldsExportCancelled,

    /// (data_governance) Downloaded export for a hold
    DBTEAMLOGEventTypeArgLegalHoldsExportDownloaded,

    /// (data_governance) Removed export for a hold
    DBTEAMLOGEventTypeArgLegalHoldsExportRemoved,

    /// (data_governance) Released a hold
    DBTEAMLOGEventTypeArgLegalHoldsReleaseAHold,

    /// (data_governance) Removed members from a hold
    DBTEAMLOGEventTypeArgLegalHoldsRemoveMembers,

    /// (data_governance) Created a summary report for a hold
    DBTEAMLOGEventTypeArgLegalHoldsReportAHold,

    /// (devices) Changed IP address associated with active desktop session
    DBTEAMLOGEventTypeArgDeviceChangeIpDesktop,

    /// (devices) Changed IP address associated with active mobile session
    DBTEAMLOGEventTypeArgDeviceChangeIpMobile,

    /// (devices) Changed IP address associated with active web session
    DBTEAMLOGEventTypeArgDeviceChangeIpWeb,

    /// (devices) Failed to delete all files from unlinked device
    DBTEAMLOGEventTypeArgDeviceDeleteOnUnlinkFail,

    /// (devices) Deleted all files from unlinked device
    DBTEAMLOGEventTypeArgDeviceDeleteOnUnlinkSuccess,

    /// (devices) Failed to link device
    DBTEAMLOGEventTypeArgDeviceLinkFail,

    /// (devices) Linked device
    DBTEAMLOGEventTypeArgDeviceLinkSuccess,

    /// (devices) Disabled device management (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgDeviceManagementDisabled,

    /// (devices) Enabled device management (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgDeviceManagementEnabled,

    /// (devices) Enabled/disabled backup for computer
    DBTEAMLOGEventTypeArgDeviceSyncBackupStatusChanged,

    /// (devices) Disconnected device
    DBTEAMLOGEventTypeArgDeviceUnlink,

    /// (devices) Exported passwords
    DBTEAMLOGEventTypeArgDropboxPasswordsExported,

    /// (devices) Enrolled new Dropbox Passwords device
    DBTEAMLOGEventTypeArgDropboxPasswordsNewDeviceEnrolled,

    /// (devices) Refreshed auth token used for setting up EMM
    DBTEAMLOGEventTypeArgEmmRefreshAuthToken,

    /// (domains) Granted/revoked option to enable account capture on team
    /// domains
    DBTEAMLOGEventTypeArgAccountCaptureChangeAvailability,

    /// (domains) Account-captured user migrated account to team
    DBTEAMLOGEventTypeArgAccountCaptureMigrateAccount,

    /// (domains) Sent account capture email to all unmanaged members
    DBTEAMLOGEventTypeArgAccountCaptureNotificationEmailsSent,

    /// (domains) Account-captured user changed account email to personal email
    DBTEAMLOGEventTypeArgAccountCaptureRelinquishAccount,

    /// (domains) Disabled domain invites (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgDisabledDomainInvites,

    /// (domains) Approved user's request to join team
    DBTEAMLOGEventTypeArgDomainInvitesApproveRequestToJoinTeam,

    /// (domains) Declined user's request to join team
    DBTEAMLOGEventTypeArgDomainInvitesDeclineRequestToJoinTeam,

    /// (domains) Sent domain invites to existing domain accounts (deprecated,
    /// no longer logged)
    DBTEAMLOGEventTypeArgDomainInvitesEmailExistingUsers,

    /// (domains) Requested to join team
    DBTEAMLOGEventTypeArgDomainInvitesRequestToJoinTeam,

    /// (domains) Disabled "Automatically invite new users" (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgDomainInvitesSetInviteNewUserPrefToNo,

    /// (domains) Enabled "Automatically invite new users" (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgDomainInvitesSetInviteNewUserPrefToYes,

    /// (domains) Failed to verify team domain
    DBTEAMLOGEventTypeArgDomainVerificationAddDomainFail,

    /// (domains) Verified team domain
    DBTEAMLOGEventTypeArgDomainVerificationAddDomainSuccess,

    /// (domains) Removed domain from list of verified team domains
    DBTEAMLOGEventTypeArgDomainVerificationRemoveDomain,

    /// (domains) Enabled domain invites (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgEnabledDomainInvites,

    /// (file_operations) Created folders (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgCreateFolder,

    /// (file_operations) Added files and/or folders
    DBTEAMLOGEventTypeArgFileAdd,

    /// (file_operations) Copied files and/or folders
    DBTEAMLOGEventTypeArgFileCopy,

    /// (file_operations) Deleted files and/or folders
    DBTEAMLOGEventTypeArgFileDelete,

    /// (file_operations) Downloaded files and/or folders
    DBTEAMLOGEventTypeArgFileDownload,

    /// (file_operations) Edited files
    DBTEAMLOGEventTypeArgFileEdit,

    /// (file_operations) Created copy reference to file/folder
    DBTEAMLOGEventTypeArgFileGetCopyReference,

    /// (file_operations) Locked/unlocked editing for a file
    DBTEAMLOGEventTypeArgFileLockingLockStatusChanged,

    /// (file_operations) Moved files and/or folders
    DBTEAMLOGEventTypeArgFileMove,

    /// (file_operations) Permanently deleted files and/or folders
    DBTEAMLOGEventTypeArgFilePermanentlyDelete,

    /// (file_operations) Previewed files and/or folders
    DBTEAMLOGEventTypeArgFilePreview,

    /// (file_operations) Renamed files and/or folders
    DBTEAMLOGEventTypeArgFileRename,

    /// (file_operations) Restored deleted files and/or folders
    DBTEAMLOGEventTypeArgFileRestore,

    /// (file_operations) Reverted files to previous version
    DBTEAMLOGEventTypeArgFileRevert,

    /// (file_operations) Rolled back file actions
    DBTEAMLOGEventTypeArgFileRollbackChanges,

    /// (file_operations) Saved file/folder using copy reference
    DBTEAMLOGEventTypeArgFileSaveCopyReference,

    /// (file_operations) Updated folder overview
    DBTEAMLOGEventTypeArgFolderOverviewDescriptionChanged,

    /// (file_operations) Pinned item to folder overview
    DBTEAMLOGEventTypeArgFolderOverviewItemPinned,

    /// (file_operations) Unpinned item from folder overview
    DBTEAMLOGEventTypeArgFolderOverviewItemUnpinned,

    /// (file_operations) Added a label
    DBTEAMLOGEventTypeArgObjectLabelAdded,

    /// (file_operations) Removed a label
    DBTEAMLOGEventTypeArgObjectLabelRemoved,

    /// (file_operations) Updated a label's value
    DBTEAMLOGEventTypeArgObjectLabelUpdatedValue,

    /// (file_operations) Rewound a folder
    DBTEAMLOGEventTypeArgRewindFolder,

    /// (file_requests) Changed file request
    DBTEAMLOGEventTypeArgFileRequestChange,

    /// (file_requests) Closed file request
    DBTEAMLOGEventTypeArgFileRequestClose,

    /// (file_requests) Created file request
    DBTEAMLOGEventTypeArgFileRequestCreate,

    /// (file_requests) Delete file request
    DBTEAMLOGEventTypeArgFileRequestDelete,

    /// (file_requests) Received files for file request
    DBTEAMLOGEventTypeArgFileRequestReceiveFile,

    /// (groups) Added external ID for group
    DBTEAMLOGEventTypeArgGroupAddExternalId,

    /// (groups) Added team members to group
    DBTEAMLOGEventTypeArgGroupAddMember,

    /// (groups) Changed external ID for group
    DBTEAMLOGEventTypeArgGroupChangeExternalId,

    /// (groups) Changed group management type
    DBTEAMLOGEventTypeArgGroupChangeManagementType,

    /// (groups) Changed manager permissions of group member
    DBTEAMLOGEventTypeArgGroupChangeMemberRole,

    /// (groups) Created group
    DBTEAMLOGEventTypeArgGroupCreate,

    /// (groups) Deleted group
    DBTEAMLOGEventTypeArgGroupDelete,

    /// (groups) Updated group (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgGroupDescriptionUpdated,

    /// (groups) Updated group join policy (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgGroupJoinPolicyUpdated,

    /// (groups) Moved group (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgGroupMoved,

    /// (groups) Removed external ID for group
    DBTEAMLOGEventTypeArgGroupRemoveExternalId,

    /// (groups) Removed team members from group
    DBTEAMLOGEventTypeArgGroupRemoveMember,

    /// (groups) Renamed group
    DBTEAMLOGEventTypeArgGroupRename,

    /// (logins) Unlocked/locked account after failed sign in attempts
    DBTEAMLOGEventTypeArgAccountLockOrUnlocked,

    /// (logins) Failed to sign in via EMM (deprecated, replaced by 'Failed to
    /// sign in')
    DBTEAMLOGEventTypeArgEmmError,

    /// (logins) Started trusted team admin session
    DBTEAMLOGEventTypeArgGuestAdminSignedInViaTrustedTeams,

    /// (logins) Ended trusted team admin session
    DBTEAMLOGEventTypeArgGuestAdminSignedOutViaTrustedTeams,

    /// (logins) Failed to sign in
    DBTEAMLOGEventTypeArgLoginFail,

    /// (logins) Signed in
    DBTEAMLOGEventTypeArgLoginSuccess,

    /// (logins) Signed out
    DBTEAMLOGEventTypeArgLogout,

    /// (logins) Ended reseller support session
    DBTEAMLOGEventTypeArgResellerSupportSessionEnd,

    /// (logins) Started reseller support session
    DBTEAMLOGEventTypeArgResellerSupportSessionStart,

    /// (logins) Ended admin sign-in-as session
    DBTEAMLOGEventTypeArgSignInAsSessionEnd,

    /// (logins) Started admin sign-in-as session
    DBTEAMLOGEventTypeArgSignInAsSessionStart,

    /// (logins) Failed to sign in via SSO (deprecated, replaced by 'Failed to
    /// sign in')
    DBTEAMLOGEventTypeArgSsoError,

    /// (members) Created team invite link
    DBTEAMLOGEventTypeArgCreateTeamInviteLink,

    /// (members) Deleted team invite link
    DBTEAMLOGEventTypeArgDeleteTeamInviteLink,

    /// (members) Added an external ID for team member
    DBTEAMLOGEventTypeArgMemberAddExternalId,

    /// (members) Added team member name
    DBTEAMLOGEventTypeArgMemberAddName,

    /// (members) Changed team member admin role
    DBTEAMLOGEventTypeArgMemberChangeAdminRole,

    /// (members) Changed team member email
    DBTEAMLOGEventTypeArgMemberChangeEmail,

    /// (members) Changed the external ID for team member
    DBTEAMLOGEventTypeArgMemberChangeExternalId,

    /// (members) Changed membership type (limited/full) of member (deprecated,
    /// no longer logged)
    DBTEAMLOGEventTypeArgMemberChangeMembershipType,

    /// (members) Changed team member name
    DBTEAMLOGEventTypeArgMemberChangeName,

    /// (members) Changed team member reseller role
    DBTEAMLOGEventTypeArgMemberChangeResellerRole,

    /// (members) Changed member status (invited, joined, suspended, etc.)
    DBTEAMLOGEventTypeArgMemberChangeStatus,

    /// (members) Cleared manually added contacts
    DBTEAMLOGEventTypeArgMemberDeleteManualContacts,

    /// (members) Deleted team member profile photo
    DBTEAMLOGEventTypeArgMemberDeleteProfilePhoto,

    /// (members) Permanently deleted contents of deleted team member account
    DBTEAMLOGEventTypeArgMemberPermanentlyDeleteAccountContents,

    /// (members) Removed the external ID for team member
    DBTEAMLOGEventTypeArgMemberRemoveExternalId,

    /// (members) Set team member profile photo
    DBTEAMLOGEventTypeArgMemberSetProfilePhoto,

    /// (members) Set custom member space limit
    DBTEAMLOGEventTypeArgMemberSpaceLimitsAddCustomQuota,

    /// (members) Changed custom member space limit
    DBTEAMLOGEventTypeArgMemberSpaceLimitsChangeCustomQuota,

    /// (members) Changed space limit status
    DBTEAMLOGEventTypeArgMemberSpaceLimitsChangeStatus,

    /// (members) Removed custom member space limit
    DBTEAMLOGEventTypeArgMemberSpaceLimitsRemoveCustomQuota,

    /// (members) Suggested person to add to team
    DBTEAMLOGEventTypeArgMemberSuggest,

    /// (members) Transferred contents of deleted member account to another
    /// member
    DBTEAMLOGEventTypeArgMemberTransferAccountContents,

    /// (members) Added pending secondary email
    DBTEAMLOGEventTypeArgPendingSecondaryEmailAdded,

    /// (members) Deleted secondary email
    DBTEAMLOGEventTypeArgSecondaryEmailDeleted,

    /// (members) Verified secondary email
    DBTEAMLOGEventTypeArgSecondaryEmailVerified,

    /// (members) Secondary mails policy changed
    DBTEAMLOGEventTypeArgSecondaryMailsPolicyChanged,

    /// (paper) Added Binder page (deprecated, replaced by 'Edited files')
    DBTEAMLOGEventTypeArgBinderAddPage,

    /// (paper) Added Binder section (deprecated, replaced by 'Edited files')
    DBTEAMLOGEventTypeArgBinderAddSection,

    /// (paper) Removed Binder page (deprecated, replaced by 'Edited files')
    DBTEAMLOGEventTypeArgBinderRemovePage,

    /// (paper) Removed Binder section (deprecated, replaced by 'Edited files')
    DBTEAMLOGEventTypeArgBinderRemoveSection,

    /// (paper) Renamed Binder page (deprecated, replaced by 'Edited files')
    DBTEAMLOGEventTypeArgBinderRenamePage,

    /// (paper) Renamed Binder section (deprecated, replaced by 'Edited files')
    DBTEAMLOGEventTypeArgBinderRenameSection,

    /// (paper) Reordered Binder page (deprecated, replaced by 'Edited files')
    DBTEAMLOGEventTypeArgBinderReorderPage,

    /// (paper) Reordered Binder section (deprecated, replaced by 'Edited
    /// files')
    DBTEAMLOGEventTypeArgBinderReorderSection,

    /// (paper) Added users and/or groups to Paper doc/folder
    DBTEAMLOGEventTypeArgPaperContentAddMember,

    /// (paper) Added Paper doc/folder to folder
    DBTEAMLOGEventTypeArgPaperContentAddToFolder,

    /// (paper) Archived Paper doc/folder
    DBTEAMLOGEventTypeArgPaperContentArchive,

    /// (paper) Created Paper doc/folder
    DBTEAMLOGEventTypeArgPaperContentCreate,

    /// (paper) Permanently deleted Paper doc/folder
    DBTEAMLOGEventTypeArgPaperContentPermanentlyDelete,

    /// (paper) Removed Paper doc/folder from folder
    DBTEAMLOGEventTypeArgPaperContentRemoveFromFolder,

    /// (paper) Removed users and/or groups from Paper doc/folder
    DBTEAMLOGEventTypeArgPaperContentRemoveMember,

    /// (paper) Renamed Paper doc/folder
    DBTEAMLOGEventTypeArgPaperContentRename,

    /// (paper) Restored archived Paper doc/folder
    DBTEAMLOGEventTypeArgPaperContentRestore,

    /// (paper) Added Paper doc comment
    DBTEAMLOGEventTypeArgPaperDocAddComment,

    /// (paper) Changed member permissions for Paper doc
    DBTEAMLOGEventTypeArgPaperDocChangeMemberRole,

    /// (paper) Changed sharing setting for Paper doc
    DBTEAMLOGEventTypeArgPaperDocChangeSharingPolicy,

    /// (paper) Followed/unfollowed Paper doc
    DBTEAMLOGEventTypeArgPaperDocChangeSubscription,

    /// (paper) Archived Paper doc (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgPaperDocDeleted,

    /// (paper) Deleted Paper doc comment
    DBTEAMLOGEventTypeArgPaperDocDeleteComment,

    /// (paper) Downloaded Paper doc in specific format
    DBTEAMLOGEventTypeArgPaperDocDownload,

    /// (paper) Edited Paper doc
    DBTEAMLOGEventTypeArgPaperDocEdit,

    /// (paper) Edited Paper doc comment
    DBTEAMLOGEventTypeArgPaperDocEditComment,

    /// (paper) Followed Paper doc (deprecated, replaced by 'Followed/unfollowed
    /// Paper doc')
    DBTEAMLOGEventTypeArgPaperDocFollowed,

    /// (paper) Mentioned user in Paper doc
    DBTEAMLOGEventTypeArgPaperDocMention,

    /// (paper) Transferred ownership of Paper doc
    DBTEAMLOGEventTypeArgPaperDocOwnershipChanged,

    /// (paper) Requested access to Paper doc
    DBTEAMLOGEventTypeArgPaperDocRequestAccess,

    /// (paper) Resolved Paper doc comment
    DBTEAMLOGEventTypeArgPaperDocResolveComment,

    /// (paper) Restored Paper doc to previous version
    DBTEAMLOGEventTypeArgPaperDocRevert,

    /// (paper) Shared Paper doc via Slack
    DBTEAMLOGEventTypeArgPaperDocSlackShare,

    /// (paper) Shared Paper doc with users and/or groups (deprecated, no longer
    /// logged)
    DBTEAMLOGEventTypeArgPaperDocTeamInvite,

    /// (paper) Deleted Paper doc
    DBTEAMLOGEventTypeArgPaperDocTrashed,

    /// (paper) Unresolved Paper doc comment
    DBTEAMLOGEventTypeArgPaperDocUnresolveComment,

    /// (paper) Restored Paper doc
    DBTEAMLOGEventTypeArgPaperDocUntrashed,

    /// (paper) Viewed Paper doc
    DBTEAMLOGEventTypeArgPaperDocView,

    /// (paper) Changed Paper external sharing setting to anyone (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgPaperExternalViewAllow,

    /// (paper) Changed Paper external sharing setting to default team
    /// (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgPaperExternalViewDefaultTeam,

    /// (paper) Changed Paper external sharing setting to team-only (deprecated,
    /// no longer logged)
    DBTEAMLOGEventTypeArgPaperExternalViewForbid,

    /// (paper) Followed/unfollowed Paper folder
    DBTEAMLOGEventTypeArgPaperFolderChangeSubscription,

    /// (paper) Archived Paper folder (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgPaperFolderDeleted,

    /// (paper) Followed Paper folder (deprecated, replaced by
    /// 'Followed/unfollowed Paper folder')
    DBTEAMLOGEventTypeArgPaperFolderFollowed,

    /// (paper) Shared Paper folder with users and/or groups (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgPaperFolderTeamInvite,

    /// (paper) Changed permissions for published doc
    DBTEAMLOGEventTypeArgPaperPublishedLinkChangePermission,

    /// (paper) Published doc
    DBTEAMLOGEventTypeArgPaperPublishedLinkCreate,

    /// (paper) Unpublished doc
    DBTEAMLOGEventTypeArgPaperPublishedLinkDisabled,

    /// (paper) Viewed published doc
    DBTEAMLOGEventTypeArgPaperPublishedLinkView,

    /// (passwords) Changed password
    DBTEAMLOGEventTypeArgPasswordChange,

    /// (passwords) Reset password
    DBTEAMLOGEventTypeArgPasswordReset,

    /// (passwords) Reset all team member passwords
    DBTEAMLOGEventTypeArgPasswordResetAll,

    /// (reports) Created Classification report
    DBTEAMLOGEventTypeArgClassificationCreateReport,

    /// (reports) Couldn't create Classification report
    DBTEAMLOGEventTypeArgClassificationCreateReportFail,

    /// (reports) Created EMM-excluded users report
    DBTEAMLOGEventTypeArgEmmCreateExceptionsReport,

    /// (reports) Created EMM mobile app usage report
    DBTEAMLOGEventTypeArgEmmCreateUsageReport,

    /// (reports) Created member data report
    DBTEAMLOGEventTypeArgExportMembersReport,

    /// (reports) Failed to create members data report
    DBTEAMLOGEventTypeArgExportMembersReportFail,

    /// (reports) Created External sharing report
    DBTEAMLOGEventTypeArgExternalSharingCreateReport,

    /// (reports) Couldn't create External sharing report
    DBTEAMLOGEventTypeArgExternalSharingReportFailed,

    /// (reports) Report created: Links created with no expiration
    DBTEAMLOGEventTypeArgNoExpirationLinkGenCreateReport,

    /// (reports) Couldn't create report: Links created with no expiration
    DBTEAMLOGEventTypeArgNoExpirationLinkGenReportFailed,

    /// (reports) Report created: Links created without passwords
    DBTEAMLOGEventTypeArgNoPasswordLinkGenCreateReport,

    /// (reports) Couldn't create report: Links created without passwords
    DBTEAMLOGEventTypeArgNoPasswordLinkGenReportFailed,

    /// (reports) Report created: Views of links without passwords
    DBTEAMLOGEventTypeArgNoPasswordLinkViewCreateReport,

    /// (reports) Couldn't create report: Views of links without passwords
    DBTEAMLOGEventTypeArgNoPasswordLinkViewReportFailed,

    /// (reports) Report created: Views of old links
    DBTEAMLOGEventTypeArgOutdatedLinkViewCreateReport,

    /// (reports) Couldn't create report: Views of old links
    DBTEAMLOGEventTypeArgOutdatedLinkViewReportFailed,

    /// (reports) Exported all team Paper docs
    DBTEAMLOGEventTypeArgPaperAdminExportStart,

    /// (reports) Created Smart Sync non-admin devices report
    DBTEAMLOGEventTypeArgSmartSyncCreateAdminPrivilegeReport,

    /// (reports) Created team activity report
    DBTEAMLOGEventTypeArgTeamActivityCreateReport,

    /// (reports) Couldn't generate team activity report
    DBTEAMLOGEventTypeArgTeamActivityCreateReportFail,

    /// (sharing) Shared album
    DBTEAMLOGEventTypeArgCollectionShare,

    /// (sharing) Transfer files added
    DBTEAMLOGEventTypeArgFileTransfersFileAdd,

    /// (sharing) Deleted transfer
    DBTEAMLOGEventTypeArgFileTransfersTransferDelete,

    /// (sharing) Transfer downloaded
    DBTEAMLOGEventTypeArgFileTransfersTransferDownload,

    /// (sharing) Sent transfer
    DBTEAMLOGEventTypeArgFileTransfersTransferSend,

    /// (sharing) Viewed transfer
    DBTEAMLOGEventTypeArgFileTransfersTransferView,

    /// (sharing) Changed Paper doc to invite-only (deprecated, no longer
    /// logged)
    DBTEAMLOGEventTypeArgNoteAclInviteOnly,

    /// (sharing) Changed Paper doc to link-accessible (deprecated, no longer
    /// logged)
    DBTEAMLOGEventTypeArgNoteAclLink,

    /// (sharing) Changed Paper doc to link-accessible for team (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgNoteAclTeamLink,

    /// (sharing) Shared Paper doc (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgNoteShared,

    /// (sharing) Shared received Paper doc (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgNoteShareReceive,

    /// (sharing) Opened shared Paper doc (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgOpenNoteShared,

    /// (sharing) Added team to shared folder (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgSfAddGroup,

    /// (sharing) Allowed non-collaborators to view links to files in shared
    /// folder (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgSfAllowNonMembersToViewSharedLinks,

    /// (sharing) Set team members to see warning before sharing folders outside
    /// team (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgSfExternalInviteWarn,

    /// (sharing) Invited Facebook users to shared folder (deprecated, no longer
    /// logged)
    DBTEAMLOGEventTypeArgSfFbInvite,

    /// (sharing) Changed Facebook user's role in shared folder (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgSfFbInviteChangeRole,

    /// (sharing) Uninvited Facebook user from shared folder (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgSfFbUninvite,

    /// (sharing) Invited group to shared folder (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgSfInviteGroup,

    /// (sharing) Granted access to shared folder (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgSfTeamGrantAccess,

    /// (sharing) Invited team members to shared folder (deprecated, replaced by
    /// 'Invited user to Dropbox and added them to shared file/folder')
    DBTEAMLOGEventTypeArgSfTeamInvite,

    /// (sharing) Changed team member's role in shared folder (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgSfTeamInviteChangeRole,

    /// (sharing) Joined team member's shared folder (deprecated, no longer
    /// logged)
    DBTEAMLOGEventTypeArgSfTeamJoin,

    /// (sharing) Joined team member's shared folder from link (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgSfTeamJoinFromOobLink,

    /// (sharing) Unshared folder with team member (deprecated, replaced by
    /// 'Removed invitee from shared file/folder before invite was accepted')
    DBTEAMLOGEventTypeArgSfTeamUninvite,

    /// (sharing) Invited user to Dropbox and added them to shared file/folder
    DBTEAMLOGEventTypeArgSharedContentAddInvitees,

    /// (sharing) Added expiration date to link for shared file/folder
    /// (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgSharedContentAddLinkExpiry,

    /// (sharing) Added password to link for shared file/folder (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgSharedContentAddLinkPassword,

    /// (sharing) Added users and/or groups to shared file/folder
    DBTEAMLOGEventTypeArgSharedContentAddMember,

    /// (sharing) Changed whether members can download shared file/folder
    /// (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgSharedContentChangeDownloadsPolicy,

    /// (sharing) Changed access type of invitee to shared file/folder before
    /// invite was accepted
    DBTEAMLOGEventTypeArgSharedContentChangeInviteeRole,

    /// (sharing) Changed link audience of shared file/folder (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgSharedContentChangeLinkAudience,

    /// (sharing) Changed link expiration of shared file/folder (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgSharedContentChangeLinkExpiry,

    /// (sharing) Changed link password of shared file/folder (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgSharedContentChangeLinkPassword,

    /// (sharing) Changed access type of shared file/folder member
    DBTEAMLOGEventTypeArgSharedContentChangeMemberRole,

    /// (sharing) Changed whether members can see who viewed shared file/folder
    DBTEAMLOGEventTypeArgSharedContentChangeViewerInfoPolicy,

    /// (sharing) Acquired membership of shared file/folder by accepting invite
    DBTEAMLOGEventTypeArgSharedContentClaimInvitation,

    /// (sharing) Copied shared file/folder to own Dropbox
    DBTEAMLOGEventTypeArgSharedContentCopy,

    /// (sharing) Downloaded shared file/folder
    DBTEAMLOGEventTypeArgSharedContentDownload,

    /// (sharing) Left shared file/folder
    DBTEAMLOGEventTypeArgSharedContentRelinquishMembership,

    /// (sharing) Removed invitee from shared file/folder before invite was
    /// accepted
    DBTEAMLOGEventTypeArgSharedContentRemoveInvitees,

    /// (sharing) Removed link expiration date of shared file/folder
    /// (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgSharedContentRemoveLinkExpiry,

    /// (sharing) Removed link password of shared file/folder (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgSharedContentRemoveLinkPassword,

    /// (sharing) Removed user/group from shared file/folder
    DBTEAMLOGEventTypeArgSharedContentRemoveMember,

    /// (sharing) Requested access to shared file/folder
    DBTEAMLOGEventTypeArgSharedContentRequestAccess,

    /// (sharing) Restored shared file/folder invitees
    DBTEAMLOGEventTypeArgSharedContentRestoreInvitees,

    /// (sharing) Restored users and/or groups to membership of shared
    /// file/folder
    DBTEAMLOGEventTypeArgSharedContentRestoreMember,

    /// (sharing) Unshared file/folder by clearing membership
    DBTEAMLOGEventTypeArgSharedContentUnshare,

    /// (sharing) Previewed shared file/folder
    DBTEAMLOGEventTypeArgSharedContentView,

    /// (sharing) Changed who can access shared folder via link
    DBTEAMLOGEventTypeArgSharedFolderChangeLinkPolicy,

    /// (sharing) Changed whether shared folder inherits members from parent
    /// folder
    DBTEAMLOGEventTypeArgSharedFolderChangeMembersInheritancePolicy,

    /// (sharing) Changed who can add/remove members of shared folder
    DBTEAMLOGEventTypeArgSharedFolderChangeMembersManagementPolicy,

    /// (sharing) Changed who can become member of shared folder
    DBTEAMLOGEventTypeArgSharedFolderChangeMembersPolicy,

    /// (sharing) Created shared folder
    DBTEAMLOGEventTypeArgSharedFolderCreate,

    /// (sharing) Declined team member's invite to shared folder
    DBTEAMLOGEventTypeArgSharedFolderDeclineInvitation,

    /// (sharing) Added shared folder to own Dropbox
    DBTEAMLOGEventTypeArgSharedFolderMount,

    /// (sharing) Changed parent of shared folder
    DBTEAMLOGEventTypeArgSharedFolderNest,

    /// (sharing) Transferred ownership of shared folder to another member
    DBTEAMLOGEventTypeArgSharedFolderTransferOwnership,

    /// (sharing) Deleted shared folder from Dropbox
    DBTEAMLOGEventTypeArgSharedFolderUnmount,

    /// (sharing) Added shared link expiration date
    DBTEAMLOGEventTypeArgSharedLinkAddExpiry,

    /// (sharing) Changed shared link expiration date
    DBTEAMLOGEventTypeArgSharedLinkChangeExpiry,

    /// (sharing) Changed visibility of shared link
    DBTEAMLOGEventTypeArgSharedLinkChangeVisibility,

    /// (sharing) Added file/folder to Dropbox from shared link
    DBTEAMLOGEventTypeArgSharedLinkCopy,

    /// (sharing) Created shared link
    DBTEAMLOGEventTypeArgSharedLinkCreate,

    /// (sharing) Removed shared link
    DBTEAMLOGEventTypeArgSharedLinkDisable,

    /// (sharing) Downloaded file/folder from shared link
    DBTEAMLOGEventTypeArgSharedLinkDownload,

    /// (sharing) Removed shared link expiration date
    DBTEAMLOGEventTypeArgSharedLinkRemoveExpiry,

    /// (sharing) Added an expiration date to the shared link
    DBTEAMLOGEventTypeArgSharedLinkSettingsAddExpiration,

    /// (sharing) Added a password to the shared link
    DBTEAMLOGEventTypeArgSharedLinkSettingsAddPassword,

    /// (sharing) Disabled downloads
    DBTEAMLOGEventTypeArgSharedLinkSettingsAllowDownloadDisabled,

    /// (sharing) Enabled downloads
    DBTEAMLOGEventTypeArgSharedLinkSettingsAllowDownloadEnabled,

    /// (sharing) Changed the audience of the shared link
    DBTEAMLOGEventTypeArgSharedLinkSettingsChangeAudience,

    /// (sharing) Changed the expiration date of the shared link
    DBTEAMLOGEventTypeArgSharedLinkSettingsChangeExpiration,

    /// (sharing) Changed the password of the shared link
    DBTEAMLOGEventTypeArgSharedLinkSettingsChangePassword,

    /// (sharing) Removed the expiration date from the shared link
    DBTEAMLOGEventTypeArgSharedLinkSettingsRemoveExpiration,

    /// (sharing) Removed the password from the shared link
    DBTEAMLOGEventTypeArgSharedLinkSettingsRemovePassword,

    /// (sharing) Added members as audience of shared link
    DBTEAMLOGEventTypeArgSharedLinkShare,

    /// (sharing) Opened shared link
    DBTEAMLOGEventTypeArgSharedLinkView,

    /// (sharing) Opened shared Paper doc (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgSharedNoteOpened,

    /// (sharing) Disabled downloads for link (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgShmodelDisableDownloads,

    /// (sharing) Enabled downloads for link (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgShmodelEnableDownloads,

    /// (sharing) Shared link with group (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgShmodelGroupShare,

    /// (showcase) Granted access to showcase
    DBTEAMLOGEventTypeArgShowcaseAccessGranted,

    /// (showcase) Added member to showcase
    DBTEAMLOGEventTypeArgShowcaseAddMember,

    /// (showcase) Archived showcase
    DBTEAMLOGEventTypeArgShowcaseArchived,

    /// (showcase) Created showcase
    DBTEAMLOGEventTypeArgShowcaseCreated,

    /// (showcase) Deleted showcase comment
    DBTEAMLOGEventTypeArgShowcaseDeleteComment,

    /// (showcase) Edited showcase
    DBTEAMLOGEventTypeArgShowcaseEdited,

    /// (showcase) Edited showcase comment
    DBTEAMLOGEventTypeArgShowcaseEditComment,

    /// (showcase) Added file to showcase
    DBTEAMLOGEventTypeArgShowcaseFileAdded,

    /// (showcase) Downloaded file from showcase
    DBTEAMLOGEventTypeArgShowcaseFileDownload,

    /// (showcase) Removed file from showcase
    DBTEAMLOGEventTypeArgShowcaseFileRemoved,

    /// (showcase) Viewed file in showcase
    DBTEAMLOGEventTypeArgShowcaseFileView,

    /// (showcase) Permanently deleted showcase
    DBTEAMLOGEventTypeArgShowcasePermanentlyDeleted,

    /// (showcase) Added showcase comment
    DBTEAMLOGEventTypeArgShowcasePostComment,

    /// (showcase) Removed member from showcase
    DBTEAMLOGEventTypeArgShowcaseRemoveMember,

    /// (showcase) Renamed showcase
    DBTEAMLOGEventTypeArgShowcaseRenamed,

    /// (showcase) Requested access to showcase
    DBTEAMLOGEventTypeArgShowcaseRequestAccess,

    /// (showcase) Resolved showcase comment
    DBTEAMLOGEventTypeArgShowcaseResolveComment,

    /// (showcase) Unarchived showcase
    DBTEAMLOGEventTypeArgShowcaseRestored,

    /// (showcase) Deleted showcase
    DBTEAMLOGEventTypeArgShowcaseTrashed,

    /// (showcase) Deleted showcase (old version) (deprecated, replaced by
    /// 'Deleted showcase')
    DBTEAMLOGEventTypeArgShowcaseTrashedDeprecated,

    /// (showcase) Unresolved showcase comment
    DBTEAMLOGEventTypeArgShowcaseUnresolveComment,

    /// (showcase) Restored showcase
    DBTEAMLOGEventTypeArgShowcaseUntrashed,

    /// (showcase) Restored showcase (old version) (deprecated, replaced by
    /// 'Restored showcase')
    DBTEAMLOGEventTypeArgShowcaseUntrashedDeprecated,

    /// (showcase) Viewed showcase
    DBTEAMLOGEventTypeArgShowcaseView,

    /// (sso) Added X.509 certificate for SSO
    DBTEAMLOGEventTypeArgSsoAddCert,

    /// (sso) Added sign-in URL for SSO
    DBTEAMLOGEventTypeArgSsoAddLoginUrl,

    /// (sso) Added sign-out URL for SSO
    DBTEAMLOGEventTypeArgSsoAddLogoutUrl,

    /// (sso) Changed X.509 certificate for SSO
    DBTEAMLOGEventTypeArgSsoChangeCert,

    /// (sso) Changed sign-in URL for SSO
    DBTEAMLOGEventTypeArgSsoChangeLoginUrl,

    /// (sso) Changed sign-out URL for SSO
    DBTEAMLOGEventTypeArgSsoChangeLogoutUrl,

    /// (sso) Changed SAML identity mode for SSO
    DBTEAMLOGEventTypeArgSsoChangeSamlIdentityMode,

    /// (sso) Removed X.509 certificate for SSO
    DBTEAMLOGEventTypeArgSsoRemoveCert,

    /// (sso) Removed sign-in URL for SSO
    DBTEAMLOGEventTypeArgSsoRemoveLoginUrl,

    /// (sso) Removed sign-out URL for SSO
    DBTEAMLOGEventTypeArgSsoRemoveLogoutUrl,

    /// (team_folders) Changed archival status of team folder
    DBTEAMLOGEventTypeArgTeamFolderChangeStatus,

    /// (team_folders) Created team folder in active status
    DBTEAMLOGEventTypeArgTeamFolderCreate,

    /// (team_folders) Downgraded team folder to regular shared folder
    DBTEAMLOGEventTypeArgTeamFolderDowngrade,

    /// (team_folders) Permanently deleted archived team folder
    DBTEAMLOGEventTypeArgTeamFolderPermanentlyDelete,

    /// (team_folders) Renamed active/archived team folder
    DBTEAMLOGEventTypeArgTeamFolderRename,

    /// (team_folders) Changed sync default
    DBTEAMLOGEventTypeArgTeamSelectiveSyncSettingsChanged,

    /// (team_policies) Changed account capture setting on team domain
    DBTEAMLOGEventTypeArgAccountCaptureChangePolicy,

    /// (team_policies) Disabled downloads (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgAllowDownloadDisabled,

    /// (team_policies) Enabled downloads (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgAllowDownloadEnabled,

    /// (team_policies) Changed camera uploads setting for team
    DBTEAMLOGEventTypeArgCameraUploadsPolicyChanged,

    /// (team_policies) Changed classification policy for team
    DBTEAMLOGEventTypeArgClassificationChangePolicy,

    /// (team_policies) Changed computer backup policy for team
    DBTEAMLOGEventTypeArgComputerBackupPolicyChanged,

    /// (team_policies) Changed content management setting
    DBTEAMLOGEventTypeArgContentAdministrationPolicyChanged,

    /// (team_policies) Set restrictions on data center locations where team
    /// data resides
    DBTEAMLOGEventTypeArgDataPlacementRestrictionChangePolicy,

    /// (team_policies) Completed restrictions on data center locations where
    /// team data resides
    DBTEAMLOGEventTypeArgDataPlacementRestrictionSatisfyPolicy,

    /// (team_policies) Added members to device approvals exception list
    DBTEAMLOGEventTypeArgDeviceApprovalsAddException,

    /// (team_policies) Set/removed limit on number of computers member can link
    /// to team Dropbox account
    DBTEAMLOGEventTypeArgDeviceApprovalsChangeDesktopPolicy,

    /// (team_policies) Set/removed limit on number of mobile devices member can
    /// link to team Dropbox account
    DBTEAMLOGEventTypeArgDeviceApprovalsChangeMobilePolicy,

    /// (team_policies) Changed device approvals setting when member is over
    /// limit
    DBTEAMLOGEventTypeArgDeviceApprovalsChangeOverageAction,

    /// (team_policies) Changed device approvals setting when member unlinks
    /// approved device
    DBTEAMLOGEventTypeArgDeviceApprovalsChangeUnlinkAction,

    /// (team_policies) Removed members from device approvals exception list
    DBTEAMLOGEventTypeArgDeviceApprovalsRemoveException,

    /// (team_policies) Added members to directory restrictions list
    DBTEAMLOGEventTypeArgDirectoryRestrictionsAddMembers,

    /// (team_policies) Removed members from directory restrictions list
    DBTEAMLOGEventTypeArgDirectoryRestrictionsRemoveMembers,

    /// (team_policies) Added members to EMM exception list
    DBTEAMLOGEventTypeArgEmmAddException,

    /// (team_policies) Enabled/disabled enterprise mobility management for
    /// members
    DBTEAMLOGEventTypeArgEmmChangePolicy,

    /// (team_policies) Removed members from EMM exception list
    DBTEAMLOGEventTypeArgEmmRemoveException,

    /// (team_policies) Accepted/opted out of extended version history
    DBTEAMLOGEventTypeArgExtendedVersionHistoryChangePolicy,

    /// (team_policies) Enabled/disabled commenting on team files
    DBTEAMLOGEventTypeArgFileCommentsChangePolicy,

    /// (team_policies) Changed file locking policy for team
    DBTEAMLOGEventTypeArgFileLockingPolicyChanged,

    /// (team_policies) Enabled/disabled file requests
    DBTEAMLOGEventTypeArgFileRequestsChangePolicy,

    /// (team_policies) Enabled file request emails for everyone (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgFileRequestsEmailsEnabled,

    /// (team_policies) Enabled file request emails for team (deprecated, no
    /// longer logged)
    DBTEAMLOGEventTypeArgFileRequestsEmailsRestrictedToTeamOnly,

    /// (team_policies) Changed file transfers policy for team
    DBTEAMLOGEventTypeArgFileTransfersPolicyChanged,

    /// (team_policies) Enabled/disabled Google single sign-on for team
    DBTEAMLOGEventTypeArgGoogleSsoChangePolicy,

    /// (team_policies) Changed who can create groups
    DBTEAMLOGEventTypeArgGroupUserManagementChangePolicy,

    /// (team_policies) Changed integration policy for team
    DBTEAMLOGEventTypeArgIntegrationPolicyChanged,

    /// (team_policies) Changed whether users can find team when not invited
    DBTEAMLOGEventTypeArgMemberRequestsChangePolicy,

    /// (team_policies) Changed member send invite policy for team
    DBTEAMLOGEventTypeArgMemberSendInvitePolicyChanged,

    /// (team_policies) Added members to member space limit exception list
    DBTEAMLOGEventTypeArgMemberSpaceLimitsAddException,

    /// (team_policies) Changed member space limit type for team
    DBTEAMLOGEventTypeArgMemberSpaceLimitsChangeCapsTypePolicy,

    /// (team_policies) Changed team default member space limit
    DBTEAMLOGEventTypeArgMemberSpaceLimitsChangePolicy,

    /// (team_policies) Removed members from member space limit exception list
    DBTEAMLOGEventTypeArgMemberSpaceLimitsRemoveException,

    /// (team_policies) Enabled/disabled option for team members to suggest
    /// people to add to team
    DBTEAMLOGEventTypeArgMemberSuggestionsChangePolicy,

    /// (team_policies) Enabled/disabled Microsoft Office add-in
    DBTEAMLOGEventTypeArgMicrosoftOfficeAddinChangePolicy,

    /// (team_policies) Enabled/disabled network control
    DBTEAMLOGEventTypeArgNetworkControlChangePolicy,

    /// (team_policies) Changed whether Dropbox Paper, when enabled, is deployed
    /// to all members or to specific members
    DBTEAMLOGEventTypeArgPaperChangeDeploymentPolicy,

    /// (team_policies) Changed whether non-members can view Paper docs with
    /// link (deprecated, no longer logged)
    DBTEAMLOGEventTypeArgPaperChangeMemberLinkPolicy,

    /// (team_policies) Changed whether members can share Paper docs outside
    /// team, and if docs are accessible only by team members or anyone by
    /// default
    DBTEAMLOGEventTypeArgPaperChangeMemberPolicy,

    /// (team_policies) Enabled/disabled Dropbox Paper for team
    DBTEAMLOGEventTypeArgPaperChangePolicy,

    /// (team_policies) Changed Paper Default Folder Policy setting for team
    DBTEAMLOGEventTypeArgPaperDefaultFolderPolicyChanged,

    /// (team_policies) Enabled/disabled Paper Desktop for team
    DBTEAMLOGEventTypeArgPaperDesktopPolicyChanged,

    /// (team_policies) Added users to Paper-enabled users list
    DBTEAMLOGEventTypeArgPaperEnabledUsersGroupAddition,

    /// (team_policies) Removed users from Paper-enabled users list
    DBTEAMLOGEventTypeArgPaperEnabledUsersGroupRemoval,

    /// (team_policies) Changed team password strength requirements
    DBTEAMLOGEventTypeArgPasswordStrengthRequirementsChangePolicy,

    /// (team_policies) Enabled/disabled ability of team members to permanently
    /// delete content
    DBTEAMLOGEventTypeArgPermanentDeleteChangePolicy,

    /// (team_policies) Enabled/disabled reseller support
    DBTEAMLOGEventTypeArgResellerSupportChangePolicy,

    /// (team_policies) Changed Rewind policy for team
    DBTEAMLOGEventTypeArgRewindPolicyChanged,

    /// (team_policies) Changed send for signature policy for team
    DBTEAMLOGEventTypeArgSendForSignaturePolicyChanged,

    /// (team_policies) Changed whether team members can join shared folders
    /// owned outside team
    DBTEAMLOGEventTypeArgSharingChangeFolderJoinPolicy,

    /// (team_policies) Changed whether members can share links outside team,
    /// and if links are accessible only by team members or anyone by default
    DBTEAMLOGEventTypeArgSharingChangeLinkPolicy,

    /// (team_policies) Changed whether members can share files/folders outside
    /// team
    DBTEAMLOGEventTypeArgSharingChangeMemberPolicy,

    /// (team_policies) Enabled/disabled downloading files from Dropbox Showcase
    /// for team
    DBTEAMLOGEventTypeArgShowcaseChangeDownloadPolicy,

    /// (team_policies) Enabled/disabled Dropbox Showcase for team
    DBTEAMLOGEventTypeArgShowcaseChangeEnabledPolicy,

    /// (team_policies) Enabled/disabled sharing Dropbox Showcase externally for
    /// team
    DBTEAMLOGEventTypeArgShowcaseChangeExternalSharingPolicy,

    /// (team_policies) Changed automatic Smart Sync setting for team
    DBTEAMLOGEventTypeArgSmarterSmartSyncPolicyChanged,

    /// (team_policies) Changed default Smart Sync setting for team members
    DBTEAMLOGEventTypeArgSmartSyncChangePolicy,

    /// (team_policies) Opted team into Smart Sync
    DBTEAMLOGEventTypeArgSmartSyncNotOptOut,

    /// (team_policies) Opted team out of Smart Sync
    DBTEAMLOGEventTypeArgSmartSyncOptOut,

    /// (team_policies) Changed single sign-on setting for team
    DBTEAMLOGEventTypeArgSsoChangePolicy,

    /// (team_policies) Changed team branding policy for team
    DBTEAMLOGEventTypeArgTeamBrandingPolicyChanged,

    /// (team_policies) Changed App Integrations setting for team
    DBTEAMLOGEventTypeArgTeamExtensionsPolicyChanged,

    /// (team_policies) Enabled/disabled Team Selective Sync for team
    DBTEAMLOGEventTypeArgTeamSelectiveSyncPolicyChanged,

    /// (team_policies) Edited the approved list for sharing externally
    DBTEAMLOGEventTypeArgTeamSharingWhitelistSubjectsChanged,

    /// (team_policies) Added members to two factor authentication exception
    /// list
    DBTEAMLOGEventTypeArgTfaAddException,

    /// (team_policies) Changed two-step verification setting for team
    DBTEAMLOGEventTypeArgTfaChangePolicy,

    /// (team_policies) Removed members from two factor authentication exception
    /// list
    DBTEAMLOGEventTypeArgTfaRemoveException,

    /// (team_policies) Enabled/disabled option for members to link personal
    /// Dropbox account and team account to same computer
    DBTEAMLOGEventTypeArgTwoAccountChangePolicy,

    /// (team_policies) Changed team policy for viewer info
    DBTEAMLOGEventTypeArgViewerInfoPolicyChanged,

    /// (team_policies) Changed watermarking policy for team
    DBTEAMLOGEventTypeArgWatermarkingPolicyChanged,

    /// (team_policies) Changed limit on active sessions per member
    DBTEAMLOGEventTypeArgWebSessionsChangeActiveSessionLimit,

    /// (team_policies) Changed how long members can stay signed in to
    /// Dropbox.com
    DBTEAMLOGEventTypeArgWebSessionsChangeFixedLengthPolicy,

    /// (team_policies) Changed how long team members can be idle while signed
    /// in to Dropbox.com
    DBTEAMLOGEventTypeArgWebSessionsChangeIdleLengthPolicy,

    /// (team_profile) Merged another team into this team
    DBTEAMLOGEventTypeArgTeamMergeFrom,

    /// (team_profile) Merged this team into another team
    DBTEAMLOGEventTypeArgTeamMergeTo,

    /// (team_profile) Added team background to display on shared link headers
    DBTEAMLOGEventTypeArgTeamProfileAddBackground,

    /// (team_profile) Added team logo to display on shared link headers
    DBTEAMLOGEventTypeArgTeamProfileAddLogo,

    /// (team_profile) Changed team background displayed on shared link headers
    DBTEAMLOGEventTypeArgTeamProfileChangeBackground,

    /// (team_profile) Changed default language for team
    DBTEAMLOGEventTypeArgTeamProfileChangeDefaultLanguage,

    /// (team_profile) Changed team logo displayed on shared link headers
    DBTEAMLOGEventTypeArgTeamProfileChangeLogo,

    /// (team_profile) Changed team name
    DBTEAMLOGEventTypeArgTeamProfileChangeName,

    /// (team_profile) Removed team background displayed on shared link headers
    DBTEAMLOGEventTypeArgTeamProfileRemoveBackground,

    /// (team_profile) Removed team logo displayed on shared link headers
    DBTEAMLOGEventTypeArgTeamProfileRemoveLogo,

    /// (tfa) Added backup phone for two-step verification
    DBTEAMLOGEventTypeArgTfaAddBackupPhone,

    /// (tfa) Added security key for two-step verification
    DBTEAMLOGEventTypeArgTfaAddSecurityKey,

    /// (tfa) Changed backup phone for two-step verification
    DBTEAMLOGEventTypeArgTfaChangeBackupPhone,

    /// (tfa) Enabled/disabled/changed two-step verification setting
    DBTEAMLOGEventTypeArgTfaChangeStatus,

    /// (tfa) Removed backup phone for two-step verification
    DBTEAMLOGEventTypeArgTfaRemoveBackupPhone,

    /// (tfa) Removed security key for two-step verification
    DBTEAMLOGEventTypeArgTfaRemoveSecurityKey,

    /// (tfa) Reset two-step verification for team member
    DBTEAMLOGEventTypeArgTfaReset,

    /// (trusted_teams) Changed enterprise admin role
    DBTEAMLOGEventTypeArgChangedEnterpriseAdminRole,

    /// (trusted_teams) Changed enterprise-connected team status
    DBTEAMLOGEventTypeArgChangedEnterpriseConnectedTeamStatus,

    /// (trusted_teams) Ended enterprise admin session
    DBTEAMLOGEventTypeArgEndedEnterpriseAdminSession,

    /// (trusted_teams) Ended enterprise admin session (deprecated, replaced by
    /// 'Ended enterprise admin session')
    DBTEAMLOGEventTypeArgEndedEnterpriseAdminSessionDeprecated,

    /// (trusted_teams) Changed who can update a setting
    DBTEAMLOGEventTypeArgEnterpriseSettingsLocking,

    /// (trusted_teams) Changed guest team admin status
    DBTEAMLOGEventTypeArgGuestAdminChangeStatus,

    /// (trusted_teams) Started enterprise admin session
    DBTEAMLOGEventTypeArgStartedEnterpriseAdminSession,

    /// (trusted_teams) Accepted a team merge request
    DBTEAMLOGEventTypeArgTeamMergeRequestAccepted,

    /// (trusted_teams) Accepted a team merge request (deprecated, replaced by
    /// 'Accepted a team merge request')
    DBTEAMLOGEventTypeArgTeamMergeRequestAcceptedShownToPrimaryTeam,

    /// (trusted_teams) Accepted a team merge request (deprecated, replaced by
    /// 'Accepted a team merge request')
    DBTEAMLOGEventTypeArgTeamMergeRequestAcceptedShownToSecondaryTeam,

    /// (trusted_teams) Automatically canceled team merge request
    DBTEAMLOGEventTypeArgTeamMergeRequestAutoCanceled,

    /// (trusted_teams) Canceled a team merge request
    DBTEAMLOGEventTypeArgTeamMergeRequestCanceled,

    /// (trusted_teams) Canceled a team merge request (deprecated, replaced by
    /// 'Canceled a team merge request')
    DBTEAMLOGEventTypeArgTeamMergeRequestCanceledShownToPrimaryTeam,

    /// (trusted_teams) Canceled a team merge request (deprecated, replaced by
    /// 'Canceled a team merge request')
    DBTEAMLOGEventTypeArgTeamMergeRequestCanceledShownToSecondaryTeam,

    /// (trusted_teams) Team merge request expired
    DBTEAMLOGEventTypeArgTeamMergeRequestExpired,

    /// (trusted_teams) Team merge request expired (deprecated, replaced by
    /// 'Team merge request expired')
    DBTEAMLOGEventTypeArgTeamMergeRequestExpiredShownToPrimaryTeam,

    /// (trusted_teams) Team merge request expired (deprecated, replaced by
    /// 'Team merge request expired')
    DBTEAMLOGEventTypeArgTeamMergeRequestExpiredShownToSecondaryTeam,

    /// (trusted_teams) Rejected a team merge request (deprecated, no longer
    /// logged)
    DBTEAMLOGEventTypeArgTeamMergeRequestRejectedShownToPrimaryTeam,

    /// (trusted_teams) Rejected a team merge request (deprecated, no longer
    /// logged)
    DBTEAMLOGEventTypeArgTeamMergeRequestRejectedShownToSecondaryTeam,

    /// (trusted_teams) Sent a team merge request reminder
    DBTEAMLOGEventTypeArgTeamMergeRequestReminder,

    /// (trusted_teams) Sent a team merge request reminder (deprecated, replaced
    /// by 'Sent a team merge request reminder')
    DBTEAMLOGEventTypeArgTeamMergeRequestReminderShownToPrimaryTeam,

    /// (trusted_teams) Sent a team merge request reminder (deprecated, replaced
    /// by 'Sent a team merge request reminder')
    DBTEAMLOGEventTypeArgTeamMergeRequestReminderShownToSecondaryTeam,

    /// (trusted_teams) Canceled the team merge
    DBTEAMLOGEventTypeArgTeamMergeRequestRevoked,

    /// (trusted_teams) Requested to merge their Dropbox team into yours
    DBTEAMLOGEventTypeArgTeamMergeRequestSentShownToPrimaryTeam,

    /// (trusted_teams) Requested to merge your team into another Dropbox team
    DBTEAMLOGEventTypeArgTeamMergeRequestSentShownToSecondaryTeam,

    /// (no description).
    DBTEAMLOGEventTypeArgOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGEventTypeArgTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of
/// "admin_alerting_changed_alert_config".
///
/// Description of the "admin_alerting_changed_alert_config" tag state:
/// (admin_alerting) Changed an alert setting
///
/// @return An initialized instance.
///
- (instancetype)initWithAdminAlertingChangedAlertConfig;

///
/// Initializes union class with tag state of "admin_alerting_triggered_alert".
///
/// Description of the "admin_alerting_triggered_alert" tag state:
/// (admin_alerting) Triggered security alert
///
/// @return An initialized instance.
///
- (instancetype)initWithAdminAlertingTriggeredAlert;

///
/// Initializes union class with tag state of "app_link_team".
///
/// Description of the "app_link_team" tag state: (apps) Linked app for team
///
/// @return An initialized instance.
///
- (instancetype)initWithAppLinkTeam;

///
/// Initializes union class with tag state of "app_link_user".
///
/// Description of the "app_link_user" tag state: (apps) Linked app for member
///
/// @return An initialized instance.
///
- (instancetype)initWithAppLinkUser;

///
/// Initializes union class with tag state of "app_unlink_team".
///
/// Description of the "app_unlink_team" tag state: (apps) Unlinked app for team
///
/// @return An initialized instance.
///
- (instancetype)initWithAppUnlinkTeam;

///
/// Initializes union class with tag state of "app_unlink_user".
///
/// Description of the "app_unlink_user" tag state: (apps) Unlinked app for
/// member
///
/// @return An initialized instance.
///
- (instancetype)initWithAppUnlinkUser;

///
/// Initializes union class with tag state of "integration_connected".
///
/// Description of the "integration_connected" tag state: (apps) Connected
/// integration for member
///
/// @return An initialized instance.
///
- (instancetype)initWithIntegrationConnected;

///
/// Initializes union class with tag state of "integration_disconnected".
///
/// Description of the "integration_disconnected" tag state: (apps) Disconnected
/// integration for member
///
/// @return An initialized instance.
///
- (instancetype)initWithIntegrationDisconnected;

///
/// Initializes union class with tag state of "file_add_comment".
///
/// Description of the "file_add_comment" tag state: (comments) Added file
/// comment
///
/// @return An initialized instance.
///
- (instancetype)initWithFileAddComment;

///
/// Initializes union class with tag state of
/// "file_change_comment_subscription".
///
/// Description of the "file_change_comment_subscription" tag state: (comments)
/// Subscribed to or unsubscribed from comment notifications for file
///
/// @return An initialized instance.
///
- (instancetype)initWithFileChangeCommentSubscription;

///
/// Initializes union class with tag state of "file_delete_comment".
///
/// Description of the "file_delete_comment" tag state: (comments) Deleted file
/// comment
///
/// @return An initialized instance.
///
- (instancetype)initWithFileDeleteComment;

///
/// Initializes union class with tag state of "file_edit_comment".
///
/// Description of the "file_edit_comment" tag state: (comments) Edited file
/// comment
///
/// @return An initialized instance.
///
- (instancetype)initWithFileEditComment;

///
/// Initializes union class with tag state of "file_like_comment".
///
/// Description of the "file_like_comment" tag state: (comments) Liked file
/// comment (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithFileLikeComment;

///
/// Initializes union class with tag state of "file_resolve_comment".
///
/// Description of the "file_resolve_comment" tag state: (comments) Resolved
/// file comment
///
/// @return An initialized instance.
///
- (instancetype)initWithFileResolveComment;

///
/// Initializes union class with tag state of "file_unlike_comment".
///
/// Description of the "file_unlike_comment" tag state: (comments) Unliked file
/// comment (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithFileUnlikeComment;

///
/// Initializes union class with tag state of "file_unresolve_comment".
///
/// Description of the "file_unresolve_comment" tag state: (comments) Unresolved
/// file comment
///
/// @return An initialized instance.
///
- (instancetype)initWithFileUnresolveComment;

///
/// Initializes union class with tag state of "governance_policy_add_folders".
///
/// Description of the "governance_policy_add_folders" tag state:
/// (data_governance) Added folders to policy
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyAddFolders;

///
/// Initializes union class with tag state of
/// "governance_policy_add_folder_failed".
///
/// Description of the "governance_policy_add_folder_failed" tag state:
/// (data_governance) Couldn't add a folder to a policy
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyAddFolderFailed;

///
/// Initializes union class with tag state of
/// "governance_policy_content_disposed".
///
/// Description of the "governance_policy_content_disposed" tag state:
/// (data_governance) Content disposed
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyContentDisposed;

///
/// Initializes union class with tag state of "governance_policy_create".
///
/// Description of the "governance_policy_create" tag state: (data_governance)
/// Activated a new policy
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyCreate;

///
/// Initializes union class with tag state of "governance_policy_delete".
///
/// Description of the "governance_policy_delete" tag state: (data_governance)
/// Deleted a policy
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyDelete;

///
/// Initializes union class with tag state of "governance_policy_edit_details".
///
/// Description of the "governance_policy_edit_details" tag state:
/// (data_governance) Edited policy
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyEditDetails;

///
/// Initializes union class with tag state of "governance_policy_edit_duration".
///
/// Description of the "governance_policy_edit_duration" tag state:
/// (data_governance) Changed policy duration
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyEditDuration;

///
/// Initializes union class with tag state of
/// "governance_policy_export_created".
///
/// Description of the "governance_policy_export_created" tag state:
/// (data_governance) Created a policy download
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyExportCreated;

///
/// Initializes union class with tag state of
/// "governance_policy_export_removed".
///
/// Description of the "governance_policy_export_removed" tag state:
/// (data_governance) Removed a policy download
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyExportRemoved;

///
/// Initializes union class with tag state of
/// "governance_policy_remove_folders".
///
/// Description of the "governance_policy_remove_folders" tag state:
/// (data_governance) Removed folders from policy
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyRemoveFolders;

///
/// Initializes union class with tag state of
/// "governance_policy_report_created".
///
/// Description of the "governance_policy_report_created" tag state:
/// (data_governance) Created a summary report for a policy
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyReportCreated;

///
/// Initializes union class with tag state of
/// "governance_policy_zip_part_downloaded".
///
/// Description of the "governance_policy_zip_part_downloaded" tag state:
/// (data_governance) Downloaded content from a policy
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyZipPartDownloaded;

///
/// Initializes union class with tag state of "legal_holds_activate_a_hold".
///
/// Description of the "legal_holds_activate_a_hold" tag state:
/// (data_governance) Activated a hold
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldsActivateAHold;

///
/// Initializes union class with tag state of "legal_holds_add_members".
///
/// Description of the "legal_holds_add_members" tag state: (data_governance)
/// Added members to a hold
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldsAddMembers;

///
/// Initializes union class with tag state of "legal_holds_change_hold_details".
///
/// Description of the "legal_holds_change_hold_details" tag state:
/// (data_governance) Edited details for a hold
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldsChangeHoldDetails;

///
/// Initializes union class with tag state of "legal_holds_change_hold_name".
///
/// Description of the "legal_holds_change_hold_name" tag state:
/// (data_governance) Renamed a hold
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldsChangeHoldName;

///
/// Initializes union class with tag state of "legal_holds_export_a_hold".
///
/// Description of the "legal_holds_export_a_hold" tag state: (data_governance)
/// Exported hold
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldsExportAHold;

///
/// Initializes union class with tag state of "legal_holds_export_cancelled".
///
/// Description of the "legal_holds_export_cancelled" tag state:
/// (data_governance) Canceled export for a hold
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldsExportCancelled;

///
/// Initializes union class with tag state of "legal_holds_export_downloaded".
///
/// Description of the "legal_holds_export_downloaded" tag state:
/// (data_governance) Downloaded export for a hold
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldsExportDownloaded;

///
/// Initializes union class with tag state of "legal_holds_export_removed".
///
/// Description of the "legal_holds_export_removed" tag state: (data_governance)
/// Removed export for a hold
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldsExportRemoved;

///
/// Initializes union class with tag state of "legal_holds_release_a_hold".
///
/// Description of the "legal_holds_release_a_hold" tag state: (data_governance)
/// Released a hold
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldsReleaseAHold;

///
/// Initializes union class with tag state of "legal_holds_remove_members".
///
/// Description of the "legal_holds_remove_members" tag state: (data_governance)
/// Removed members from a hold
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldsRemoveMembers;

///
/// Initializes union class with tag state of "legal_holds_report_a_hold".
///
/// Description of the "legal_holds_report_a_hold" tag state: (data_governance)
/// Created a summary report for a hold
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldsReportAHold;

///
/// Initializes union class with tag state of "device_change_ip_desktop".
///
/// Description of the "device_change_ip_desktop" tag state: (devices) Changed
/// IP address associated with active desktop session
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceChangeIpDesktop;

///
/// Initializes union class with tag state of "device_change_ip_mobile".
///
/// Description of the "device_change_ip_mobile" tag state: (devices) Changed IP
/// address associated with active mobile session
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceChangeIpMobile;

///
/// Initializes union class with tag state of "device_change_ip_web".
///
/// Description of the "device_change_ip_web" tag state: (devices) Changed IP
/// address associated with active web session
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceChangeIpWeb;

///
/// Initializes union class with tag state of "device_delete_on_unlink_fail".
///
/// Description of the "device_delete_on_unlink_fail" tag state: (devices)
/// Failed to delete all files from unlinked device
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceDeleteOnUnlinkFail;

///
/// Initializes union class with tag state of "device_delete_on_unlink_success".
///
/// Description of the "device_delete_on_unlink_success" tag state: (devices)
/// Deleted all files from unlinked device
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceDeleteOnUnlinkSuccess;

///
/// Initializes union class with tag state of "device_link_fail".
///
/// Description of the "device_link_fail" tag state: (devices) Failed to link
/// device
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceLinkFail;

///
/// Initializes union class with tag state of "device_link_success".
///
/// Description of the "device_link_success" tag state: (devices) Linked device
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceLinkSuccess;

///
/// Initializes union class with tag state of "device_management_disabled".
///
/// Description of the "device_management_disabled" tag state: (devices)
/// Disabled device management (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceManagementDisabled;

///
/// Initializes union class with tag state of "device_management_enabled".
///
/// Description of the "device_management_enabled" tag state: (devices) Enabled
/// device management (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceManagementEnabled;

///
/// Initializes union class with tag state of
/// "device_sync_backup_status_changed".
///
/// Description of the "device_sync_backup_status_changed" tag state: (devices)
/// Enabled/disabled backup for computer
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceSyncBackupStatusChanged;

///
/// Initializes union class with tag state of "device_unlink".
///
/// Description of the "device_unlink" tag state: (devices) Disconnected device
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceUnlink;

///
/// Initializes union class with tag state of "dropbox_passwords_exported".
///
/// Description of the "dropbox_passwords_exported" tag state: (devices)
/// Exported passwords
///
/// @return An initialized instance.
///
- (instancetype)initWithDropboxPasswordsExported;

///
/// Initializes union class with tag state of
/// "dropbox_passwords_new_device_enrolled".
///
/// Description of the "dropbox_passwords_new_device_enrolled" tag state:
/// (devices) Enrolled new Dropbox Passwords device
///
/// @return An initialized instance.
///
- (instancetype)initWithDropboxPasswordsNewDeviceEnrolled;

///
/// Initializes union class with tag state of "emm_refresh_auth_token".
///
/// Description of the "emm_refresh_auth_token" tag state: (devices) Refreshed
/// auth token used for setting up EMM
///
/// @return An initialized instance.
///
- (instancetype)initWithEmmRefreshAuthToken;

///
/// Initializes union class with tag state of
/// "account_capture_change_availability".
///
/// Description of the "account_capture_change_availability" tag state:
/// (domains) Granted/revoked option to enable account capture on team domains
///
/// @return An initialized instance.
///
- (instancetype)initWithAccountCaptureChangeAvailability;

///
/// Initializes union class with tag state of "account_capture_migrate_account".
///
/// Description of the "account_capture_migrate_account" tag state: (domains)
/// Account-captured user migrated account to team
///
/// @return An initialized instance.
///
- (instancetype)initWithAccountCaptureMigrateAccount;

///
/// Initializes union class with tag state of
/// "account_capture_notification_emails_sent".
///
/// Description of the "account_capture_notification_emails_sent" tag state:
/// (domains) Sent account capture email to all unmanaged members
///
/// @return An initialized instance.
///
- (instancetype)initWithAccountCaptureNotificationEmailsSent;

///
/// Initializes union class with tag state of
/// "account_capture_relinquish_account".
///
/// Description of the "account_capture_relinquish_account" tag state: (domains)
/// Account-captured user changed account email to personal email
///
/// @return An initialized instance.
///
- (instancetype)initWithAccountCaptureRelinquishAccount;

///
/// Initializes union class with tag state of "disabled_domain_invites".
///
/// Description of the "disabled_domain_invites" tag state: (domains) Disabled
/// domain invites (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithDisabledDomainInvites;

///
/// Initializes union class with tag state of
/// "domain_invites_approve_request_to_join_team".
///
/// Description of the "domain_invites_approve_request_to_join_team" tag state:
/// (domains) Approved user's request to join team
///
/// @return An initialized instance.
///
- (instancetype)initWithDomainInvitesApproveRequestToJoinTeam;

///
/// Initializes union class with tag state of
/// "domain_invites_decline_request_to_join_team".
///
/// Description of the "domain_invites_decline_request_to_join_team" tag state:
/// (domains) Declined user's request to join team
///
/// @return An initialized instance.
///
- (instancetype)initWithDomainInvitesDeclineRequestToJoinTeam;

///
/// Initializes union class with tag state of
/// "domain_invites_email_existing_users".
///
/// Description of the "domain_invites_email_existing_users" tag state:
/// (domains) Sent domain invites to existing domain accounts (deprecated, no
/// longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithDomainInvitesEmailExistingUsers;

///
/// Initializes union class with tag state of
/// "domain_invites_request_to_join_team".
///
/// Description of the "domain_invites_request_to_join_team" tag state:
/// (domains) Requested to join team
///
/// @return An initialized instance.
///
- (instancetype)initWithDomainInvitesRequestToJoinTeam;

///
/// Initializes union class with tag state of
/// "domain_invites_set_invite_new_user_pref_to_no".
///
/// Description of the "domain_invites_set_invite_new_user_pref_to_no" tag
/// state: (domains) Disabled "Automatically invite new users" (deprecated, no
/// longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithDomainInvitesSetInviteNewUserPrefToNo;

///
/// Initializes union class with tag state of
/// "domain_invites_set_invite_new_user_pref_to_yes".
///
/// Description of the "domain_invites_set_invite_new_user_pref_to_yes" tag
/// state: (domains) Enabled "Automatically invite new users" (deprecated, no
/// longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithDomainInvitesSetInviteNewUserPrefToYes;

///
/// Initializes union class with tag state of
/// "domain_verification_add_domain_fail".
///
/// Description of the "domain_verification_add_domain_fail" tag state:
/// (domains) Failed to verify team domain
///
/// @return An initialized instance.
///
- (instancetype)initWithDomainVerificationAddDomainFail;

///
/// Initializes union class with tag state of
/// "domain_verification_add_domain_success".
///
/// Description of the "domain_verification_add_domain_success" tag state:
/// (domains) Verified team domain
///
/// @return An initialized instance.
///
- (instancetype)initWithDomainVerificationAddDomainSuccess;

///
/// Initializes union class with tag state of
/// "domain_verification_remove_domain".
///
/// Description of the "domain_verification_remove_domain" tag state: (domains)
/// Removed domain from list of verified team domains
///
/// @return An initialized instance.
///
- (instancetype)initWithDomainVerificationRemoveDomain;

///
/// Initializes union class with tag state of "enabled_domain_invites".
///
/// Description of the "enabled_domain_invites" tag state: (domains) Enabled
/// domain invites (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithEnabledDomainInvites;

///
/// Initializes union class with tag state of "create_folder".
///
/// Description of the "create_folder" tag state: (file_operations) Created
/// folders (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithCreateFolder;

///
/// Initializes union class with tag state of "file_add".
///
/// Description of the "file_add" tag state: (file_operations) Added files
/// and/or folders
///
/// @return An initialized instance.
///
- (instancetype)initWithFileAdd;

///
/// Initializes union class with tag state of "file_copy".
///
/// Description of the "file_copy" tag state: (file_operations) Copied files
/// and/or folders
///
/// @return An initialized instance.
///
- (instancetype)initWithFileCopy;

///
/// Initializes union class with tag state of "file_delete".
///
/// Description of the "file_delete" tag state: (file_operations) Deleted files
/// and/or folders
///
/// @return An initialized instance.
///
- (instancetype)initWithFileDelete;

///
/// Initializes union class with tag state of "file_download".
///
/// Description of the "file_download" tag state: (file_operations) Downloaded
/// files and/or folders
///
/// @return An initialized instance.
///
- (instancetype)initWithFileDownload;

///
/// Initializes union class with tag state of "file_edit".
///
/// Description of the "file_edit" tag state: (file_operations) Edited files
///
/// @return An initialized instance.
///
- (instancetype)initWithFileEdit;

///
/// Initializes union class with tag state of "file_get_copy_reference".
///
/// Description of the "file_get_copy_reference" tag state: (file_operations)
/// Created copy reference to file/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithFileGetCopyReference;

///
/// Initializes union class with tag state of
/// "file_locking_lock_status_changed".
///
/// Description of the "file_locking_lock_status_changed" tag state:
/// (file_operations) Locked/unlocked editing for a file
///
/// @return An initialized instance.
///
- (instancetype)initWithFileLockingLockStatusChanged;

///
/// Initializes union class with tag state of "file_move".
///
/// Description of the "file_move" tag state: (file_operations) Moved files
/// and/or folders
///
/// @return An initialized instance.
///
- (instancetype)initWithFileMove;

///
/// Initializes union class with tag state of "file_permanently_delete".
///
/// Description of the "file_permanently_delete" tag state: (file_operations)
/// Permanently deleted files and/or folders
///
/// @return An initialized instance.
///
- (instancetype)initWithFilePermanentlyDelete;

///
/// Initializes union class with tag state of "file_preview".
///
/// Description of the "file_preview" tag state: (file_operations) Previewed
/// files and/or folders
///
/// @return An initialized instance.
///
- (instancetype)initWithFilePreview;

///
/// Initializes union class with tag state of "file_rename".
///
/// Description of the "file_rename" tag state: (file_operations) Renamed files
/// and/or folders
///
/// @return An initialized instance.
///
- (instancetype)initWithFileRename;

///
/// Initializes union class with tag state of "file_restore".
///
/// Description of the "file_restore" tag state: (file_operations) Restored
/// deleted files and/or folders
///
/// @return An initialized instance.
///
- (instancetype)initWithFileRestore;

///
/// Initializes union class with tag state of "file_revert".
///
/// Description of the "file_revert" tag state: (file_operations) Reverted files
/// to previous version
///
/// @return An initialized instance.
///
- (instancetype)initWithFileRevert;

///
/// Initializes union class with tag state of "file_rollback_changes".
///
/// Description of the "file_rollback_changes" tag state: (file_operations)
/// Rolled back file actions
///
/// @return An initialized instance.
///
- (instancetype)initWithFileRollbackChanges;

///
/// Initializes union class with tag state of "file_save_copy_reference".
///
/// Description of the "file_save_copy_reference" tag state: (file_operations)
/// Saved file/folder using copy reference
///
/// @return An initialized instance.
///
- (instancetype)initWithFileSaveCopyReference;

///
/// Initializes union class with tag state of
/// "folder_overview_description_changed".
///
/// Description of the "folder_overview_description_changed" tag state:
/// (file_operations) Updated folder overview
///
/// @return An initialized instance.
///
- (instancetype)initWithFolderOverviewDescriptionChanged;

///
/// Initializes union class with tag state of "folder_overview_item_pinned".
///
/// Description of the "folder_overview_item_pinned" tag state:
/// (file_operations) Pinned item to folder overview
///
/// @return An initialized instance.
///
- (instancetype)initWithFolderOverviewItemPinned;

///
/// Initializes union class with tag state of "folder_overview_item_unpinned".
///
/// Description of the "folder_overview_item_unpinned" tag state:
/// (file_operations) Unpinned item from folder overview
///
/// @return An initialized instance.
///
- (instancetype)initWithFolderOverviewItemUnpinned;

///
/// Initializes union class with tag state of "object_label_added".
///
/// Description of the "object_label_added" tag state: (file_operations) Added a
/// label
///
/// @return An initialized instance.
///
- (instancetype)initWithObjectLabelAdded;

///
/// Initializes union class with tag state of "object_label_removed".
///
/// Description of the "object_label_removed" tag state: (file_operations)
/// Removed a label
///
/// @return An initialized instance.
///
- (instancetype)initWithObjectLabelRemoved;

///
/// Initializes union class with tag state of "object_label_updated_value".
///
/// Description of the "object_label_updated_value" tag state: (file_operations)
/// Updated a label's value
///
/// @return An initialized instance.
///
- (instancetype)initWithObjectLabelUpdatedValue;

///
/// Initializes union class with tag state of "rewind_folder".
///
/// Description of the "rewind_folder" tag state: (file_operations) Rewound a
/// folder
///
/// @return An initialized instance.
///
- (instancetype)initWithRewindFolder;

///
/// Initializes union class with tag state of "file_request_change".
///
/// Description of the "file_request_change" tag state: (file_requests) Changed
/// file request
///
/// @return An initialized instance.
///
- (instancetype)initWithFileRequestChange;

///
/// Initializes union class with tag state of "file_request_close".
///
/// Description of the "file_request_close" tag state: (file_requests) Closed
/// file request
///
/// @return An initialized instance.
///
- (instancetype)initWithFileRequestClose;

///
/// Initializes union class with tag state of "file_request_create".
///
/// Description of the "file_request_create" tag state: (file_requests) Created
/// file request
///
/// @return An initialized instance.
///
- (instancetype)initWithFileRequestCreate;

///
/// Initializes union class with tag state of "file_request_delete".
///
/// Description of the "file_request_delete" tag state: (file_requests) Delete
/// file request
///
/// @return An initialized instance.
///
- (instancetype)initWithFileRequestDelete;

///
/// Initializes union class with tag state of "file_request_receive_file".
///
/// Description of the "file_request_receive_file" tag state: (file_requests)
/// Received files for file request
///
/// @return An initialized instance.
///
- (instancetype)initWithFileRequestReceiveFile;

///
/// Initializes union class with tag state of "group_add_external_id".
///
/// Description of the "group_add_external_id" tag state: (groups) Added
/// external ID for group
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupAddExternalId;

///
/// Initializes union class with tag state of "group_add_member".
///
/// Description of the "group_add_member" tag state: (groups) Added team members
/// to group
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupAddMember;

///
/// Initializes union class with tag state of "group_change_external_id".
///
/// Description of the "group_change_external_id" tag state: (groups) Changed
/// external ID for group
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupChangeExternalId;

///
/// Initializes union class with tag state of "group_change_management_type".
///
/// Description of the "group_change_management_type" tag state: (groups)
/// Changed group management type
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupChangeManagementType;

///
/// Initializes union class with tag state of "group_change_member_role".
///
/// Description of the "group_change_member_role" tag state: (groups) Changed
/// manager permissions of group member
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupChangeMemberRole;

///
/// Initializes union class with tag state of "group_create".
///
/// Description of the "group_create" tag state: (groups) Created group
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupCreate;

///
/// Initializes union class with tag state of "group_delete".
///
/// Description of the "group_delete" tag state: (groups) Deleted group
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupDelete;

///
/// Initializes union class with tag state of "group_description_updated".
///
/// Description of the "group_description_updated" tag state: (groups) Updated
/// group (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupDescriptionUpdated;

///
/// Initializes union class with tag state of "group_join_policy_updated".
///
/// Description of the "group_join_policy_updated" tag state: (groups) Updated
/// group join policy (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupJoinPolicyUpdated;

///
/// Initializes union class with tag state of "group_moved".
///
/// Description of the "group_moved" tag state: (groups) Moved group
/// (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupMoved;

///
/// Initializes union class with tag state of "group_remove_external_id".
///
/// Description of the "group_remove_external_id" tag state: (groups) Removed
/// external ID for group
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupRemoveExternalId;

///
/// Initializes union class with tag state of "group_remove_member".
///
/// Description of the "group_remove_member" tag state: (groups) Removed team
/// members from group
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupRemoveMember;

///
/// Initializes union class with tag state of "group_rename".
///
/// Description of the "group_rename" tag state: (groups) Renamed group
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupRename;

///
/// Initializes union class with tag state of "account_lock_or_unlocked".
///
/// Description of the "account_lock_or_unlocked" tag state: (logins)
/// Unlocked/locked account after failed sign in attempts
///
/// @return An initialized instance.
///
- (instancetype)initWithAccountLockOrUnlocked;

///
/// Initializes union class with tag state of "emm_error".
///
/// Description of the "emm_error" tag state: (logins) Failed to sign in via EMM
/// (deprecated, replaced by 'Failed to sign in')
///
/// @return An initialized instance.
///
- (instancetype)initWithEmmError;

///
/// Initializes union class with tag state of
/// "guest_admin_signed_in_via_trusted_teams".
///
/// Description of the "guest_admin_signed_in_via_trusted_teams" tag state:
/// (logins) Started trusted team admin session
///
/// @return An initialized instance.
///
- (instancetype)initWithGuestAdminSignedInViaTrustedTeams;

///
/// Initializes union class with tag state of
/// "guest_admin_signed_out_via_trusted_teams".
///
/// Description of the "guest_admin_signed_out_via_trusted_teams" tag state:
/// (logins) Ended trusted team admin session
///
/// @return An initialized instance.
///
- (instancetype)initWithGuestAdminSignedOutViaTrustedTeams;

///
/// Initializes union class with tag state of "login_fail".
///
/// Description of the "login_fail" tag state: (logins) Failed to sign in
///
/// @return An initialized instance.
///
- (instancetype)initWithLoginFail;

///
/// Initializes union class with tag state of "login_success".
///
/// Description of the "login_success" tag state: (logins) Signed in
///
/// @return An initialized instance.
///
- (instancetype)initWithLoginSuccess;

///
/// Initializes union class with tag state of "logout".
///
/// Description of the "logout" tag state: (logins) Signed out
///
/// @return An initialized instance.
///
- (instancetype)initWithLogout;

///
/// Initializes union class with tag state of "reseller_support_session_end".
///
/// Description of the "reseller_support_session_end" tag state: (logins) Ended
/// reseller support session
///
/// @return An initialized instance.
///
- (instancetype)initWithResellerSupportSessionEnd;

///
/// Initializes union class with tag state of "reseller_support_session_start".
///
/// Description of the "reseller_support_session_start" tag state: (logins)
/// Started reseller support session
///
/// @return An initialized instance.
///
- (instancetype)initWithResellerSupportSessionStart;

///
/// Initializes union class with tag state of "sign_in_as_session_end".
///
/// Description of the "sign_in_as_session_end" tag state: (logins) Ended admin
/// sign-in-as session
///
/// @return An initialized instance.
///
- (instancetype)initWithSignInAsSessionEnd;

///
/// Initializes union class with tag state of "sign_in_as_session_start".
///
/// Description of the "sign_in_as_session_start" tag state: (logins) Started
/// admin sign-in-as session
///
/// @return An initialized instance.
///
- (instancetype)initWithSignInAsSessionStart;

///
/// Initializes union class with tag state of "sso_error".
///
/// Description of the "sso_error" tag state: (logins) Failed to sign in via SSO
/// (deprecated, replaced by 'Failed to sign in')
///
/// @return An initialized instance.
///
- (instancetype)initWithSsoError;

///
/// Initializes union class with tag state of "create_team_invite_link".
///
/// Description of the "create_team_invite_link" tag state: (members) Created
/// team invite link
///
/// @return An initialized instance.
///
- (instancetype)initWithCreateTeamInviteLink;

///
/// Initializes union class with tag state of "delete_team_invite_link".
///
/// Description of the "delete_team_invite_link" tag state: (members) Deleted
/// team invite link
///
/// @return An initialized instance.
///
- (instancetype)initWithDeleteTeamInviteLink;

///
/// Initializes union class with tag state of "member_add_external_id".
///
/// Description of the "member_add_external_id" tag state: (members) Added an
/// external ID for team member
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberAddExternalId;

///
/// Initializes union class with tag state of "member_add_name".
///
/// Description of the "member_add_name" tag state: (members) Added team member
/// name
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberAddName;

///
/// Initializes union class with tag state of "member_change_admin_role".
///
/// Description of the "member_change_admin_role" tag state: (members) Changed
/// team member admin role
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberChangeAdminRole;

///
/// Initializes union class with tag state of "member_change_email".
///
/// Description of the "member_change_email" tag state: (members) Changed team
/// member email
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberChangeEmail;

///
/// Initializes union class with tag state of "member_change_external_id".
///
/// Description of the "member_change_external_id" tag state: (members) Changed
/// the external ID for team member
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberChangeExternalId;

///
/// Initializes union class with tag state of "member_change_membership_type".
///
/// Description of the "member_change_membership_type" tag state: (members)
/// Changed membership type (limited/full) of member (deprecated, no longer
/// logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberChangeMembershipType;

///
/// Initializes union class with tag state of "member_change_name".
///
/// Description of the "member_change_name" tag state: (members) Changed team
/// member name
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberChangeName;

///
/// Initializes union class with tag state of "member_change_reseller_role".
///
/// Description of the "member_change_reseller_role" tag state: (members)
/// Changed team member reseller role
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberChangeResellerRole;

///
/// Initializes union class with tag state of "member_change_status".
///
/// Description of the "member_change_status" tag state: (members) Changed
/// member status (invited, joined, suspended, etc.)
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberChangeStatus;

///
/// Initializes union class with tag state of "member_delete_manual_contacts".
///
/// Description of the "member_delete_manual_contacts" tag state: (members)
/// Cleared manually added contacts
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberDeleteManualContacts;

///
/// Initializes union class with tag state of "member_delete_profile_photo".
///
/// Description of the "member_delete_profile_photo" tag state: (members)
/// Deleted team member profile photo
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberDeleteProfilePhoto;

///
/// Initializes union class with tag state of
/// "member_permanently_delete_account_contents".
///
/// Description of the "member_permanently_delete_account_contents" tag state:
/// (members) Permanently deleted contents of deleted team member account
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberPermanentlyDeleteAccountContents;

///
/// Initializes union class with tag state of "member_remove_external_id".
///
/// Description of the "member_remove_external_id" tag state: (members) Removed
/// the external ID for team member
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberRemoveExternalId;

///
/// Initializes union class with tag state of "member_set_profile_photo".
///
/// Description of the "member_set_profile_photo" tag state: (members) Set team
/// member profile photo
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberSetProfilePhoto;

///
/// Initializes union class with tag state of
/// "member_space_limits_add_custom_quota".
///
/// Description of the "member_space_limits_add_custom_quota" tag state:
/// (members) Set custom member space limit
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberSpaceLimitsAddCustomQuota;

///
/// Initializes union class with tag state of
/// "member_space_limits_change_custom_quota".
///
/// Description of the "member_space_limits_change_custom_quota" tag state:
/// (members) Changed custom member space limit
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberSpaceLimitsChangeCustomQuota;

///
/// Initializes union class with tag state of
/// "member_space_limits_change_status".
///
/// Description of the "member_space_limits_change_status" tag state: (members)
/// Changed space limit status
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberSpaceLimitsChangeStatus;

///
/// Initializes union class with tag state of
/// "member_space_limits_remove_custom_quota".
///
/// Description of the "member_space_limits_remove_custom_quota" tag state:
/// (members) Removed custom member space limit
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberSpaceLimitsRemoveCustomQuota;

///
/// Initializes union class with tag state of "member_suggest".
///
/// Description of the "member_suggest" tag state: (members) Suggested person to
/// add to team
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberSuggest;

///
/// Initializes union class with tag state of
/// "member_transfer_account_contents".
///
/// Description of the "member_transfer_account_contents" tag state: (members)
/// Transferred contents of deleted member account to another member
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberTransferAccountContents;

///
/// Initializes union class with tag state of "pending_secondary_email_added".
///
/// Description of the "pending_secondary_email_added" tag state: (members)
/// Added pending secondary email
///
/// @return An initialized instance.
///
- (instancetype)initWithPendingSecondaryEmailAdded;

///
/// Initializes union class with tag state of "secondary_email_deleted".
///
/// Description of the "secondary_email_deleted" tag state: (members) Deleted
/// secondary email
///
/// @return An initialized instance.
///
- (instancetype)initWithSecondaryEmailDeleted;

///
/// Initializes union class with tag state of "secondary_email_verified".
///
/// Description of the "secondary_email_verified" tag state: (members) Verified
/// secondary email
///
/// @return An initialized instance.
///
- (instancetype)initWithSecondaryEmailVerified;

///
/// Initializes union class with tag state of "secondary_mails_policy_changed".
///
/// Description of the "secondary_mails_policy_changed" tag state: (members)
/// Secondary mails policy changed
///
/// @return An initialized instance.
///
- (instancetype)initWithSecondaryMailsPolicyChanged;

///
/// Initializes union class with tag state of "binder_add_page".
///
/// Description of the "binder_add_page" tag state: (paper) Added Binder page
/// (deprecated, replaced by 'Edited files')
///
/// @return An initialized instance.
///
- (instancetype)initWithBinderAddPage;

///
/// Initializes union class with tag state of "binder_add_section".
///
/// Description of the "binder_add_section" tag state: (paper) Added Binder
/// section (deprecated, replaced by 'Edited files')
///
/// @return An initialized instance.
///
- (instancetype)initWithBinderAddSection;

///
/// Initializes union class with tag state of "binder_remove_page".
///
/// Description of the "binder_remove_page" tag state: (paper) Removed Binder
/// page (deprecated, replaced by 'Edited files')
///
/// @return An initialized instance.
///
- (instancetype)initWithBinderRemovePage;

///
/// Initializes union class with tag state of "binder_remove_section".
///
/// Description of the "binder_remove_section" tag state: (paper) Removed Binder
/// section (deprecated, replaced by 'Edited files')
///
/// @return An initialized instance.
///
- (instancetype)initWithBinderRemoveSection;

///
/// Initializes union class with tag state of "binder_rename_page".
///
/// Description of the "binder_rename_page" tag state: (paper) Renamed Binder
/// page (deprecated, replaced by 'Edited files')
///
/// @return An initialized instance.
///
- (instancetype)initWithBinderRenamePage;

///
/// Initializes union class with tag state of "binder_rename_section".
///
/// Description of the "binder_rename_section" tag state: (paper) Renamed Binder
/// section (deprecated, replaced by 'Edited files')
///
/// @return An initialized instance.
///
- (instancetype)initWithBinderRenameSection;

///
/// Initializes union class with tag state of "binder_reorder_page".
///
/// Description of the "binder_reorder_page" tag state: (paper) Reordered Binder
/// page (deprecated, replaced by 'Edited files')
///
/// @return An initialized instance.
///
- (instancetype)initWithBinderReorderPage;

///
/// Initializes union class with tag state of "binder_reorder_section".
///
/// Description of the "binder_reorder_section" tag state: (paper) Reordered
/// Binder section (deprecated, replaced by 'Edited files')
///
/// @return An initialized instance.
///
- (instancetype)initWithBinderReorderSection;

///
/// Initializes union class with tag state of "paper_content_add_member".
///
/// Description of the "paper_content_add_member" tag state: (paper) Added users
/// and/or groups to Paper doc/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperContentAddMember;

///
/// Initializes union class with tag state of "paper_content_add_to_folder".
///
/// Description of the "paper_content_add_to_folder" tag state: (paper) Added
/// Paper doc/folder to folder
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperContentAddToFolder;

///
/// Initializes union class with tag state of "paper_content_archive".
///
/// Description of the "paper_content_archive" tag state: (paper) Archived Paper
/// doc/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperContentArchive;

///
/// Initializes union class with tag state of "paper_content_create".
///
/// Description of the "paper_content_create" tag state: (paper) Created Paper
/// doc/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperContentCreate;

///
/// Initializes union class with tag state of
/// "paper_content_permanently_delete".
///
/// Description of the "paper_content_permanently_delete" tag state: (paper)
/// Permanently deleted Paper doc/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperContentPermanentlyDelete;

///
/// Initializes union class with tag state of
/// "paper_content_remove_from_folder".
///
/// Description of the "paper_content_remove_from_folder" tag state: (paper)
/// Removed Paper doc/folder from folder
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperContentRemoveFromFolder;

///
/// Initializes union class with tag state of "paper_content_remove_member".
///
/// Description of the "paper_content_remove_member" tag state: (paper) Removed
/// users and/or groups from Paper doc/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperContentRemoveMember;

///
/// Initializes union class with tag state of "paper_content_rename".
///
/// Description of the "paper_content_rename" tag state: (paper) Renamed Paper
/// doc/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperContentRename;

///
/// Initializes union class with tag state of "paper_content_restore".
///
/// Description of the "paper_content_restore" tag state: (paper) Restored
/// archived Paper doc/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperContentRestore;

///
/// Initializes union class with tag state of "paper_doc_add_comment".
///
/// Description of the "paper_doc_add_comment" tag state: (paper) Added Paper
/// doc comment
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocAddComment;

///
/// Initializes union class with tag state of "paper_doc_change_member_role".
///
/// Description of the "paper_doc_change_member_role" tag state: (paper) Changed
/// member permissions for Paper doc
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocChangeMemberRole;

///
/// Initializes union class with tag state of "paper_doc_change_sharing_policy".
///
/// Description of the "paper_doc_change_sharing_policy" tag state: (paper)
/// Changed sharing setting for Paper doc
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocChangeSharingPolicy;

///
/// Initializes union class with tag state of "paper_doc_change_subscription".
///
/// Description of the "paper_doc_change_subscription" tag state: (paper)
/// Followed/unfollowed Paper doc
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocChangeSubscription;

///
/// Initializes union class with tag state of "paper_doc_deleted".
///
/// Description of the "paper_doc_deleted" tag state: (paper) Archived Paper doc
/// (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocDeleted;

///
/// Initializes union class with tag state of "paper_doc_delete_comment".
///
/// Description of the "paper_doc_delete_comment" tag state: (paper) Deleted
/// Paper doc comment
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocDeleteComment;

///
/// Initializes union class with tag state of "paper_doc_download".
///
/// Description of the "paper_doc_download" tag state: (paper) Downloaded Paper
/// doc in specific format
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocDownload;

///
/// Initializes union class with tag state of "paper_doc_edit".
///
/// Description of the "paper_doc_edit" tag state: (paper) Edited Paper doc
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocEdit;

///
/// Initializes union class with tag state of "paper_doc_edit_comment".
///
/// Description of the "paper_doc_edit_comment" tag state: (paper) Edited Paper
/// doc comment
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocEditComment;

///
/// Initializes union class with tag state of "paper_doc_followed".
///
/// Description of the "paper_doc_followed" tag state: (paper) Followed Paper
/// doc (deprecated, replaced by 'Followed/unfollowed Paper doc')
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocFollowed;

///
/// Initializes union class with tag state of "paper_doc_mention".
///
/// Description of the "paper_doc_mention" tag state: (paper) Mentioned user in
/// Paper doc
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocMention;

///
/// Initializes union class with tag state of "paper_doc_ownership_changed".
///
/// Description of the "paper_doc_ownership_changed" tag state: (paper)
/// Transferred ownership of Paper doc
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocOwnershipChanged;

///
/// Initializes union class with tag state of "paper_doc_request_access".
///
/// Description of the "paper_doc_request_access" tag state: (paper) Requested
/// access to Paper doc
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocRequestAccess;

///
/// Initializes union class with tag state of "paper_doc_resolve_comment".
///
/// Description of the "paper_doc_resolve_comment" tag state: (paper) Resolved
/// Paper doc comment
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocResolveComment;

///
/// Initializes union class with tag state of "paper_doc_revert".
///
/// Description of the "paper_doc_revert" tag state: (paper) Restored Paper doc
/// to previous version
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocRevert;

///
/// Initializes union class with tag state of "paper_doc_slack_share".
///
/// Description of the "paper_doc_slack_share" tag state: (paper) Shared Paper
/// doc via Slack
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocSlackShare;

///
/// Initializes union class with tag state of "paper_doc_team_invite".
///
/// Description of the "paper_doc_team_invite" tag state: (paper) Shared Paper
/// doc with users and/or groups (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocTeamInvite;

///
/// Initializes union class with tag state of "paper_doc_trashed".
///
/// Description of the "paper_doc_trashed" tag state: (paper) Deleted Paper doc
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocTrashed;

///
/// Initializes union class with tag state of "paper_doc_unresolve_comment".
///
/// Description of the "paper_doc_unresolve_comment" tag state: (paper)
/// Unresolved Paper doc comment
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocUnresolveComment;

///
/// Initializes union class with tag state of "paper_doc_untrashed".
///
/// Description of the "paper_doc_untrashed" tag state: (paper) Restored Paper
/// doc
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocUntrashed;

///
/// Initializes union class with tag state of "paper_doc_view".
///
/// Description of the "paper_doc_view" tag state: (paper) Viewed Paper doc
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDocView;

///
/// Initializes union class with tag state of "paper_external_view_allow".
///
/// Description of the "paper_external_view_allow" tag state: (paper) Changed
/// Paper external sharing setting to anyone (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperExternalViewAllow;

///
/// Initializes union class with tag state of
/// "paper_external_view_default_team".
///
/// Description of the "paper_external_view_default_team" tag state: (paper)
/// Changed Paper external sharing setting to default team (deprecated, no
/// longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperExternalViewDefaultTeam;

///
/// Initializes union class with tag state of "paper_external_view_forbid".
///
/// Description of the "paper_external_view_forbid" tag state: (paper) Changed
/// Paper external sharing setting to team-only (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperExternalViewForbid;

///
/// Initializes union class with tag state of
/// "paper_folder_change_subscription".
///
/// Description of the "paper_folder_change_subscription" tag state: (paper)
/// Followed/unfollowed Paper folder
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperFolderChangeSubscription;

///
/// Initializes union class with tag state of "paper_folder_deleted".
///
/// Description of the "paper_folder_deleted" tag state: (paper) Archived Paper
/// folder (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperFolderDeleted;

///
/// Initializes union class with tag state of "paper_folder_followed".
///
/// Description of the "paper_folder_followed" tag state: (paper) Followed Paper
/// folder (deprecated, replaced by 'Followed/unfollowed Paper folder')
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperFolderFollowed;

///
/// Initializes union class with tag state of "paper_folder_team_invite".
///
/// Description of the "paper_folder_team_invite" tag state: (paper) Shared
/// Paper folder with users and/or groups (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperFolderTeamInvite;

///
/// Initializes union class with tag state of
/// "paper_published_link_change_permission".
///
/// Description of the "paper_published_link_change_permission" tag state:
/// (paper) Changed permissions for published doc
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperPublishedLinkChangePermission;

///
/// Initializes union class with tag state of "paper_published_link_create".
///
/// Description of the "paper_published_link_create" tag state: (paper)
/// Published doc
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperPublishedLinkCreate;

///
/// Initializes union class with tag state of "paper_published_link_disabled".
///
/// Description of the "paper_published_link_disabled" tag state: (paper)
/// Unpublished doc
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperPublishedLinkDisabled;

///
/// Initializes union class with tag state of "paper_published_link_view".
///
/// Description of the "paper_published_link_view" tag state: (paper) Viewed
/// published doc
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperPublishedLinkView;

///
/// Initializes union class with tag state of "password_change".
///
/// Description of the "password_change" tag state: (passwords) Changed password
///
/// @return An initialized instance.
///
- (instancetype)initWithPasswordChange;

///
/// Initializes union class with tag state of "password_reset".
///
/// Description of the "password_reset" tag state: (passwords) Reset password
///
/// @return An initialized instance.
///
- (instancetype)initWithPasswordReset;

///
/// Initializes union class with tag state of "password_reset_all".
///
/// Description of the "password_reset_all" tag state: (passwords) Reset all
/// team member passwords
///
/// @return An initialized instance.
///
- (instancetype)initWithPasswordResetAll;

///
/// Initializes union class with tag state of "classification_create_report".
///
/// Description of the "classification_create_report" tag state: (reports)
/// Created Classification report
///
/// @return An initialized instance.
///
- (instancetype)initWithClassificationCreateReport;

///
/// Initializes union class with tag state of
/// "classification_create_report_fail".
///
/// Description of the "classification_create_report_fail" tag state: (reports)
/// Couldn't create Classification report
///
/// @return An initialized instance.
///
- (instancetype)initWithClassificationCreateReportFail;

///
/// Initializes union class with tag state of "emm_create_exceptions_report".
///
/// Description of the "emm_create_exceptions_report" tag state: (reports)
/// Created EMM-excluded users report
///
/// @return An initialized instance.
///
- (instancetype)initWithEmmCreateExceptionsReport;

///
/// Initializes union class with tag state of "emm_create_usage_report".
///
/// Description of the "emm_create_usage_report" tag state: (reports) Created
/// EMM mobile app usage report
///
/// @return An initialized instance.
///
- (instancetype)initWithEmmCreateUsageReport;

///
/// Initializes union class with tag state of "export_members_report".
///
/// Description of the "export_members_report" tag state: (reports) Created
/// member data report
///
/// @return An initialized instance.
///
- (instancetype)initWithExportMembersReport;

///
/// Initializes union class with tag state of "export_members_report_fail".
///
/// Description of the "export_members_report_fail" tag state: (reports) Failed
/// to create members data report
///
/// @return An initialized instance.
///
- (instancetype)initWithExportMembersReportFail;

///
/// Initializes union class with tag state of "external_sharing_create_report".
///
/// Description of the "external_sharing_create_report" tag state: (reports)
/// Created External sharing report
///
/// @return An initialized instance.
///
- (instancetype)initWithExternalSharingCreateReport;

///
/// Initializes union class with tag state of "external_sharing_report_failed".
///
/// Description of the "external_sharing_report_failed" tag state: (reports)
/// Couldn't create External sharing report
///
/// @return An initialized instance.
///
- (instancetype)initWithExternalSharingReportFailed;

///
/// Initializes union class with tag state of
/// "no_expiration_link_gen_create_report".
///
/// Description of the "no_expiration_link_gen_create_report" tag state:
/// (reports) Report created: Links created with no expiration
///
/// @return An initialized instance.
///
- (instancetype)initWithNoExpirationLinkGenCreateReport;

///
/// Initializes union class with tag state of
/// "no_expiration_link_gen_report_failed".
///
/// Description of the "no_expiration_link_gen_report_failed" tag state:
/// (reports) Couldn't create report: Links created with no expiration
///
/// @return An initialized instance.
///
- (instancetype)initWithNoExpirationLinkGenReportFailed;

///
/// Initializes union class with tag state of
/// "no_password_link_gen_create_report".
///
/// Description of the "no_password_link_gen_create_report" tag state: (reports)
/// Report created: Links created without passwords
///
/// @return An initialized instance.
///
- (instancetype)initWithNoPasswordLinkGenCreateReport;

///
/// Initializes union class with tag state of
/// "no_password_link_gen_report_failed".
///
/// Description of the "no_password_link_gen_report_failed" tag state: (reports)
/// Couldn't create report: Links created without passwords
///
/// @return An initialized instance.
///
- (instancetype)initWithNoPasswordLinkGenReportFailed;

///
/// Initializes union class with tag state of
/// "no_password_link_view_create_report".
///
/// Description of the "no_password_link_view_create_report" tag state:
/// (reports) Report created: Views of links without passwords
///
/// @return An initialized instance.
///
- (instancetype)initWithNoPasswordLinkViewCreateReport;

///
/// Initializes union class with tag state of
/// "no_password_link_view_report_failed".
///
/// Description of the "no_password_link_view_report_failed" tag state:
/// (reports) Couldn't create report: Views of links without passwords
///
/// @return An initialized instance.
///
- (instancetype)initWithNoPasswordLinkViewReportFailed;

///
/// Initializes union class with tag state of
/// "outdated_link_view_create_report".
///
/// Description of the "outdated_link_view_create_report" tag state: (reports)
/// Report created: Views of old links
///
/// @return An initialized instance.
///
- (instancetype)initWithOutdatedLinkViewCreateReport;

///
/// Initializes union class with tag state of
/// "outdated_link_view_report_failed".
///
/// Description of the "outdated_link_view_report_failed" tag state: (reports)
/// Couldn't create report: Views of old links
///
/// @return An initialized instance.
///
- (instancetype)initWithOutdatedLinkViewReportFailed;

///
/// Initializes union class with tag state of "paper_admin_export_start".
///
/// Description of the "paper_admin_export_start" tag state: (reports) Exported
/// all team Paper docs
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperAdminExportStart;

///
/// Initializes union class with tag state of
/// "smart_sync_create_admin_privilege_report".
///
/// Description of the "smart_sync_create_admin_privilege_report" tag state:
/// (reports) Created Smart Sync non-admin devices report
///
/// @return An initialized instance.
///
- (instancetype)initWithSmartSyncCreateAdminPrivilegeReport;

///
/// Initializes union class with tag state of "team_activity_create_report".
///
/// Description of the "team_activity_create_report" tag state: (reports)
/// Created team activity report
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamActivityCreateReport;

///
/// Initializes union class with tag state of
/// "team_activity_create_report_fail".
///
/// Description of the "team_activity_create_report_fail" tag state: (reports)
/// Couldn't generate team activity report
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamActivityCreateReportFail;

///
/// Initializes union class with tag state of "collection_share".
///
/// Description of the "collection_share" tag state: (sharing) Shared album
///
/// @return An initialized instance.
///
- (instancetype)initWithCollectionShare;

///
/// Initializes union class with tag state of "file_transfers_file_add".
///
/// Description of the "file_transfers_file_add" tag state: (sharing) Transfer
/// files added
///
/// @return An initialized instance.
///
- (instancetype)initWithFileTransfersFileAdd;

///
/// Initializes union class with tag state of "file_transfers_transfer_delete".
///
/// Description of the "file_transfers_transfer_delete" tag state: (sharing)
/// Deleted transfer
///
/// @return An initialized instance.
///
- (instancetype)initWithFileTransfersTransferDelete;

///
/// Initializes union class with tag state of
/// "file_transfers_transfer_download".
///
/// Description of the "file_transfers_transfer_download" tag state: (sharing)
/// Transfer downloaded
///
/// @return An initialized instance.
///
- (instancetype)initWithFileTransfersTransferDownload;

///
/// Initializes union class with tag state of "file_transfers_transfer_send".
///
/// Description of the "file_transfers_transfer_send" tag state: (sharing) Sent
/// transfer
///
/// @return An initialized instance.
///
- (instancetype)initWithFileTransfersTransferSend;

///
/// Initializes union class with tag state of "file_transfers_transfer_view".
///
/// Description of the "file_transfers_transfer_view" tag state: (sharing)
/// Viewed transfer
///
/// @return An initialized instance.
///
- (instancetype)initWithFileTransfersTransferView;

///
/// Initializes union class with tag state of "note_acl_invite_only".
///
/// Description of the "note_acl_invite_only" tag state: (sharing) Changed Paper
/// doc to invite-only (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithNoteAclInviteOnly;

///
/// Initializes union class with tag state of "note_acl_link".
///
/// Description of the "note_acl_link" tag state: (sharing) Changed Paper doc to
/// link-accessible (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithNoteAclLink;

///
/// Initializes union class with tag state of "note_acl_team_link".
///
/// Description of the "note_acl_team_link" tag state: (sharing) Changed Paper
/// doc to link-accessible for team (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithNoteAclTeamLink;

///
/// Initializes union class with tag state of "note_shared".
///
/// Description of the "note_shared" tag state: (sharing) Shared Paper doc
/// (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithNoteShared;

///
/// Initializes union class with tag state of "note_share_receive".
///
/// Description of the "note_share_receive" tag state: (sharing) Shared received
/// Paper doc (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithNoteShareReceive;

///
/// Initializes union class with tag state of "open_note_shared".
///
/// Description of the "open_note_shared" tag state: (sharing) Opened shared
/// Paper doc (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithOpenNoteShared;

///
/// Initializes union class with tag state of "sf_add_group".
///
/// Description of the "sf_add_group" tag state: (sharing) Added team to shared
/// folder (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSfAddGroup;

///
/// Initializes union class with tag state of
/// "sf_allow_non_members_to_view_shared_links".
///
/// Description of the "sf_allow_non_members_to_view_shared_links" tag state:
/// (sharing) Allowed non-collaborators to view links to files in shared folder
/// (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSfAllowNonMembersToViewSharedLinks;

///
/// Initializes union class with tag state of "sf_external_invite_warn".
///
/// Description of the "sf_external_invite_warn" tag state: (sharing) Set team
/// members to see warning before sharing folders outside team (deprecated, no
/// longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSfExternalInviteWarn;

///
/// Initializes union class with tag state of "sf_fb_invite".
///
/// Description of the "sf_fb_invite" tag state: (sharing) Invited Facebook
/// users to shared folder (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSfFbInvite;

///
/// Initializes union class with tag state of "sf_fb_invite_change_role".
///
/// Description of the "sf_fb_invite_change_role" tag state: (sharing) Changed
/// Facebook user's role in shared folder (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSfFbInviteChangeRole;

///
/// Initializes union class with tag state of "sf_fb_uninvite".
///
/// Description of the "sf_fb_uninvite" tag state: (sharing) Uninvited Facebook
/// user from shared folder (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSfFbUninvite;

///
/// Initializes union class with tag state of "sf_invite_group".
///
/// Description of the "sf_invite_group" tag state: (sharing) Invited group to
/// shared folder (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSfInviteGroup;

///
/// Initializes union class with tag state of "sf_team_grant_access".
///
/// Description of the "sf_team_grant_access" tag state: (sharing) Granted
/// access to shared folder (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSfTeamGrantAccess;

///
/// Initializes union class with tag state of "sf_team_invite".
///
/// Description of the "sf_team_invite" tag state: (sharing) Invited team
/// members to shared folder (deprecated, replaced by 'Invited user to Dropbox
/// and added them to shared file/folder')
///
/// @return An initialized instance.
///
- (instancetype)initWithSfTeamInvite;

///
/// Initializes union class with tag state of "sf_team_invite_change_role".
///
/// Description of the "sf_team_invite_change_role" tag state: (sharing) Changed
/// team member's role in shared folder (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSfTeamInviteChangeRole;

///
/// Initializes union class with tag state of "sf_team_join".
///
/// Description of the "sf_team_join" tag state: (sharing) Joined team member's
/// shared folder (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSfTeamJoin;

///
/// Initializes union class with tag state of "sf_team_join_from_oob_link".
///
/// Description of the "sf_team_join_from_oob_link" tag state: (sharing) Joined
/// team member's shared folder from link (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSfTeamJoinFromOobLink;

///
/// Initializes union class with tag state of "sf_team_uninvite".
///
/// Description of the "sf_team_uninvite" tag state: (sharing) Unshared folder
/// with team member (deprecated, replaced by 'Removed invitee from shared
/// file/folder before invite was accepted')
///
/// @return An initialized instance.
///
- (instancetype)initWithSfTeamUninvite;

///
/// Initializes union class with tag state of "shared_content_add_invitees".
///
/// Description of the "shared_content_add_invitees" tag state: (sharing)
/// Invited user to Dropbox and added them to shared file/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentAddInvitees;

///
/// Initializes union class with tag state of "shared_content_add_link_expiry".
///
/// Description of the "shared_content_add_link_expiry" tag state: (sharing)
/// Added expiration date to link for shared file/folder (deprecated, no longer
/// logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentAddLinkExpiry;

///
/// Initializes union class with tag state of
/// "shared_content_add_link_password".
///
/// Description of the "shared_content_add_link_password" tag state: (sharing)
/// Added password to link for shared file/folder (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentAddLinkPassword;

///
/// Initializes union class with tag state of "shared_content_add_member".
///
/// Description of the "shared_content_add_member" tag state: (sharing) Added
/// users and/or groups to shared file/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentAddMember;

///
/// Initializes union class with tag state of
/// "shared_content_change_downloads_policy".
///
/// Description of the "shared_content_change_downloads_policy" tag state:
/// (sharing) Changed whether members can download shared file/folder
/// (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentChangeDownloadsPolicy;

///
/// Initializes union class with tag state of
/// "shared_content_change_invitee_role".
///
/// Description of the "shared_content_change_invitee_role" tag state: (sharing)
/// Changed access type of invitee to shared file/folder before invite was
/// accepted
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentChangeInviteeRole;

///
/// Initializes union class with tag state of
/// "shared_content_change_link_audience".
///
/// Description of the "shared_content_change_link_audience" tag state:
/// (sharing) Changed link audience of shared file/folder (deprecated, no longer
/// logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentChangeLinkAudience;

///
/// Initializes union class with tag state of
/// "shared_content_change_link_expiry".
///
/// Description of the "shared_content_change_link_expiry" tag state: (sharing)
/// Changed link expiration of shared file/folder (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentChangeLinkExpiry;

///
/// Initializes union class with tag state of
/// "shared_content_change_link_password".
///
/// Description of the "shared_content_change_link_password" tag state:
/// (sharing) Changed link password of shared file/folder (deprecated, no longer
/// logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentChangeLinkPassword;

///
/// Initializes union class with tag state of
/// "shared_content_change_member_role".
///
/// Description of the "shared_content_change_member_role" tag state: (sharing)
/// Changed access type of shared file/folder member
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentChangeMemberRole;

///
/// Initializes union class with tag state of
/// "shared_content_change_viewer_info_policy".
///
/// Description of the "shared_content_change_viewer_info_policy" tag state:
/// (sharing) Changed whether members can see who viewed shared file/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentChangeViewerInfoPolicy;

///
/// Initializes union class with tag state of "shared_content_claim_invitation".
///
/// Description of the "shared_content_claim_invitation" tag state: (sharing)
/// Acquired membership of shared file/folder by accepting invite
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentClaimInvitation;

///
/// Initializes union class with tag state of "shared_content_copy".
///
/// Description of the "shared_content_copy" tag state: (sharing) Copied shared
/// file/folder to own Dropbox
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentCopy;

///
/// Initializes union class with tag state of "shared_content_download".
///
/// Description of the "shared_content_download" tag state: (sharing) Downloaded
/// shared file/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentDownload;

///
/// Initializes union class with tag state of
/// "shared_content_relinquish_membership".
///
/// Description of the "shared_content_relinquish_membership" tag state:
/// (sharing) Left shared file/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentRelinquishMembership;

///
/// Initializes union class with tag state of "shared_content_remove_invitees".
///
/// Description of the "shared_content_remove_invitees" tag state: (sharing)
/// Removed invitee from shared file/folder before invite was accepted
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentRemoveInvitees;

///
/// Initializes union class with tag state of
/// "shared_content_remove_link_expiry".
///
/// Description of the "shared_content_remove_link_expiry" tag state: (sharing)
/// Removed link expiration date of shared file/folder (deprecated, no longer
/// logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentRemoveLinkExpiry;

///
/// Initializes union class with tag state of
/// "shared_content_remove_link_password".
///
/// Description of the "shared_content_remove_link_password" tag state:
/// (sharing) Removed link password of shared file/folder (deprecated, no longer
/// logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentRemoveLinkPassword;

///
/// Initializes union class with tag state of "shared_content_remove_member".
///
/// Description of the "shared_content_remove_member" tag state: (sharing)
/// Removed user/group from shared file/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentRemoveMember;

///
/// Initializes union class with tag state of "shared_content_request_access".
///
/// Description of the "shared_content_request_access" tag state: (sharing)
/// Requested access to shared file/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentRequestAccess;

///
/// Initializes union class with tag state of "shared_content_restore_invitees".
///
/// Description of the "shared_content_restore_invitees" tag state: (sharing)
/// Restored shared file/folder invitees
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentRestoreInvitees;

///
/// Initializes union class with tag state of "shared_content_restore_member".
///
/// Description of the "shared_content_restore_member" tag state: (sharing)
/// Restored users and/or groups to membership of shared file/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentRestoreMember;

///
/// Initializes union class with tag state of "shared_content_unshare".
///
/// Description of the "shared_content_unshare" tag state: (sharing) Unshared
/// file/folder by clearing membership
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentUnshare;

///
/// Initializes union class with tag state of "shared_content_view".
///
/// Description of the "shared_content_view" tag state: (sharing) Previewed
/// shared file/folder
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedContentView;

///
/// Initializes union class with tag state of
/// "shared_folder_change_link_policy".
///
/// Description of the "shared_folder_change_link_policy" tag state: (sharing)
/// Changed who can access shared folder via link
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedFolderChangeLinkPolicy;

///
/// Initializes union class with tag state of
/// "shared_folder_change_members_inheritance_policy".
///
/// Description of the "shared_folder_change_members_inheritance_policy" tag
/// state: (sharing) Changed whether shared folder inherits members from parent
/// folder
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedFolderChangeMembersInheritancePolicy;

///
/// Initializes union class with tag state of
/// "shared_folder_change_members_management_policy".
///
/// Description of the "shared_folder_change_members_management_policy" tag
/// state: (sharing) Changed who can add/remove members of shared folder
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedFolderChangeMembersManagementPolicy;

///
/// Initializes union class with tag state of
/// "shared_folder_change_members_policy".
///
/// Description of the "shared_folder_change_members_policy" tag state:
/// (sharing) Changed who can become member of shared folder
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedFolderChangeMembersPolicy;

///
/// Initializes union class with tag state of "shared_folder_create".
///
/// Description of the "shared_folder_create" tag state: (sharing) Created
/// shared folder
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedFolderCreate;

///
/// Initializes union class with tag state of
/// "shared_folder_decline_invitation".
///
/// Description of the "shared_folder_decline_invitation" tag state: (sharing)
/// Declined team member's invite to shared folder
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedFolderDeclineInvitation;

///
/// Initializes union class with tag state of "shared_folder_mount".
///
/// Description of the "shared_folder_mount" tag state: (sharing) Added shared
/// folder to own Dropbox
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedFolderMount;

///
/// Initializes union class with tag state of "shared_folder_nest".
///
/// Description of the "shared_folder_nest" tag state: (sharing) Changed parent
/// of shared folder
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedFolderNest;

///
/// Initializes union class with tag state of
/// "shared_folder_transfer_ownership".
///
/// Description of the "shared_folder_transfer_ownership" tag state: (sharing)
/// Transferred ownership of shared folder to another member
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedFolderTransferOwnership;

///
/// Initializes union class with tag state of "shared_folder_unmount".
///
/// Description of the "shared_folder_unmount" tag state: (sharing) Deleted
/// shared folder from Dropbox
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedFolderUnmount;

///
/// Initializes union class with tag state of "shared_link_add_expiry".
///
/// Description of the "shared_link_add_expiry" tag state: (sharing) Added
/// shared link expiration date
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkAddExpiry;

///
/// Initializes union class with tag state of "shared_link_change_expiry".
///
/// Description of the "shared_link_change_expiry" tag state: (sharing) Changed
/// shared link expiration date
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkChangeExpiry;

///
/// Initializes union class with tag state of "shared_link_change_visibility".
///
/// Description of the "shared_link_change_visibility" tag state: (sharing)
/// Changed visibility of shared link
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkChangeVisibility;

///
/// Initializes union class with tag state of "shared_link_copy".
///
/// Description of the "shared_link_copy" tag state: (sharing) Added file/folder
/// to Dropbox from shared link
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkCopy;

///
/// Initializes union class with tag state of "shared_link_create".
///
/// Description of the "shared_link_create" tag state: (sharing) Created shared
/// link
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkCreate;

///
/// Initializes union class with tag state of "shared_link_disable".
///
/// Description of the "shared_link_disable" tag state: (sharing) Removed shared
/// link
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkDisable;

///
/// Initializes union class with tag state of "shared_link_download".
///
/// Description of the "shared_link_download" tag state: (sharing) Downloaded
/// file/folder from shared link
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkDownload;

///
/// Initializes union class with tag state of "shared_link_remove_expiry".
///
/// Description of the "shared_link_remove_expiry" tag state: (sharing) Removed
/// shared link expiration date
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkRemoveExpiry;

///
/// Initializes union class with tag state of
/// "shared_link_settings_add_expiration".
///
/// Description of the "shared_link_settings_add_expiration" tag state:
/// (sharing) Added an expiration date to the shared link
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkSettingsAddExpiration;

///
/// Initializes union class with tag state of
/// "shared_link_settings_add_password".
///
/// Description of the "shared_link_settings_add_password" tag state: (sharing)
/// Added a password to the shared link
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkSettingsAddPassword;

///
/// Initializes union class with tag state of
/// "shared_link_settings_allow_download_disabled".
///
/// Description of the "shared_link_settings_allow_download_disabled" tag state:
/// (sharing) Disabled downloads
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkSettingsAllowDownloadDisabled;

///
/// Initializes union class with tag state of
/// "shared_link_settings_allow_download_enabled".
///
/// Description of the "shared_link_settings_allow_download_enabled" tag state:
/// (sharing) Enabled downloads
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkSettingsAllowDownloadEnabled;

///
/// Initializes union class with tag state of
/// "shared_link_settings_change_audience".
///
/// Description of the "shared_link_settings_change_audience" tag state:
/// (sharing) Changed the audience of the shared link
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkSettingsChangeAudience;

///
/// Initializes union class with tag state of
/// "shared_link_settings_change_expiration".
///
/// Description of the "shared_link_settings_change_expiration" tag state:
/// (sharing) Changed the expiration date of the shared link
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkSettingsChangeExpiration;

///
/// Initializes union class with tag state of
/// "shared_link_settings_change_password".
///
/// Description of the "shared_link_settings_change_password" tag state:
/// (sharing) Changed the password of the shared link
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkSettingsChangePassword;

///
/// Initializes union class with tag state of
/// "shared_link_settings_remove_expiration".
///
/// Description of the "shared_link_settings_remove_expiration" tag state:
/// (sharing) Removed the expiration date from the shared link
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkSettingsRemoveExpiration;

///
/// Initializes union class with tag state of
/// "shared_link_settings_remove_password".
///
/// Description of the "shared_link_settings_remove_password" tag state:
/// (sharing) Removed the password from the shared link
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkSettingsRemovePassword;

///
/// Initializes union class with tag state of "shared_link_share".
///
/// Description of the "shared_link_share" tag state: (sharing) Added members as
/// audience of shared link
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkShare;

///
/// Initializes union class with tag state of "shared_link_view".
///
/// Description of the "shared_link_view" tag state: (sharing) Opened shared
/// link
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedLinkView;

///
/// Initializes union class with tag state of "shared_note_opened".
///
/// Description of the "shared_note_opened" tag state: (sharing) Opened shared
/// Paper doc (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedNoteOpened;

///
/// Initializes union class with tag state of "shmodel_disable_downloads".
///
/// Description of the "shmodel_disable_downloads" tag state: (sharing) Disabled
/// downloads for link (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithShmodelDisableDownloads;

///
/// Initializes union class with tag state of "shmodel_enable_downloads".
///
/// Description of the "shmodel_enable_downloads" tag state: (sharing) Enabled
/// downloads for link (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithShmodelEnableDownloads;

///
/// Initializes union class with tag state of "shmodel_group_share".
///
/// Description of the "shmodel_group_share" tag state: (sharing) Shared link
/// with group (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithShmodelGroupShare;

///
/// Initializes union class with tag state of "showcase_access_granted".
///
/// Description of the "showcase_access_granted" tag state: (showcase) Granted
/// access to showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseAccessGranted;

///
/// Initializes union class with tag state of "showcase_add_member".
///
/// Description of the "showcase_add_member" tag state: (showcase) Added member
/// to showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseAddMember;

///
/// Initializes union class with tag state of "showcase_archived".
///
/// Description of the "showcase_archived" tag state: (showcase) Archived
/// showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseArchived;

///
/// Initializes union class with tag state of "showcase_created".
///
/// Description of the "showcase_created" tag state: (showcase) Created showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseCreated;

///
/// Initializes union class with tag state of "showcase_delete_comment".
///
/// Description of the "showcase_delete_comment" tag state: (showcase) Deleted
/// showcase comment
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseDeleteComment;

///
/// Initializes union class with tag state of "showcase_edited".
///
/// Description of the "showcase_edited" tag state: (showcase) Edited showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseEdited;

///
/// Initializes union class with tag state of "showcase_edit_comment".
///
/// Description of the "showcase_edit_comment" tag state: (showcase) Edited
/// showcase comment
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseEditComment;

///
/// Initializes union class with tag state of "showcase_file_added".
///
/// Description of the "showcase_file_added" tag state: (showcase) Added file to
/// showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseFileAdded;

///
/// Initializes union class with tag state of "showcase_file_download".
///
/// Description of the "showcase_file_download" tag state: (showcase) Downloaded
/// file from showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseFileDownload;

///
/// Initializes union class with tag state of "showcase_file_removed".
///
/// Description of the "showcase_file_removed" tag state: (showcase) Removed
/// file from showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseFileRemoved;

///
/// Initializes union class with tag state of "showcase_file_view".
///
/// Description of the "showcase_file_view" tag state: (showcase) Viewed file in
/// showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseFileView;

///
/// Initializes union class with tag state of "showcase_permanently_deleted".
///
/// Description of the "showcase_permanently_deleted" tag state: (showcase)
/// Permanently deleted showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcasePermanentlyDeleted;

///
/// Initializes union class with tag state of "showcase_post_comment".
///
/// Description of the "showcase_post_comment" tag state: (showcase) Added
/// showcase comment
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcasePostComment;

///
/// Initializes union class with tag state of "showcase_remove_member".
///
/// Description of the "showcase_remove_member" tag state: (showcase) Removed
/// member from showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseRemoveMember;

///
/// Initializes union class with tag state of "showcase_renamed".
///
/// Description of the "showcase_renamed" tag state: (showcase) Renamed showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseRenamed;

///
/// Initializes union class with tag state of "showcase_request_access".
///
/// Description of the "showcase_request_access" tag state: (showcase) Requested
/// access to showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseRequestAccess;

///
/// Initializes union class with tag state of "showcase_resolve_comment".
///
/// Description of the "showcase_resolve_comment" tag state: (showcase) Resolved
/// showcase comment
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseResolveComment;

///
/// Initializes union class with tag state of "showcase_restored".
///
/// Description of the "showcase_restored" tag state: (showcase) Unarchived
/// showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseRestored;

///
/// Initializes union class with tag state of "showcase_trashed".
///
/// Description of the "showcase_trashed" tag state: (showcase) Deleted showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseTrashed;

///
/// Initializes union class with tag state of "showcase_trashed_deprecated".
///
/// Description of the "showcase_trashed_deprecated" tag state: (showcase)
/// Deleted showcase (old version) (deprecated, replaced by 'Deleted showcase')
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseTrashedDeprecated;

///
/// Initializes union class with tag state of "showcase_unresolve_comment".
///
/// Description of the "showcase_unresolve_comment" tag state: (showcase)
/// Unresolved showcase comment
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseUnresolveComment;

///
/// Initializes union class with tag state of "showcase_untrashed".
///
/// Description of the "showcase_untrashed" tag state: (showcase) Restored
/// showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseUntrashed;

///
/// Initializes union class with tag state of "showcase_untrashed_deprecated".
///
/// Description of the "showcase_untrashed_deprecated" tag state: (showcase)
/// Restored showcase (old version) (deprecated, replaced by 'Restored
/// showcase')
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseUntrashedDeprecated;

///
/// Initializes union class with tag state of "showcase_view".
///
/// Description of the "showcase_view" tag state: (showcase) Viewed showcase
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseView;

///
/// Initializes union class with tag state of "sso_add_cert".
///
/// Description of the "sso_add_cert" tag state: (sso) Added X.509 certificate
/// for SSO
///
/// @return An initialized instance.
///
- (instancetype)initWithSsoAddCert;

///
/// Initializes union class with tag state of "sso_add_login_url".
///
/// Description of the "sso_add_login_url" tag state: (sso) Added sign-in URL
/// for SSO
///
/// @return An initialized instance.
///
- (instancetype)initWithSsoAddLoginUrl;

///
/// Initializes union class with tag state of "sso_add_logout_url".
///
/// Description of the "sso_add_logout_url" tag state: (sso) Added sign-out URL
/// for SSO
///
/// @return An initialized instance.
///
- (instancetype)initWithSsoAddLogoutUrl;

///
/// Initializes union class with tag state of "sso_change_cert".
///
/// Description of the "sso_change_cert" tag state: (sso) Changed X.509
/// certificate for SSO
///
/// @return An initialized instance.
///
- (instancetype)initWithSsoChangeCert;

///
/// Initializes union class with tag state of "sso_change_login_url".
///
/// Description of the "sso_change_login_url" tag state: (sso) Changed sign-in
/// URL for SSO
///
/// @return An initialized instance.
///
- (instancetype)initWithSsoChangeLoginUrl;

///
/// Initializes union class with tag state of "sso_change_logout_url".
///
/// Description of the "sso_change_logout_url" tag state: (sso) Changed sign-out
/// URL for SSO
///
/// @return An initialized instance.
///
- (instancetype)initWithSsoChangeLogoutUrl;

///
/// Initializes union class with tag state of "sso_change_saml_identity_mode".
///
/// Description of the "sso_change_saml_identity_mode" tag state: (sso) Changed
/// SAML identity mode for SSO
///
/// @return An initialized instance.
///
- (instancetype)initWithSsoChangeSamlIdentityMode;

///
/// Initializes union class with tag state of "sso_remove_cert".
///
/// Description of the "sso_remove_cert" tag state: (sso) Removed X.509
/// certificate for SSO
///
/// @return An initialized instance.
///
- (instancetype)initWithSsoRemoveCert;

///
/// Initializes union class with tag state of "sso_remove_login_url".
///
/// Description of the "sso_remove_login_url" tag state: (sso) Removed sign-in
/// URL for SSO
///
/// @return An initialized instance.
///
- (instancetype)initWithSsoRemoveLoginUrl;

///
/// Initializes union class with tag state of "sso_remove_logout_url".
///
/// Description of the "sso_remove_logout_url" tag state: (sso) Removed sign-out
/// URL for SSO
///
/// @return An initialized instance.
///
- (instancetype)initWithSsoRemoveLogoutUrl;

///
/// Initializes union class with tag state of "team_folder_change_status".
///
/// Description of the "team_folder_change_status" tag state: (team_folders)
/// Changed archival status of team folder
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamFolderChangeStatus;

///
/// Initializes union class with tag state of "team_folder_create".
///
/// Description of the "team_folder_create" tag state: (team_folders) Created
/// team folder in active status
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamFolderCreate;

///
/// Initializes union class with tag state of "team_folder_downgrade".
///
/// Description of the "team_folder_downgrade" tag state: (team_folders)
/// Downgraded team folder to regular shared folder
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamFolderDowngrade;

///
/// Initializes union class with tag state of "team_folder_permanently_delete".
///
/// Description of the "team_folder_permanently_delete" tag state:
/// (team_folders) Permanently deleted archived team folder
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamFolderPermanentlyDelete;

///
/// Initializes union class with tag state of "team_folder_rename".
///
/// Description of the "team_folder_rename" tag state: (team_folders) Renamed
/// active/archived team folder
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamFolderRename;

///
/// Initializes union class with tag state of
/// "team_selective_sync_settings_changed".
///
/// Description of the "team_selective_sync_settings_changed" tag state:
/// (team_folders) Changed sync default
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamSelectiveSyncSettingsChanged;

///
/// Initializes union class with tag state of "account_capture_change_policy".
///
/// Description of the "account_capture_change_policy" tag state:
/// (team_policies) Changed account capture setting on team domain
///
/// @return An initialized instance.
///
- (instancetype)initWithAccountCaptureChangePolicy;

///
/// Initializes union class with tag state of "allow_download_disabled".
///
/// Description of the "allow_download_disabled" tag state: (team_policies)
/// Disabled downloads (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithAllowDownloadDisabled;

///
/// Initializes union class with tag state of "allow_download_enabled".
///
/// Description of the "allow_download_enabled" tag state: (team_policies)
/// Enabled downloads (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithAllowDownloadEnabled;

///
/// Initializes union class with tag state of "camera_uploads_policy_changed".
///
/// Description of the "camera_uploads_policy_changed" tag state:
/// (team_policies) Changed camera uploads setting for team
///
/// @return An initialized instance.
///
- (instancetype)initWithCameraUploadsPolicyChanged;

///
/// Initializes union class with tag state of "classification_change_policy".
///
/// Description of the "classification_change_policy" tag state: (team_policies)
/// Changed classification policy for team
///
/// @return An initialized instance.
///
- (instancetype)initWithClassificationChangePolicy;

///
/// Initializes union class with tag state of "computer_backup_policy_changed".
///
/// Description of the "computer_backup_policy_changed" tag state:
/// (team_policies) Changed computer backup policy for team
///
/// @return An initialized instance.
///
- (instancetype)initWithComputerBackupPolicyChanged;

///
/// Initializes union class with tag state of
/// "content_administration_policy_changed".
///
/// Description of the "content_administration_policy_changed" tag state:
/// (team_policies) Changed content management setting
///
/// @return An initialized instance.
///
- (instancetype)initWithContentAdministrationPolicyChanged;

///
/// Initializes union class with tag state of
/// "data_placement_restriction_change_policy".
///
/// Description of the "data_placement_restriction_change_policy" tag state:
/// (team_policies) Set restrictions on data center locations where team data
/// resides
///
/// @return An initialized instance.
///
- (instancetype)initWithDataPlacementRestrictionChangePolicy;

///
/// Initializes union class with tag state of
/// "data_placement_restriction_satisfy_policy".
///
/// Description of the "data_placement_restriction_satisfy_policy" tag state:
/// (team_policies) Completed restrictions on data center locations where team
/// data resides
///
/// @return An initialized instance.
///
- (instancetype)initWithDataPlacementRestrictionSatisfyPolicy;

///
/// Initializes union class with tag state of "device_approvals_add_exception".
///
/// Description of the "device_approvals_add_exception" tag state:
/// (team_policies) Added members to device approvals exception list
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceApprovalsAddException;

///
/// Initializes union class with tag state of
/// "device_approvals_change_desktop_policy".
///
/// Description of the "device_approvals_change_desktop_policy" tag state:
/// (team_policies) Set/removed limit on number of computers member can link to
/// team Dropbox account
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceApprovalsChangeDesktopPolicy;

///
/// Initializes union class with tag state of
/// "device_approvals_change_mobile_policy".
///
/// Description of the "device_approvals_change_mobile_policy" tag state:
/// (team_policies) Set/removed limit on number of mobile devices member can
/// link to team Dropbox account
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceApprovalsChangeMobilePolicy;

///
/// Initializes union class with tag state of
/// "device_approvals_change_overage_action".
///
/// Description of the "device_approvals_change_overage_action" tag state:
/// (team_policies) Changed device approvals setting when member is over limit
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceApprovalsChangeOverageAction;

///
/// Initializes union class with tag state of
/// "device_approvals_change_unlink_action".
///
/// Description of the "device_approvals_change_unlink_action" tag state:
/// (team_policies) Changed device approvals setting when member unlinks
/// approved device
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceApprovalsChangeUnlinkAction;

///
/// Initializes union class with tag state of
/// "device_approvals_remove_exception".
///
/// Description of the "device_approvals_remove_exception" tag state:
/// (team_policies) Removed members from device approvals exception list
///
/// @return An initialized instance.
///
- (instancetype)initWithDeviceApprovalsRemoveException;

///
/// Initializes union class with tag state of
/// "directory_restrictions_add_members".
///
/// Description of the "directory_restrictions_add_members" tag state:
/// (team_policies) Added members to directory restrictions list
///
/// @return An initialized instance.
///
- (instancetype)initWithDirectoryRestrictionsAddMembers;

///
/// Initializes union class with tag state of
/// "directory_restrictions_remove_members".
///
/// Description of the "directory_restrictions_remove_members" tag state:
/// (team_policies) Removed members from directory restrictions list
///
/// @return An initialized instance.
///
- (instancetype)initWithDirectoryRestrictionsRemoveMembers;

///
/// Initializes union class with tag state of "emm_add_exception".
///
/// Description of the "emm_add_exception" tag state: (team_policies) Added
/// members to EMM exception list
///
/// @return An initialized instance.
///
- (instancetype)initWithEmmAddException;

///
/// Initializes union class with tag state of "emm_change_policy".
///
/// Description of the "emm_change_policy" tag state: (team_policies)
/// Enabled/disabled enterprise mobility management for members
///
/// @return An initialized instance.
///
- (instancetype)initWithEmmChangePolicy;

///
/// Initializes union class with tag state of "emm_remove_exception".
///
/// Description of the "emm_remove_exception" tag state: (team_policies) Removed
/// members from EMM exception list
///
/// @return An initialized instance.
///
- (instancetype)initWithEmmRemoveException;

///
/// Initializes union class with tag state of
/// "extended_version_history_change_policy".
///
/// Description of the "extended_version_history_change_policy" tag state:
/// (team_policies) Accepted/opted out of extended version history
///
/// @return An initialized instance.
///
- (instancetype)initWithExtendedVersionHistoryChangePolicy;

///
/// Initializes union class with tag state of "file_comments_change_policy".
///
/// Description of the "file_comments_change_policy" tag state: (team_policies)
/// Enabled/disabled commenting on team files
///
/// @return An initialized instance.
///
- (instancetype)initWithFileCommentsChangePolicy;

///
/// Initializes union class with tag state of "file_locking_policy_changed".
///
/// Description of the "file_locking_policy_changed" tag state: (team_policies)
/// Changed file locking policy for team
///
/// @return An initialized instance.
///
- (instancetype)initWithFileLockingPolicyChanged;

///
/// Initializes union class with tag state of "file_requests_change_policy".
///
/// Description of the "file_requests_change_policy" tag state: (team_policies)
/// Enabled/disabled file requests
///
/// @return An initialized instance.
///
- (instancetype)initWithFileRequestsChangePolicy;

///
/// Initializes union class with tag state of "file_requests_emails_enabled".
///
/// Description of the "file_requests_emails_enabled" tag state: (team_policies)
/// Enabled file request emails for everyone (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithFileRequestsEmailsEnabled;

///
/// Initializes union class with tag state of
/// "file_requests_emails_restricted_to_team_only".
///
/// Description of the "file_requests_emails_restricted_to_team_only" tag state:
/// (team_policies) Enabled file request emails for team (deprecated, no longer
/// logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithFileRequestsEmailsRestrictedToTeamOnly;

///
/// Initializes union class with tag state of "file_transfers_policy_changed".
///
/// Description of the "file_transfers_policy_changed" tag state:
/// (team_policies) Changed file transfers policy for team
///
/// @return An initialized instance.
///
- (instancetype)initWithFileTransfersPolicyChanged;

///
/// Initializes union class with tag state of "google_sso_change_policy".
///
/// Description of the "google_sso_change_policy" tag state: (team_policies)
/// Enabled/disabled Google single sign-on for team
///
/// @return An initialized instance.
///
- (instancetype)initWithGoogleSsoChangePolicy;

///
/// Initializes union class with tag state of
/// "group_user_management_change_policy".
///
/// Description of the "group_user_management_change_policy" tag state:
/// (team_policies) Changed who can create groups
///
/// @return An initialized instance.
///
- (instancetype)initWithGroupUserManagementChangePolicy;

///
/// Initializes union class with tag state of "integration_policy_changed".
///
/// Description of the "integration_policy_changed" tag state: (team_policies)
/// Changed integration policy for team
///
/// @return An initialized instance.
///
- (instancetype)initWithIntegrationPolicyChanged;

///
/// Initializes union class with tag state of "member_requests_change_policy".
///
/// Description of the "member_requests_change_policy" tag state:
/// (team_policies) Changed whether users can find team when not invited
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberRequestsChangePolicy;

///
/// Initializes union class with tag state of
/// "member_send_invite_policy_changed".
///
/// Description of the "member_send_invite_policy_changed" tag state:
/// (team_policies) Changed member send invite policy for team
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberSendInvitePolicyChanged;

///
/// Initializes union class with tag state of
/// "member_space_limits_add_exception".
///
/// Description of the "member_space_limits_add_exception" tag state:
/// (team_policies) Added members to member space limit exception list
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberSpaceLimitsAddException;

///
/// Initializes union class with tag state of
/// "member_space_limits_change_caps_type_policy".
///
/// Description of the "member_space_limits_change_caps_type_policy" tag state:
/// (team_policies) Changed member space limit type for team
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberSpaceLimitsChangeCapsTypePolicy;

///
/// Initializes union class with tag state of
/// "member_space_limits_change_policy".
///
/// Description of the "member_space_limits_change_policy" tag state:
/// (team_policies) Changed team default member space limit
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberSpaceLimitsChangePolicy;

///
/// Initializes union class with tag state of
/// "member_space_limits_remove_exception".
///
/// Description of the "member_space_limits_remove_exception" tag state:
/// (team_policies) Removed members from member space limit exception list
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberSpaceLimitsRemoveException;

///
/// Initializes union class with tag state of
/// "member_suggestions_change_policy".
///
/// Description of the "member_suggestions_change_policy" tag state:
/// (team_policies) Enabled/disabled option for team members to suggest people
/// to add to team
///
/// @return An initialized instance.
///
- (instancetype)initWithMemberSuggestionsChangePolicy;

///
/// Initializes union class with tag state of
/// "microsoft_office_addin_change_policy".
///
/// Description of the "microsoft_office_addin_change_policy" tag state:
/// (team_policies) Enabled/disabled Microsoft Office add-in
///
/// @return An initialized instance.
///
- (instancetype)initWithMicrosoftOfficeAddinChangePolicy;

///
/// Initializes union class with tag state of "network_control_change_policy".
///
/// Description of the "network_control_change_policy" tag state:
/// (team_policies) Enabled/disabled network control
///
/// @return An initialized instance.
///
- (instancetype)initWithNetworkControlChangePolicy;

///
/// Initializes union class with tag state of "paper_change_deployment_policy".
///
/// Description of the "paper_change_deployment_policy" tag state:
/// (team_policies) Changed whether Dropbox Paper, when enabled, is deployed to
/// all members or to specific members
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperChangeDeploymentPolicy;

///
/// Initializes union class with tag state of "paper_change_member_link_policy".
///
/// Description of the "paper_change_member_link_policy" tag state:
/// (team_policies) Changed whether non-members can view Paper docs with link
/// (deprecated, no longer logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperChangeMemberLinkPolicy;

///
/// Initializes union class with tag state of "paper_change_member_policy".
///
/// Description of the "paper_change_member_policy" tag state: (team_policies)
/// Changed whether members can share Paper docs outside team, and if docs are
/// accessible only by team members or anyone by default
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperChangeMemberPolicy;

///
/// Initializes union class with tag state of "paper_change_policy".
///
/// Description of the "paper_change_policy" tag state: (team_policies)
/// Enabled/disabled Dropbox Paper for team
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperChangePolicy;

///
/// Initializes union class with tag state of
/// "paper_default_folder_policy_changed".
///
/// Description of the "paper_default_folder_policy_changed" tag state:
/// (team_policies) Changed Paper Default Folder Policy setting for team
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDefaultFolderPolicyChanged;

///
/// Initializes union class with tag state of "paper_desktop_policy_changed".
///
/// Description of the "paper_desktop_policy_changed" tag state: (team_policies)
/// Enabled/disabled Paper Desktop for team
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperDesktopPolicyChanged;

///
/// Initializes union class with tag state of
/// "paper_enabled_users_group_addition".
///
/// Description of the "paper_enabled_users_group_addition" tag state:
/// (team_policies) Added users to Paper-enabled users list
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperEnabledUsersGroupAddition;

///
/// Initializes union class with tag state of
/// "paper_enabled_users_group_removal".
///
/// Description of the "paper_enabled_users_group_removal" tag state:
/// (team_policies) Removed users from Paper-enabled users list
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperEnabledUsersGroupRemoval;

///
/// Initializes union class with tag state of
/// "password_strength_requirements_change_policy".
///
/// Description of the "password_strength_requirements_change_policy" tag state:
/// (team_policies) Changed team password strength requirements
///
/// @return An initialized instance.
///
- (instancetype)initWithPasswordStrengthRequirementsChangePolicy;

///
/// Initializes union class with tag state of "permanent_delete_change_policy".
///
/// Description of the "permanent_delete_change_policy" tag state:
/// (team_policies) Enabled/disabled ability of team members to permanently
/// delete content
///
/// @return An initialized instance.
///
- (instancetype)initWithPermanentDeleteChangePolicy;

///
/// Initializes union class with tag state of "reseller_support_change_policy".
///
/// Description of the "reseller_support_change_policy" tag state:
/// (team_policies) Enabled/disabled reseller support
///
/// @return An initialized instance.
///
- (instancetype)initWithResellerSupportChangePolicy;

///
/// Initializes union class with tag state of "rewind_policy_changed".
///
/// Description of the "rewind_policy_changed" tag state: (team_policies)
/// Changed Rewind policy for team
///
/// @return An initialized instance.
///
- (instancetype)initWithRewindPolicyChanged;

///
/// Initializes union class with tag state of
/// "send_for_signature_policy_changed".
///
/// Description of the "send_for_signature_policy_changed" tag state:
/// (team_policies) Changed send for signature policy for team
///
/// @return An initialized instance.
///
- (instancetype)initWithSendForSignaturePolicyChanged;

///
/// Initializes union class with tag state of
/// "sharing_change_folder_join_policy".
///
/// Description of the "sharing_change_folder_join_policy" tag state:
/// (team_policies) Changed whether team members can join shared folders owned
/// outside team
///
/// @return An initialized instance.
///
- (instancetype)initWithSharingChangeFolderJoinPolicy;

///
/// Initializes union class with tag state of "sharing_change_link_policy".
///
/// Description of the "sharing_change_link_policy" tag state: (team_policies)
/// Changed whether members can share links outside team, and if links are
/// accessible only by team members or anyone by default
///
/// @return An initialized instance.
///
- (instancetype)initWithSharingChangeLinkPolicy;

///
/// Initializes union class with tag state of "sharing_change_member_policy".
///
/// Description of the "sharing_change_member_policy" tag state: (team_policies)
/// Changed whether members can share files/folders outside team
///
/// @return An initialized instance.
///
- (instancetype)initWithSharingChangeMemberPolicy;

///
/// Initializes union class with tag state of "showcase_change_download_policy".
///
/// Description of the "showcase_change_download_policy" tag state:
/// (team_policies) Enabled/disabled downloading files from Dropbox Showcase for
/// team
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseChangeDownloadPolicy;

///
/// Initializes union class with tag state of "showcase_change_enabled_policy".
///
/// Description of the "showcase_change_enabled_policy" tag state:
/// (team_policies) Enabled/disabled Dropbox Showcase for team
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseChangeEnabledPolicy;

///
/// Initializes union class with tag state of
/// "showcase_change_external_sharing_policy".
///
/// Description of the "showcase_change_external_sharing_policy" tag state:
/// (team_policies) Enabled/disabled sharing Dropbox Showcase externally for
/// team
///
/// @return An initialized instance.
///
- (instancetype)initWithShowcaseChangeExternalSharingPolicy;

///
/// Initializes union class with tag state of
/// "smarter_smart_sync_policy_changed".
///
/// Description of the "smarter_smart_sync_policy_changed" tag state:
/// (team_policies) Changed automatic Smart Sync setting for team
///
/// @return An initialized instance.
///
- (instancetype)initWithSmarterSmartSyncPolicyChanged;

///
/// Initializes union class with tag state of "smart_sync_change_policy".
///
/// Description of the "smart_sync_change_policy" tag state: (team_policies)
/// Changed default Smart Sync setting for team members
///
/// @return An initialized instance.
///
- (instancetype)initWithSmartSyncChangePolicy;

///
/// Initializes union class with tag state of "smart_sync_not_opt_out".
///
/// Description of the "smart_sync_not_opt_out" tag state: (team_policies) Opted
/// team into Smart Sync
///
/// @return An initialized instance.
///
- (instancetype)initWithSmartSyncNotOptOut;

///
/// Initializes union class with tag state of "smart_sync_opt_out".
///
/// Description of the "smart_sync_opt_out" tag state: (team_policies) Opted
/// team out of Smart Sync
///
/// @return An initialized instance.
///
- (instancetype)initWithSmartSyncOptOut;

///
/// Initializes union class with tag state of "sso_change_policy".
///
/// Description of the "sso_change_policy" tag state: (team_policies) Changed
/// single sign-on setting for team
///
/// @return An initialized instance.
///
- (instancetype)initWithSsoChangePolicy;

///
/// Initializes union class with tag state of "team_branding_policy_changed".
///
/// Description of the "team_branding_policy_changed" tag state: (team_policies)
/// Changed team branding policy for team
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamBrandingPolicyChanged;

///
/// Initializes union class with tag state of "team_extensions_policy_changed".
///
/// Description of the "team_extensions_policy_changed" tag state:
/// (team_policies) Changed App Integrations setting for team
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamExtensionsPolicyChanged;

///
/// Initializes union class with tag state of
/// "team_selective_sync_policy_changed".
///
/// Description of the "team_selective_sync_policy_changed" tag state:
/// (team_policies) Enabled/disabled Team Selective Sync for team
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamSelectiveSyncPolicyChanged;

///
/// Initializes union class with tag state of
/// "team_sharing_whitelist_subjects_changed".
///
/// Description of the "team_sharing_whitelist_subjects_changed" tag state:
/// (team_policies) Edited the approved list for sharing externally
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamSharingWhitelistSubjectsChanged;

///
/// Initializes union class with tag state of "tfa_add_exception".
///
/// Description of the "tfa_add_exception" tag state: (team_policies) Added
/// members to two factor authentication exception list
///
/// @return An initialized instance.
///
- (instancetype)initWithTfaAddException;

///
/// Initializes union class with tag state of "tfa_change_policy".
///
/// Description of the "tfa_change_policy" tag state: (team_policies) Changed
/// two-step verification setting for team
///
/// @return An initialized instance.
///
- (instancetype)initWithTfaChangePolicy;

///
/// Initializes union class with tag state of "tfa_remove_exception".
///
/// Description of the "tfa_remove_exception" tag state: (team_policies) Removed
/// members from two factor authentication exception list
///
/// @return An initialized instance.
///
- (instancetype)initWithTfaRemoveException;

///
/// Initializes union class with tag state of "two_account_change_policy".
///
/// Description of the "two_account_change_policy" tag state: (team_policies)
/// Enabled/disabled option for members to link personal Dropbox account and
/// team account to same computer
///
/// @return An initialized instance.
///
- (instancetype)initWithTwoAccountChangePolicy;

///
/// Initializes union class with tag state of "viewer_info_policy_changed".
///
/// Description of the "viewer_info_policy_changed" tag state: (team_policies)
/// Changed team policy for viewer info
///
/// @return An initialized instance.
///
- (instancetype)initWithViewerInfoPolicyChanged;

///
/// Initializes union class with tag state of "watermarking_policy_changed".
///
/// Description of the "watermarking_policy_changed" tag state: (team_policies)
/// Changed watermarking policy for team
///
/// @return An initialized instance.
///
- (instancetype)initWithWatermarkingPolicyChanged;

///
/// Initializes union class with tag state of
/// "web_sessions_change_active_session_limit".
///
/// Description of the "web_sessions_change_active_session_limit" tag state:
/// (team_policies) Changed limit on active sessions per member
///
/// @return An initialized instance.
///
- (instancetype)initWithWebSessionsChangeActiveSessionLimit;

///
/// Initializes union class with tag state of
/// "web_sessions_change_fixed_length_policy".
///
/// Description of the "web_sessions_change_fixed_length_policy" tag state:
/// (team_policies) Changed how long members can stay signed in to Dropbox.com
///
/// @return An initialized instance.
///
- (instancetype)initWithWebSessionsChangeFixedLengthPolicy;

///
/// Initializes union class with tag state of
/// "web_sessions_change_idle_length_policy".
///
/// Description of the "web_sessions_change_idle_length_policy" tag state:
/// (team_policies) Changed how long team members can be idle while signed in to
/// Dropbox.com
///
/// @return An initialized instance.
///
- (instancetype)initWithWebSessionsChangeIdleLengthPolicy;

///
/// Initializes union class with tag state of "team_merge_from".
///
/// Description of the "team_merge_from" tag state: (team_profile) Merged
/// another team into this team
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeFrom;

///
/// Initializes union class with tag state of "team_merge_to".
///
/// Description of the "team_merge_to" tag state: (team_profile) Merged this
/// team into another team
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeTo;

///
/// Initializes union class with tag state of "team_profile_add_background".
///
/// Description of the "team_profile_add_background" tag state: (team_profile)
/// Added team background to display on shared link headers
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamProfileAddBackground;

///
/// Initializes union class with tag state of "team_profile_add_logo".
///
/// Description of the "team_profile_add_logo" tag state: (team_profile) Added
/// team logo to display on shared link headers
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamProfileAddLogo;

///
/// Initializes union class with tag state of "team_profile_change_background".
///
/// Description of the "team_profile_change_background" tag state:
/// (team_profile) Changed team background displayed on shared link headers
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamProfileChangeBackground;

///
/// Initializes union class with tag state of
/// "team_profile_change_default_language".
///
/// Description of the "team_profile_change_default_language" tag state:
/// (team_profile) Changed default language for team
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamProfileChangeDefaultLanguage;

///
/// Initializes union class with tag state of "team_profile_change_logo".
///
/// Description of the "team_profile_change_logo" tag state: (team_profile)
/// Changed team logo displayed on shared link headers
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamProfileChangeLogo;

///
/// Initializes union class with tag state of "team_profile_change_name".
///
/// Description of the "team_profile_change_name" tag state: (team_profile)
/// Changed team name
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamProfileChangeName;

///
/// Initializes union class with tag state of "team_profile_remove_background".
///
/// Description of the "team_profile_remove_background" tag state:
/// (team_profile) Removed team background displayed on shared link headers
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamProfileRemoveBackground;

///
/// Initializes union class with tag state of "team_profile_remove_logo".
///
/// Description of the "team_profile_remove_logo" tag state: (team_profile)
/// Removed team logo displayed on shared link headers
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamProfileRemoveLogo;

///
/// Initializes union class with tag state of "tfa_add_backup_phone".
///
/// Description of the "tfa_add_backup_phone" tag state: (tfa) Added backup
/// phone for two-step verification
///
/// @return An initialized instance.
///
- (instancetype)initWithTfaAddBackupPhone;

///
/// Initializes union class with tag state of "tfa_add_security_key".
///
/// Description of the "tfa_add_security_key" tag state: (tfa) Added security
/// key for two-step verification
///
/// @return An initialized instance.
///
- (instancetype)initWithTfaAddSecurityKey;

///
/// Initializes union class with tag state of "tfa_change_backup_phone".
///
/// Description of the "tfa_change_backup_phone" tag state: (tfa) Changed backup
/// phone for two-step verification
///
/// @return An initialized instance.
///
- (instancetype)initWithTfaChangeBackupPhone;

///
/// Initializes union class with tag state of "tfa_change_status".
///
/// Description of the "tfa_change_status" tag state: (tfa)
/// Enabled/disabled/changed two-step verification setting
///
/// @return An initialized instance.
///
- (instancetype)initWithTfaChangeStatus;

///
/// Initializes union class with tag state of "tfa_remove_backup_phone".
///
/// Description of the "tfa_remove_backup_phone" tag state: (tfa) Removed backup
/// phone for two-step verification
///
/// @return An initialized instance.
///
- (instancetype)initWithTfaRemoveBackupPhone;

///
/// Initializes union class with tag state of "tfa_remove_security_key".
///
/// Description of the "tfa_remove_security_key" tag state: (tfa) Removed
/// security key for two-step verification
///
/// @return An initialized instance.
///
- (instancetype)initWithTfaRemoveSecurityKey;

///
/// Initializes union class with tag state of "tfa_reset".
///
/// Description of the "tfa_reset" tag state: (tfa) Reset two-step verification
/// for team member
///
/// @return An initialized instance.
///
- (instancetype)initWithTfaReset;

///
/// Initializes union class with tag state of "changed_enterprise_admin_role".
///
/// Description of the "changed_enterprise_admin_role" tag state:
/// (trusted_teams) Changed enterprise admin role
///
/// @return An initialized instance.
///
- (instancetype)initWithChangedEnterpriseAdminRole;

///
/// Initializes union class with tag state of
/// "changed_enterprise_connected_team_status".
///
/// Description of the "changed_enterprise_connected_team_status" tag state:
/// (trusted_teams) Changed enterprise-connected team status
///
/// @return An initialized instance.
///
- (instancetype)initWithChangedEnterpriseConnectedTeamStatus;

///
/// Initializes union class with tag state of "ended_enterprise_admin_session".
///
/// Description of the "ended_enterprise_admin_session" tag state:
/// (trusted_teams) Ended enterprise admin session
///
/// @return An initialized instance.
///
- (instancetype)initWithEndedEnterpriseAdminSession;

///
/// Initializes union class with tag state of
/// "ended_enterprise_admin_session_deprecated".
///
/// Description of the "ended_enterprise_admin_session_deprecated" tag state:
/// (trusted_teams) Ended enterprise admin session (deprecated, replaced by
/// 'Ended enterprise admin session')
///
/// @return An initialized instance.
///
- (instancetype)initWithEndedEnterpriseAdminSessionDeprecated;

///
/// Initializes union class with tag state of "enterprise_settings_locking".
///
/// Description of the "enterprise_settings_locking" tag state: (trusted_teams)
/// Changed who can update a setting
///
/// @return An initialized instance.
///
- (instancetype)initWithEnterpriseSettingsLocking;

///
/// Initializes union class with tag state of "guest_admin_change_status".
///
/// Description of the "guest_admin_change_status" tag state: (trusted_teams)
/// Changed guest team admin status
///
/// @return An initialized instance.
///
- (instancetype)initWithGuestAdminChangeStatus;

///
/// Initializes union class with tag state of
/// "started_enterprise_admin_session".
///
/// Description of the "started_enterprise_admin_session" tag state:
/// (trusted_teams) Started enterprise admin session
///
/// @return An initialized instance.
///
- (instancetype)initWithStartedEnterpriseAdminSession;

///
/// Initializes union class with tag state of "team_merge_request_accepted".
///
/// Description of the "team_merge_request_accepted" tag state: (trusted_teams)
/// Accepted a team merge request
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestAccepted;

///
/// Initializes union class with tag state of
/// "team_merge_request_accepted_shown_to_primary_team".
///
/// Description of the "team_merge_request_accepted_shown_to_primary_team" tag
/// state: (trusted_teams) Accepted a team merge request (deprecated, replaced
/// by 'Accepted a team merge request')
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestAcceptedShownToPrimaryTeam;

///
/// Initializes union class with tag state of
/// "team_merge_request_accepted_shown_to_secondary_team".
///
/// Description of the "team_merge_request_accepted_shown_to_secondary_team" tag
/// state: (trusted_teams) Accepted a team merge request (deprecated, replaced
/// by 'Accepted a team merge request')
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestAcceptedShownToSecondaryTeam;

///
/// Initializes union class with tag state of
/// "team_merge_request_auto_canceled".
///
/// Description of the "team_merge_request_auto_canceled" tag state:
/// (trusted_teams) Automatically canceled team merge request
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestAutoCanceled;

///
/// Initializes union class with tag state of "team_merge_request_canceled".
///
/// Description of the "team_merge_request_canceled" tag state: (trusted_teams)
/// Canceled a team merge request
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestCanceled;

///
/// Initializes union class with tag state of
/// "team_merge_request_canceled_shown_to_primary_team".
///
/// Description of the "team_merge_request_canceled_shown_to_primary_team" tag
/// state: (trusted_teams) Canceled a team merge request (deprecated, replaced
/// by 'Canceled a team merge request')
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestCanceledShownToPrimaryTeam;

///
/// Initializes union class with tag state of
/// "team_merge_request_canceled_shown_to_secondary_team".
///
/// Description of the "team_merge_request_canceled_shown_to_secondary_team" tag
/// state: (trusted_teams) Canceled a team merge request (deprecated, replaced
/// by 'Canceled a team merge request')
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestCanceledShownToSecondaryTeam;

///
/// Initializes union class with tag state of "team_merge_request_expired".
///
/// Description of the "team_merge_request_expired" tag state: (trusted_teams)
/// Team merge request expired
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestExpired;

///
/// Initializes union class with tag state of
/// "team_merge_request_expired_shown_to_primary_team".
///
/// Description of the "team_merge_request_expired_shown_to_primary_team" tag
/// state: (trusted_teams) Team merge request expired (deprecated, replaced by
/// 'Team merge request expired')
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestExpiredShownToPrimaryTeam;

///
/// Initializes union class with tag state of
/// "team_merge_request_expired_shown_to_secondary_team".
///
/// Description of the "team_merge_request_expired_shown_to_secondary_team" tag
/// state: (trusted_teams) Team merge request expired (deprecated, replaced by
/// 'Team merge request expired')
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestExpiredShownToSecondaryTeam;

///
/// Initializes union class with tag state of
/// "team_merge_request_rejected_shown_to_primary_team".
///
/// Description of the "team_merge_request_rejected_shown_to_primary_team" tag
/// state: (trusted_teams) Rejected a team merge request (deprecated, no longer
/// logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestRejectedShownToPrimaryTeam;

///
/// Initializes union class with tag state of
/// "team_merge_request_rejected_shown_to_secondary_team".
///
/// Description of the "team_merge_request_rejected_shown_to_secondary_team" tag
/// state: (trusted_teams) Rejected a team merge request (deprecated, no longer
/// logged)
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestRejectedShownToSecondaryTeam;

///
/// Initializes union class with tag state of "team_merge_request_reminder".
///
/// Description of the "team_merge_request_reminder" tag state: (trusted_teams)
/// Sent a team merge request reminder
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestReminder;

///
/// Initializes union class with tag state of
/// "team_merge_request_reminder_shown_to_primary_team".
///
/// Description of the "team_merge_request_reminder_shown_to_primary_team" tag
/// state: (trusted_teams) Sent a team merge request reminder (deprecated,
/// replaced by 'Sent a team merge request reminder')
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestReminderShownToPrimaryTeam;

///
/// Initializes union class with tag state of
/// "team_merge_request_reminder_shown_to_secondary_team".
///
/// Description of the "team_merge_request_reminder_shown_to_secondary_team" tag
/// state: (trusted_teams) Sent a team merge request reminder (deprecated,
/// replaced by 'Sent a team merge request reminder')
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestReminderShownToSecondaryTeam;

///
/// Initializes union class with tag state of "team_merge_request_revoked".
///
/// Description of the "team_merge_request_revoked" tag state: (trusted_teams)
/// Canceled the team merge
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestRevoked;

///
/// Initializes union class with tag state of
/// "team_merge_request_sent_shown_to_primary_team".
///
/// Description of the "team_merge_request_sent_shown_to_primary_team" tag
/// state: (trusted_teams) Requested to merge their Dropbox team into yours
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestSentShownToPrimaryTeam;

///
/// Initializes union class with tag state of
/// "team_merge_request_sent_shown_to_secondary_team".
///
/// Description of the "team_merge_request_sent_shown_to_secondary_team" tag
/// state: (trusted_teams) Requested to merge your team into another Dropbox
/// team
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMergeRequestSentShownToSecondaryTeam;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "admin_alerting_changed_alert_config".
///
/// @return Whether the union's current tag state has value
/// "admin_alerting_changed_alert_config".
///
- (BOOL)isAdminAlertingChangedAlertConfig;

///
/// Retrieves whether the union's current tag state has value
/// "admin_alerting_triggered_alert".
///
/// @return Whether the union's current tag state has value
/// "admin_alerting_triggered_alert".
///
- (BOOL)isAdminAlertingTriggeredAlert;

///
/// Retrieves whether the union's current tag state has value "app_link_team".
///
/// @return Whether the union's current tag state has value "app_link_team".
///
- (BOOL)isAppLinkTeam;

///
/// Retrieves whether the union's current tag state has value "app_link_user".
///
/// @return Whether the union's current tag state has value "app_link_user".
///
- (BOOL)isAppLinkUser;

///
/// Retrieves whether the union's current tag state has value "app_unlink_team".
///
/// @return Whether the union's current tag state has value "app_unlink_team".
///
- (BOOL)isAppUnlinkTeam;

///
/// Retrieves whether the union's current tag state has value "app_unlink_user".
///
/// @return Whether the union's current tag state has value "app_unlink_user".
///
- (BOOL)isAppUnlinkUser;

///
/// Retrieves whether the union's current tag state has value
/// "integration_connected".
///
/// @return Whether the union's current tag state has value
/// "integration_connected".
///
- (BOOL)isIntegrationConnected;

///
/// Retrieves whether the union's current tag state has value
/// "integration_disconnected".
///
/// @return Whether the union's current tag state has value
/// "integration_disconnected".
///
- (BOOL)isIntegrationDisconnected;

///
/// Retrieves whether the union's current tag state has value
/// "file_add_comment".
///
/// @return Whether the union's current tag state has value "file_add_comment".
///
- (BOOL)isFileAddComment;

///
/// Retrieves whether the union's current tag state has value
/// "file_change_comment_subscription".
///
/// @return Whether the union's current tag state has value
/// "file_change_comment_subscription".
///
- (BOOL)isFileChangeCommentSubscription;

///
/// Retrieves whether the union's current tag state has value
/// "file_delete_comment".
///
/// @return Whether the union's current tag state has value
/// "file_delete_comment".
///
- (BOOL)isFileDeleteComment;

///
/// Retrieves whether the union's current tag state has value
/// "file_edit_comment".
///
/// @return Whether the union's current tag state has value "file_edit_comment".
///
- (BOOL)isFileEditComment;

///
/// Retrieves whether the union's current tag state has value
/// "file_like_comment".
///
/// @return Whether the union's current tag state has value "file_like_comment".
///
- (BOOL)isFileLikeComment;

///
/// Retrieves whether the union's current tag state has value
/// "file_resolve_comment".
///
/// @return Whether the union's current tag state has value
/// "file_resolve_comment".
///
- (BOOL)isFileResolveComment;

///
/// Retrieves whether the union's current tag state has value
/// "file_unlike_comment".
///
/// @return Whether the union's current tag state has value
/// "file_unlike_comment".
///
- (BOOL)isFileUnlikeComment;

///
/// Retrieves whether the union's current tag state has value
/// "file_unresolve_comment".
///
/// @return Whether the union's current tag state has value
/// "file_unresolve_comment".
///
- (BOOL)isFileUnresolveComment;

///
/// Retrieves whether the union's current tag state has value
/// "governance_policy_add_folders".
///
/// @return Whether the union's current tag state has value
/// "governance_policy_add_folders".
///
- (BOOL)isGovernancePolicyAddFolders;

///
/// Retrieves whether the union's current tag state has value
/// "governance_policy_add_folder_failed".
///
/// @return Whether the union's current tag state has value
/// "governance_policy_add_folder_failed".
///
- (BOOL)isGovernancePolicyAddFolderFailed;

///
/// Retrieves whether the union's current tag state has value
/// "governance_policy_content_disposed".
///
/// @return Whether the union's current tag state has value
/// "governance_policy_content_disposed".
///
- (BOOL)isGovernancePolicyContentDisposed;

///
/// Retrieves whether the union's current tag state has value
/// "governance_policy_create".
///
/// @return Whether the union's current tag state has value
/// "governance_policy_create".
///
- (BOOL)isGovernancePolicyCreate;

///
/// Retrieves whether the union's current tag state has value
/// "governance_policy_delete".
///
/// @return Whether the union's current tag state has value
/// "governance_policy_delete".
///
- (BOOL)isGovernancePolicyDelete;

///
/// Retrieves whether the union's current tag state has value
/// "governance_policy_edit_details".
///
/// @return Whether the union's current tag state has value
/// "governance_policy_edit_details".
///
- (BOOL)isGovernancePolicyEditDetails;

///
/// Retrieves whether the union's current tag state has value
/// "governance_policy_edit_duration".
///
/// @return Whether the union's current tag state has value
/// "governance_policy_edit_duration".
///
- (BOOL)isGovernancePolicyEditDuration;

///
/// Retrieves whether the union's current tag state has value
/// "governance_policy_export_created".
///
/// @return Whether the union's current tag state has value
/// "governance_policy_export_created".
///
- (BOOL)isGovernancePolicyExportCreated;

///
/// Retrieves whether the union's current tag state has value
/// "governance_policy_export_removed".
///
/// @return Whether the union's current tag state has value
/// "governance_policy_export_removed".
///
- (BOOL)isGovernancePolicyExportRemoved;

///
/// Retrieves whether the union's current tag state has value
/// "governance_policy_remove_folders".
///
/// @return Whether the union's current tag state has value
/// "governance_policy_remove_folders".
///
- (BOOL)isGovernancePolicyRemoveFolders;

///
/// Retrieves whether the union's current tag state has value
/// "governance_policy_report_created".
///
/// @return Whether the union's current tag state has value
/// "governance_policy_report_created".
///
- (BOOL)isGovernancePolicyReportCreated;

///
/// Retrieves whether the union's current tag state has value
/// "governance_policy_zip_part_downloaded".
///
/// @return Whether the union's current tag state has value
/// "governance_policy_zip_part_downloaded".
///
- (BOOL)isGovernancePolicyZipPartDownloaded;

///
/// Retrieves whether the union's current tag state has value
/// "legal_holds_activate_a_hold".
///
/// @return Whether the union's current tag state has value
/// "legal_holds_activate_a_hold".
///
- (BOOL)isLegalHoldsActivateAHold;

///
/// Retrieves whether the union's current tag state has value
/// "legal_holds_add_members".
///
/// @return Whether the union's current tag state has value
/// "legal_holds_add_members".
///
- (BOOL)isLegalHoldsAddMembers;

///
/// Retrieves whether the union's current tag state has value
/// "legal_holds_change_hold_details".
///
/// @return Whether the union's current tag state has value
/// "legal_holds_change_hold_details".
///
- (BOOL)isLegalHoldsChangeHoldDetails;

///
/// Retrieves whether the union's current tag state has value
/// "legal_holds_change_hold_name".
///
/// @return Whether the union's current tag state has value
/// "legal_holds_change_hold_name".
///
- (BOOL)isLegalHoldsChangeHoldName;

///
/// Retrieves whether the union's current tag state has value
/// "legal_holds_export_a_hold".
///
/// @return Whether the union's current tag state has value
/// "legal_holds_export_a_hold".
///
- (BOOL)isLegalHoldsExportAHold;

///
/// Retrieves whether the union's current tag state has value
/// "legal_holds_export_cancelled".
///
/// @return Whether the union's current tag state has value
/// "legal_holds_export_cancelled".
///
- (BOOL)isLegalHoldsExportCancelled;

///
/// Retrieves whether the union's current tag state has value
/// "legal_holds_export_downloaded".
///
/// @return Whether the union's current tag state has value
/// "legal_holds_export_downloaded".
///
- (BOOL)isLegalHoldsExportDownloaded;

///
/// Retrieves whether the union's current tag state has value
/// "legal_holds_export_removed".
///
/// @return Whether the union's current tag state has value
/// "legal_holds_export_removed".
///
- (BOOL)isLegalHoldsExportRemoved;

///
/// Retrieves whether the union's current tag state has value
/// "legal_holds_release_a_hold".
///
/// @return Whether the union's current tag state has value
/// "legal_holds_release_a_hold".
///
- (BOOL)isLegalHoldsReleaseAHold;

///
/// Retrieves whether the union's current tag state has value
/// "legal_holds_remove_members".
///
/// @return Whether the union's current tag state has value
/// "legal_holds_remove_members".
///
- (BOOL)isLegalHoldsRemoveMembers;

///
/// Retrieves whether the union's current tag state has value
/// "legal_holds_report_a_hold".
///
/// @return Whether the union's current tag state has value
/// "legal_holds_report_a_hold".
///
- (BOOL)isLegalHoldsReportAHold;

///
/// Retrieves whether the union's current tag state has value
/// "device_change_ip_desktop".
///
/// @return Whether the union's current tag state has value
/// "device_change_ip_desktop".
///
- (BOOL)isDeviceChangeIpDesktop;

///
/// Retrieves whether the union's current tag state has value
/// "device_change_ip_mobile".
///
/// @return Whether the union's current tag state has value
/// "device_change_ip_mobile".
///
- (BOOL)isDeviceChangeIpMobile;

///
/// Retrieves whether the union's current tag state has value
/// "device_change_ip_web".
///
/// @return Whether the union's current tag state has value
/// "device_change_ip_web".
///
- (BOOL)isDeviceChangeIpWeb;

///
/// Retrieves whether the union's current tag state has value
/// "device_delete_on_unlink_fail".
///
/// @return Whether the union's current tag state has value
/// "device_delete_on_unlink_fail".
///
- (BOOL)isDeviceDeleteOnUnlinkFail;

///
/// Retrieves whether the union's current tag state has value
/// "device_delete_on_unlink_success".
///
/// @return Whether the union's current tag state has value
/// "device_delete_on_unlink_success".
///
- (BOOL)isDeviceDeleteOnUnlinkSuccess;

///
/// Retrieves whether the union's current tag state has value
/// "device_link_fail".
///
/// @return Whether the union's current tag state has value "device_link_fail".
///
- (BOOL)isDeviceLinkFail;

///
/// Retrieves whether the union's current tag state has value
/// "device_link_success".
///
/// @return Whether the union's current tag state has value
/// "device_link_success".
///
- (BOOL)isDeviceLinkSuccess;

///
/// Retrieves whether the union's current tag state has value
/// "device_management_disabled".
///
/// @return Whether the union's current tag state has value
/// "device_management_disabled".
///
- (BOOL)isDeviceManagementDisabled;

///
/// Retrieves whether the union's current tag state has value
/// "device_management_enabled".
///
/// @return Whether the union's current tag state has value
/// "device_management_enabled".
///
- (BOOL)isDeviceManagementEnabled;

///
/// Retrieves whether the union's current tag state has value
/// "device_sync_backup_status_changed".
///
/// @return Whether the union's current tag state has value
/// "device_sync_backup_status_changed".
///
- (BOOL)isDeviceSyncBackupStatusChanged;

///
/// Retrieves whether the union's current tag state has value "device_unlink".
///
/// @return Whether the union's current tag state has value "device_unlink".
///
- (BOOL)isDeviceUnlink;

///
/// Retrieves whether the union's current tag state has value
/// "dropbox_passwords_exported".
///
/// @return Whether the union's current tag state has value
/// "dropbox_passwords_exported".
///
- (BOOL)isDropboxPasswordsExported;

///
/// Retrieves whether the union's current tag state has value
/// "dropbox_passwords_new_device_enrolled".
///
/// @return Whether the union's current tag state has value
/// "dropbox_passwords_new_device_enrolled".
///
- (BOOL)isDropboxPasswordsNewDeviceEnrolled;

///
/// Retrieves whether the union's current tag state has value
/// "emm_refresh_auth_token".
///
/// @return Whether the union's current tag state has value
/// "emm_refresh_auth_token".
///
- (BOOL)isEmmRefreshAuthToken;

///
/// Retrieves whether the union's current tag state has value
/// "account_capture_change_availability".
///
/// @return Whether the union's current tag state has value
/// "account_capture_change_availability".
///
- (BOOL)isAccountCaptureChangeAvailability;

///
/// Retrieves whether the union's current tag state has value
/// "account_capture_migrate_account".
///
/// @return Whether the union's current tag state has value
/// "account_capture_migrate_account".
///
- (BOOL)isAccountCaptureMigrateAccount;

///
/// Retrieves whether the union's current tag state has value
/// "account_capture_notification_emails_sent".
///
/// @return Whether the union's current tag state has value
/// "account_capture_notification_emails_sent".
///
- (BOOL)isAccountCaptureNotificationEmailsSent;

///
/// Retrieves whether the union's current tag state has value
/// "account_capture_relinquish_account".
///
/// @return Whether the union's current tag state has value
/// "account_capture_relinquish_account".
///
- (BOOL)isAccountCaptureRelinquishAccount;

///
/// Retrieves whether the union's current tag state has value
/// "disabled_domain_invites".
///
/// @return Whether the union's current tag state has value
/// "disabled_domain_invites".
///
- (BOOL)isDisabledDomainInvites;

///
/// Retrieves whether the union's current tag state has value
/// "domain_invites_approve_request_to_join_team".
///
/// @return Whether the union's current tag state has value
/// "domain_invites_approve_request_to_join_team".
///
- (BOOL)isDomainInvitesApproveRequestToJoinTeam;

///
/// Retrieves whether the union's current tag state has value
/// "domain_invites_decline_request_to_join_team".
///
/// @return Whether the union's current tag state has value
/// "domain_invites_decline_request_to_join_team".
///
- (BOOL)isDomainInvitesDeclineRequestToJoinTeam;

///
/// Retrieves whether the union's current tag state has value
/// "domain_invites_email_existing_users".
///
/// @return Whether the union's current tag state has value
/// "domain_invites_email_existing_users".
///
- (BOOL)isDomainInvitesEmailExistingUsers;

///
/// Retrieves whether the union's current tag state has value
/// "domain_invites_request_to_join_team".
///
/// @return Whether the union's current tag state has value
/// "domain_invites_request_to_join_team".
///
- (BOOL)isDomainInvitesRequestToJoinTeam;

///
/// Retrieves whether the union's current tag state has value
/// "domain_invites_set_invite_new_user_pref_to_no".
///
/// @return Whether the union's current tag state has value
/// "domain_invites_set_invite_new_user_pref_to_no".
///
- (BOOL)isDomainInvitesSetInviteNewUserPrefToNo;

///
/// Retrieves whether the union's current tag state has value
/// "domain_invites_set_invite_new_user_pref_to_yes".
///
/// @return Whether the union's current tag state has value
/// "domain_invites_set_invite_new_user_pref_to_yes".
///
- (BOOL)isDomainInvitesSetInviteNewUserPrefToYes;

///
/// Retrieves whether the union's current tag state has value
/// "domain_verification_add_domain_fail".
///
/// @return Whether the union's current tag state has value
/// "domain_verification_add_domain_fail".
///
- (BOOL)isDomainVerificationAddDomainFail;

///
/// Retrieves whether the union's current tag state has value
/// "domain_verification_add_domain_success".
///
/// @return Whether the union's current tag state has value
/// "domain_verification_add_domain_success".
///
- (BOOL)isDomainVerificationAddDomainSuccess;

///
/// Retrieves whether the union's current tag state has value
/// "domain_verification_remove_domain".
///
/// @return Whether the union's current tag state has value
/// "domain_verification_remove_domain".
///
- (BOOL)isDomainVerificationRemoveDomain;

///
/// Retrieves whether the union's current tag state has value
/// "enabled_domain_invites".
///
/// @return Whether the union's current tag state has value
/// "enabled_domain_invites".
///
- (BOOL)isEnabledDomainInvites;

///
/// Retrieves whether the union's current tag state has value "create_folder".
///
/// @return Whether the union's current tag state has value "create_folder".
///
- (BOOL)isCreateFolder;

///
/// Retrieves whether the union's current tag state has value "file_add".
///
/// @return Whether the union's current tag state has value "file_add".
///
- (BOOL)isFileAdd;

///
/// Retrieves whether the union's current tag state has value "file_copy".
///
/// @return Whether the union's current tag state has value "file_copy".
///
- (BOOL)isFileCopy;

///
/// Retrieves whether the union's current tag state has value "file_delete".
///
/// @return Whether the union's current tag state has value "file_delete".
///
- (BOOL)isFileDelete;

///
/// Retrieves whether the union's current tag state has value "file_download".
///
/// @return Whether the union's current tag state has value "file_download".
///
- (BOOL)isFileDownload;

///
/// Retrieves whether the union's current tag state has value "file_edit".
///
/// @return Whether the union's current tag state has value "file_edit".
///
- (BOOL)isFileEdit;

///
/// Retrieves whether the union's current tag state has value
/// "file_get_copy_reference".
///
/// @return Whether the union's current tag state has value
/// "file_get_copy_reference".
///
- (BOOL)isFileGetCopyReference;

///
/// Retrieves whether the union's current tag state has value
/// "file_locking_lock_status_changed".
///
/// @return Whether the union's current tag state has value
/// "file_locking_lock_status_changed".
///
- (BOOL)isFileLockingLockStatusChanged;

///
/// Retrieves whether the union's current tag state has value "file_move".
///
/// @return Whether the union's current tag state has value "file_move".
///
- (BOOL)isFileMove;

///
/// Retrieves whether the union's current tag state has value
/// "file_permanently_delete".
///
/// @return Whether the union's current tag state has value
/// "file_permanently_delete".
///
- (BOOL)isFilePermanentlyDelete;

///
/// Retrieves whether the union's current tag state has value "file_preview".
///
/// @return Whether the union's current tag state has value "file_preview".
///
- (BOOL)isFilePreview;

///
/// Retrieves whether the union's current tag state has value "file_rename".
///
/// @return Whether the union's current tag state has value "file_rename".
///
- (BOOL)isFileRename;

///
/// Retrieves whether the union's current tag state has value "file_restore".
///
/// @return Whether the union's current tag state has value "file_restore".
///
- (BOOL)isFileRestore;

///
/// Retrieves whether the union's current tag state has value "file_revert".
///
/// @return Whether the union's current tag state has value "file_revert".
///
- (BOOL)isFileRevert;

///
/// Retrieves whether the union's current tag state has value
/// "file_rollback_changes".
///
/// @return Whether the union's current tag state has value
/// "file_rollback_changes".
///
- (BOOL)isFileRollbackChanges;

///
/// Retrieves whether the union's current tag state has value
/// "file_save_copy_reference".
///
/// @return Whether the union's current tag state has value
/// "file_save_copy_reference".
///
- (BOOL)isFileSaveCopyReference;

///
/// Retrieves whether the union's current tag state has value
/// "folder_overview_description_changed".
///
/// @return Whether the union's current tag state has value
/// "folder_overview_description_changed".
///
- (BOOL)isFolderOverviewDescriptionChanged;

///
/// Retrieves whether the union's current tag state has value
/// "folder_overview_item_pinned".
///
/// @return Whether the union's current tag state has value
/// "folder_overview_item_pinned".
///
- (BOOL)isFolderOverviewItemPinned;

///
/// Retrieves whether the union's current tag state has value
/// "folder_overview_item_unpinned".
///
/// @return Whether the union's current tag state has value
/// "folder_overview_item_unpinned".
///
- (BOOL)isFolderOverviewItemUnpinned;

///
/// Retrieves whether the union's current tag state has value
/// "object_label_added".
///
/// @return Whether the union's current tag state has value
/// "object_label_added".
///
- (BOOL)isObjectLabelAdded;

///
/// Retrieves whether the union's current tag state has value
/// "object_label_removed".
///
/// @return Whether the union's current tag state has value
/// "object_label_removed".
///
- (BOOL)isObjectLabelRemoved;

///
/// Retrieves whether the union's current tag state has value
/// "object_label_updated_value".
///
/// @return Whether the union's current tag state has value
/// "object_label_updated_value".
///
- (BOOL)isObjectLabelUpdatedValue;

///
/// Retrieves whether the union's current tag state has value "rewind_folder".
///
/// @return Whether the union's current tag state has value "rewind_folder".
///
- (BOOL)isRewindFolder;

///
/// Retrieves whether the union's current tag state has value
/// "file_request_change".
///
/// @return Whether the union's current tag state has value
/// "file_request_change".
///
- (BOOL)isFileRequestChange;

///
/// Retrieves whether the union's current tag state has value
/// "file_request_close".
///
/// @return Whether the union's current tag state has value
/// "file_request_close".
///
- (BOOL)isFileRequestClose;

///
/// Retrieves whether the union's current tag state has value
/// "file_request_create".
///
/// @return Whether the union's current tag state has value
/// "file_request_create".
///
- (BOOL)isFileRequestCreate;

///
/// Retrieves whether the union's current tag state has value
/// "file_request_delete".
///
/// @return Whether the union's current tag state has value
/// "file_request_delete".
///
- (BOOL)isFileRequestDelete;

///
/// Retrieves whether the union's current tag state has value
/// "file_request_receive_file".
///
/// @return Whether the union's current tag state has value
/// "file_request_receive_file".
///
- (BOOL)isFileRequestReceiveFile;

///
/// Retrieves whether the union's current tag state has value
/// "group_add_external_id".
///
/// @return Whether the union's current tag state has value
/// "group_add_external_id".
///
- (BOOL)isGroupAddExternalId;

///
/// Retrieves whether the union's current tag state has value
/// "group_add_member".
///
/// @return Whether the union's current tag state has value "group_add_member".
///
- (BOOL)isGroupAddMember;

///
/// Retrieves whether the union's current tag state has value
/// "group_change_external_id".
///
/// @return Whether the union's current tag state has value
/// "group_change_external_id".
///
- (BOOL)isGroupChangeExternalId;

///
/// Retrieves whether the union's current tag state has value
/// "group_change_management_type".
///
/// @return Whether the union's current tag state has value
/// "group_change_management_type".
///
- (BOOL)isGroupChangeManagementType;

///
/// Retrieves whether the union's current tag state has value
/// "group_change_member_role".
///
/// @return Whether the union's current tag state has value
/// "group_change_member_role".
///
- (BOOL)isGroupChangeMemberRole;

///
/// Retrieves whether the union's current tag state has value "group_create".
///
/// @return Whether the union's current tag state has value "group_create".
///
- (BOOL)isGroupCreate;

///
/// Retrieves whether the union's current tag state has value "group_delete".
///
/// @return Whether the union's current tag state has value "group_delete".
///
- (BOOL)isGroupDelete;

///
/// Retrieves whether the union's current tag state has value
/// "group_description_updated".
///
/// @return Whether the union's current tag state has value
/// "group_description_updated".
///
- (BOOL)isGroupDescriptionUpdated;

///
/// Retrieves whether the union's current tag state has value
/// "group_join_policy_updated".
///
/// @return Whether the union's current tag state has value
/// "group_join_policy_updated".
///
- (BOOL)isGroupJoinPolicyUpdated;

///
/// Retrieves whether the union's current tag state has value "group_moved".
///
/// @return Whether the union's current tag state has value "group_moved".
///
- (BOOL)isGroupMoved;

///
/// Retrieves whether the union's current tag state has value
/// "group_remove_external_id".
///
/// @return Whether the union's current tag state has value
/// "group_remove_external_id".
///
- (BOOL)isGroupRemoveExternalId;

///
/// Retrieves whether the union's current tag state has value
/// "group_remove_member".
///
/// @return Whether the union's current tag state has value
/// "group_remove_member".
///
- (BOOL)isGroupRemoveMember;

///
/// Retrieves whether the union's current tag state has value "group_rename".
///
/// @return Whether the union's current tag state has value "group_rename".
///
- (BOOL)isGroupRename;

///
/// Retrieves whether the union's current tag state has value
/// "account_lock_or_unlocked".
///
/// @return Whether the union's current tag state has value
/// "account_lock_or_unlocked".
///
- (BOOL)isAccountLockOrUnlocked;

///
/// Retrieves whether the union's current tag state has value "emm_error".
///
/// @return Whether the union's current tag state has value "emm_error".
///
- (BOOL)isEmmError;

///
/// Retrieves whether the union's current tag state has value
/// "guest_admin_signed_in_via_trusted_teams".
///
/// @return Whether the union's current tag state has value
/// "guest_admin_signed_in_via_trusted_teams".
///
- (BOOL)isGuestAdminSignedInViaTrustedTeams;

///
/// Retrieves whether the union's current tag state has value
/// "guest_admin_signed_out_via_trusted_teams".
///
/// @return Whether the union's current tag state has value
/// "guest_admin_signed_out_via_trusted_teams".
///
- (BOOL)isGuestAdminSignedOutViaTrustedTeams;

///
/// Retrieves whether the union's current tag state has value "login_fail".
///
/// @return Whether the union's current tag state has value "login_fail".
///
- (BOOL)isLoginFail;

///
/// Retrieves whether the union's current tag state has value "login_success".
///
/// @return Whether the union's current tag state has value "login_success".
///
- (BOOL)isLoginSuccess;

///
/// Retrieves whether the union's current tag state has value "logout".
///
/// @return Whether the union's current tag state has value "logout".
///
- (BOOL)isLogout;

///
/// Retrieves whether the union's current tag state has value
/// "reseller_support_session_end".
///
/// @return Whether the union's current tag state has value
/// "reseller_support_session_end".
///
- (BOOL)isResellerSupportSessionEnd;

///
/// Retrieves whether the union's current tag state has value
/// "reseller_support_session_start".
///
/// @return Whether the union's current tag state has value
/// "reseller_support_session_start".
///
- (BOOL)isResellerSupportSessionStart;

///
/// Retrieves whether the union's current tag state has value
/// "sign_in_as_session_end".
///
/// @return Whether the union's current tag state has value
/// "sign_in_as_session_end".
///
- (BOOL)isSignInAsSessionEnd;

///
/// Retrieves whether the union's current tag state has value
/// "sign_in_as_session_start".
///
/// @return Whether the union's current tag state has value
/// "sign_in_as_session_start".
///
- (BOOL)isSignInAsSessionStart;

///
/// Retrieves whether the union's current tag state has value "sso_error".
///
/// @return Whether the union's current tag state has value "sso_error".
///
- (BOOL)isSsoError;

///
/// Retrieves whether the union's current tag state has value
/// "create_team_invite_link".
///
/// @return Whether the union's current tag state has value
/// "create_team_invite_link".
///
- (BOOL)isCreateTeamInviteLink;

///
/// Retrieves whether the union's current tag state has value
/// "delete_team_invite_link".
///
/// @return Whether the union's current tag state has value
/// "delete_team_invite_link".
///
- (BOOL)isDeleteTeamInviteLink;

///
/// Retrieves whether the union's current tag state has value
/// "member_add_external_id".
///
/// @return Whether the union's current tag state has value
/// "member_add_external_id".
///
- (BOOL)isMemberAddExternalId;

///
/// Retrieves whether the union's current tag state has value "member_add_name".
///
/// @return Whether the union's current tag state has value "member_add_name".
///
- (BOOL)isMemberAddName;

///
/// Retrieves whether the union's current tag state has value
/// "member_change_admin_role".
///
/// @return Whether the union's current tag state has value
/// "member_change_admin_role".
///
- (BOOL)isMemberChangeAdminRole;

///
/// Retrieves whether the union's current tag state has value
/// "member_change_email".
///
/// @return Whether the union's current tag state has value
/// "member_change_email".
///
- (BOOL)isMemberChangeEmail;

///
/// Retrieves whether the union's current tag state has value
/// "member_change_external_id".
///
/// @return Whether the union's current tag state has value
/// "member_change_external_id".
///
- (BOOL)isMemberChangeExternalId;

///
/// Retrieves whether the union's current tag state has value
/// "member_change_membership_type".
///
/// @return Whether the union's current tag state has value
/// "member_change_membership_type".
///
- (BOOL)isMemberChangeMembershipType;

///
/// Retrieves whether the union's current tag state has value
/// "member_change_name".
///
/// @return Whether the union's current tag state has value
/// "member_change_name".
///
- (BOOL)isMemberChangeName;

///
/// Retrieves whether the union's current tag state has value
/// "member_change_reseller_role".
///
/// @return Whether the union's current tag state has value
/// "member_change_reseller_role".
///
- (BOOL)isMemberChangeResellerRole;

///
/// Retrieves whether the union's current tag state has value
/// "member_change_status".
///
/// @return Whether the union's current tag state has value
/// "member_change_status".
///
- (BOOL)isMemberChangeStatus;

///
/// Retrieves whether the union's current tag state has value
/// "member_delete_manual_contacts".
///
/// @return Whether the union's current tag state has value
/// "member_delete_manual_contacts".
///
- (BOOL)isMemberDeleteManualContacts;

///
/// Retrieves whether the union's current tag state has value
/// "member_delete_profile_photo".
///
/// @return Whether the union's current tag state has value
/// "member_delete_profile_photo".
///
- (BOOL)isMemberDeleteProfilePhoto;

///
/// Retrieves whether the union's current tag state has value
/// "member_permanently_delete_account_contents".
///
/// @return Whether the union's current tag state has value
/// "member_permanently_delete_account_contents".
///
- (BOOL)isMemberPermanentlyDeleteAccountContents;

///
/// Retrieves whether the union's current tag state has value
/// "member_remove_external_id".
///
/// @return Whether the union's current tag state has value
/// "member_remove_external_id".
///
- (BOOL)isMemberRemoveExternalId;

///
/// Retrieves whether the union's current tag state has value
/// "member_set_profile_photo".
///
/// @return Whether the union's current tag state has value
/// "member_set_profile_photo".
///
- (BOOL)isMemberSetProfilePhoto;

///
/// Retrieves whether the union's current tag state has value
/// "member_space_limits_add_custom_quota".
///
/// @return Whether the union's current tag state has value
/// "member_space_limits_add_custom_quota".
///
- (BOOL)isMemberSpaceLimitsAddCustomQuota;

///
/// Retrieves whether the union's current tag state has value
/// "member_space_limits_change_custom_quota".
///
/// @return Whether the union's current tag state has value
/// "member_space_limits_change_custom_quota".
///
- (BOOL)isMemberSpaceLimitsChangeCustomQuota;

///
/// Retrieves whether the union's current tag state has value
/// "member_space_limits_change_status".
///
/// @return Whether the union's current tag state has value
/// "member_space_limits_change_status".
///
- (BOOL)isMemberSpaceLimitsChangeStatus;

///
/// Retrieves whether the union's current tag state has value
/// "member_space_limits_remove_custom_quota".
///
/// @return Whether the union's current tag state has value
/// "member_space_limits_remove_custom_quota".
///
- (BOOL)isMemberSpaceLimitsRemoveCustomQuota;

///
/// Retrieves whether the union's current tag state has value "member_suggest".
///
/// @return Whether the union's current tag state has value "member_suggest".
///
- (BOOL)isMemberSuggest;

///
/// Retrieves whether the union's current tag state has value
/// "member_transfer_account_contents".
///
/// @return Whether the union's current tag state has value
/// "member_transfer_account_contents".
///
- (BOOL)isMemberTransferAccountContents;

///
/// Retrieves whether the union's current tag state has value
/// "pending_secondary_email_added".
///
/// @return Whether the union's current tag state has value
/// "pending_secondary_email_added".
///
- (BOOL)isPendingSecondaryEmailAdded;

///
/// Retrieves whether the union's current tag state has value
/// "secondary_email_deleted".
///
/// @return Whether the union's current tag state has value
/// "secondary_email_deleted".
///
- (BOOL)isSecondaryEmailDeleted;

///
/// Retrieves whether the union's current tag state has value
/// "secondary_email_verified".
///
/// @return Whether the union's current tag state has value
/// "secondary_email_verified".
///
- (BOOL)isSecondaryEmailVerified;

///
/// Retrieves whether the union's current tag state has value
/// "secondary_mails_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "secondary_mails_policy_changed".
///
- (BOOL)isSecondaryMailsPolicyChanged;

///
/// Retrieves whether the union's current tag state has value "binder_add_page".
///
/// @return Whether the union's current tag state has value "binder_add_page".
///
- (BOOL)isBinderAddPage;

///
/// Retrieves whether the union's current tag state has value
/// "binder_add_section".
///
/// @return Whether the union's current tag state has value
/// "binder_add_section".
///
- (BOOL)isBinderAddSection;

///
/// Retrieves whether the union's current tag state has value
/// "binder_remove_page".
///
/// @return Whether the union's current tag state has value
/// "binder_remove_page".
///
- (BOOL)isBinderRemovePage;

///
/// Retrieves whether the union's current tag state has value
/// "binder_remove_section".
///
/// @return Whether the union's current tag state has value
/// "binder_remove_section".
///
- (BOOL)isBinderRemoveSection;

///
/// Retrieves whether the union's current tag state has value
/// "binder_rename_page".
///
/// @return Whether the union's current tag state has value
/// "binder_rename_page".
///
- (BOOL)isBinderRenamePage;

///
/// Retrieves whether the union's current tag state has value
/// "binder_rename_section".
///
/// @return Whether the union's current tag state has value
/// "binder_rename_section".
///
- (BOOL)isBinderRenameSection;

///
/// Retrieves whether the union's current tag state has value
/// "binder_reorder_page".
///
/// @return Whether the union's current tag state has value
/// "binder_reorder_page".
///
- (BOOL)isBinderReorderPage;

///
/// Retrieves whether the union's current tag state has value
/// "binder_reorder_section".
///
/// @return Whether the union's current tag state has value
/// "binder_reorder_section".
///
- (BOOL)isBinderReorderSection;

///
/// Retrieves whether the union's current tag state has value
/// "paper_content_add_member".
///
/// @return Whether the union's current tag state has value
/// "paper_content_add_member".
///
- (BOOL)isPaperContentAddMember;

///
/// Retrieves whether the union's current tag state has value
/// "paper_content_add_to_folder".
///
/// @return Whether the union's current tag state has value
/// "paper_content_add_to_folder".
///
- (BOOL)isPaperContentAddToFolder;

///
/// Retrieves whether the union's current tag state has value
/// "paper_content_archive".
///
/// @return Whether the union's current tag state has value
/// "paper_content_archive".
///
- (BOOL)isPaperContentArchive;

///
/// Retrieves whether the union's current tag state has value
/// "paper_content_create".
///
/// @return Whether the union's current tag state has value
/// "paper_content_create".
///
- (BOOL)isPaperContentCreate;

///
/// Retrieves whether the union's current tag state has value
/// "paper_content_permanently_delete".
///
/// @return Whether the union's current tag state has value
/// "paper_content_permanently_delete".
///
- (BOOL)isPaperContentPermanentlyDelete;

///
/// Retrieves whether the union's current tag state has value
/// "paper_content_remove_from_folder".
///
/// @return Whether the union's current tag state has value
/// "paper_content_remove_from_folder".
///
- (BOOL)isPaperContentRemoveFromFolder;

///
/// Retrieves whether the union's current tag state has value
/// "paper_content_remove_member".
///
/// @return Whether the union's current tag state has value
/// "paper_content_remove_member".
///
- (BOOL)isPaperContentRemoveMember;

///
/// Retrieves whether the union's current tag state has value
/// "paper_content_rename".
///
/// @return Whether the union's current tag state has value
/// "paper_content_rename".
///
- (BOOL)isPaperContentRename;

///
/// Retrieves whether the union's current tag state has value
/// "paper_content_restore".
///
/// @return Whether the union's current tag state has value
/// "paper_content_restore".
///
- (BOOL)isPaperContentRestore;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_add_comment".
///
/// @return Whether the union's current tag state has value
/// "paper_doc_add_comment".
///
- (BOOL)isPaperDocAddComment;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_change_member_role".
///
/// @return Whether the union's current tag state has value
/// "paper_doc_change_member_role".
///
- (BOOL)isPaperDocChangeMemberRole;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_change_sharing_policy".
///
/// @return Whether the union's current tag state has value
/// "paper_doc_change_sharing_policy".
///
- (BOOL)isPaperDocChangeSharingPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_change_subscription".
///
/// @return Whether the union's current tag state has value
/// "paper_doc_change_subscription".
///
- (BOOL)isPaperDocChangeSubscription;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_deleted".
///
/// @return Whether the union's current tag state has value "paper_doc_deleted".
///
- (BOOL)isPaperDocDeleted;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_delete_comment".
///
/// @return Whether the union's current tag state has value
/// "paper_doc_delete_comment".
///
- (BOOL)isPaperDocDeleteComment;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_download".
///
/// @return Whether the union's current tag state has value
/// "paper_doc_download".
///
- (BOOL)isPaperDocDownload;

///
/// Retrieves whether the union's current tag state has value "paper_doc_edit".
///
/// @return Whether the union's current tag state has value "paper_doc_edit".
///
- (BOOL)isPaperDocEdit;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_edit_comment".
///
/// @return Whether the union's current tag state has value
/// "paper_doc_edit_comment".
///
- (BOOL)isPaperDocEditComment;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_followed".
///
/// @return Whether the union's current tag state has value
/// "paper_doc_followed".
///
- (BOOL)isPaperDocFollowed;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_mention".
///
/// @return Whether the union's current tag state has value "paper_doc_mention".
///
- (BOOL)isPaperDocMention;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_ownership_changed".
///
/// @return Whether the union's current tag state has value
/// "paper_doc_ownership_changed".
///
- (BOOL)isPaperDocOwnershipChanged;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_request_access".
///
/// @return Whether the union's current tag state has value
/// "paper_doc_request_access".
///
- (BOOL)isPaperDocRequestAccess;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_resolve_comment".
///
/// @return Whether the union's current tag state has value
/// "paper_doc_resolve_comment".
///
- (BOOL)isPaperDocResolveComment;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_revert".
///
/// @return Whether the union's current tag state has value "paper_doc_revert".
///
- (BOOL)isPaperDocRevert;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_slack_share".
///
/// @return Whether the union's current tag state has value
/// "paper_doc_slack_share".
///
- (BOOL)isPaperDocSlackShare;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_team_invite".
///
/// @return Whether the union's current tag state has value
/// "paper_doc_team_invite".
///
- (BOOL)isPaperDocTeamInvite;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_trashed".
///
/// @return Whether the union's current tag state has value "paper_doc_trashed".
///
- (BOOL)isPaperDocTrashed;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_unresolve_comment".
///
/// @return Whether the union's current tag state has value
/// "paper_doc_unresolve_comment".
///
- (BOOL)isPaperDocUnresolveComment;

///
/// Retrieves whether the union's current tag state has value
/// "paper_doc_untrashed".
///
/// @return Whether the union's current tag state has value
/// "paper_doc_untrashed".
///
- (BOOL)isPaperDocUntrashed;

///
/// Retrieves whether the union's current tag state has value "paper_doc_view".
///
/// @return Whether the union's current tag state has value "paper_doc_view".
///
- (BOOL)isPaperDocView;

///
/// Retrieves whether the union's current tag state has value
/// "paper_external_view_allow".
///
/// @return Whether the union's current tag state has value
/// "paper_external_view_allow".
///
- (BOOL)isPaperExternalViewAllow;

///
/// Retrieves whether the union's current tag state has value
/// "paper_external_view_default_team".
///
/// @return Whether the union's current tag state has value
/// "paper_external_view_default_team".
///
- (BOOL)isPaperExternalViewDefaultTeam;

///
/// Retrieves whether the union's current tag state has value
/// "paper_external_view_forbid".
///
/// @return Whether the union's current tag state has value
/// "paper_external_view_forbid".
///
- (BOOL)isPaperExternalViewForbid;

///
/// Retrieves whether the union's current tag state has value
/// "paper_folder_change_subscription".
///
/// @return Whether the union's current tag state has value
/// "paper_folder_change_subscription".
///
- (BOOL)isPaperFolderChangeSubscription;

///
/// Retrieves whether the union's current tag state has value
/// "paper_folder_deleted".
///
/// @return Whether the union's current tag state has value
/// "paper_folder_deleted".
///
- (BOOL)isPaperFolderDeleted;

///
/// Retrieves whether the union's current tag state has value
/// "paper_folder_followed".
///
/// @return Whether the union's current tag state has value
/// "paper_folder_followed".
///
- (BOOL)isPaperFolderFollowed;

///
/// Retrieves whether the union's current tag state has value
/// "paper_folder_team_invite".
///
/// @return Whether the union's current tag state has value
/// "paper_folder_team_invite".
///
- (BOOL)isPaperFolderTeamInvite;

///
/// Retrieves whether the union's current tag state has value
/// "paper_published_link_change_permission".
///
/// @return Whether the union's current tag state has value
/// "paper_published_link_change_permission".
///
- (BOOL)isPaperPublishedLinkChangePermission;

///
/// Retrieves whether the union's current tag state has value
/// "paper_published_link_create".
///
/// @return Whether the union's current tag state has value
/// "paper_published_link_create".
///
- (BOOL)isPaperPublishedLinkCreate;

///
/// Retrieves whether the union's current tag state has value
/// "paper_published_link_disabled".
///
/// @return Whether the union's current tag state has value
/// "paper_published_link_disabled".
///
- (BOOL)isPaperPublishedLinkDisabled;

///
/// Retrieves whether the union's current tag state has value
/// "paper_published_link_view".
///
/// @return Whether the union's current tag state has value
/// "paper_published_link_view".
///
- (BOOL)isPaperPublishedLinkView;

///
/// Retrieves whether the union's current tag state has value "password_change".
///
/// @return Whether the union's current tag state has value "password_change".
///
- (BOOL)isPasswordChange;

///
/// Retrieves whether the union's current tag state has value "password_reset".
///
/// @return Whether the union's current tag state has value "password_reset".
///
- (BOOL)isPasswordReset;

///
/// Retrieves whether the union's current tag state has value
/// "password_reset_all".
///
/// @return Whether the union's current tag state has value
/// "password_reset_all".
///
- (BOOL)isPasswordResetAll;

///
/// Retrieves whether the union's current tag state has value
/// "classification_create_report".
///
/// @return Whether the union's current tag state has value
/// "classification_create_report".
///
- (BOOL)isClassificationCreateReport;

///
/// Retrieves whether the union's current tag state has value
/// "classification_create_report_fail".
///
/// @return Whether the union's current tag state has value
/// "classification_create_report_fail".
///
- (BOOL)isClassificationCreateReportFail;

///
/// Retrieves whether the union's current tag state has value
/// "emm_create_exceptions_report".
///
/// @return Whether the union's current tag state has value
/// "emm_create_exceptions_report".
///
- (BOOL)isEmmCreateExceptionsReport;

///
/// Retrieves whether the union's current tag state has value
/// "emm_create_usage_report".
///
/// @return Whether the union's current tag state has value
/// "emm_create_usage_report".
///
- (BOOL)isEmmCreateUsageReport;

///
/// Retrieves whether the union's current tag state has value
/// "export_members_report".
///
/// @return Whether the union's current tag state has value
/// "export_members_report".
///
- (BOOL)isExportMembersReport;

///
/// Retrieves whether the union's current tag state has value
/// "export_members_report_fail".
///
/// @return Whether the union's current tag state has value
/// "export_members_report_fail".
///
- (BOOL)isExportMembersReportFail;

///
/// Retrieves whether the union's current tag state has value
/// "external_sharing_create_report".
///
/// @return Whether the union's current tag state has value
/// "external_sharing_create_report".
///
- (BOOL)isExternalSharingCreateReport;

///
/// Retrieves whether the union's current tag state has value
/// "external_sharing_report_failed".
///
/// @return Whether the union's current tag state has value
/// "external_sharing_report_failed".
///
- (BOOL)isExternalSharingReportFailed;

///
/// Retrieves whether the union's current tag state has value
/// "no_expiration_link_gen_create_report".
///
/// @return Whether the union's current tag state has value
/// "no_expiration_link_gen_create_report".
///
- (BOOL)isNoExpirationLinkGenCreateReport;

///
/// Retrieves whether the union's current tag state has value
/// "no_expiration_link_gen_report_failed".
///
/// @return Whether the union's current tag state has value
/// "no_expiration_link_gen_report_failed".
///
- (BOOL)isNoExpirationLinkGenReportFailed;

///
/// Retrieves whether the union's current tag state has value
/// "no_password_link_gen_create_report".
///
/// @return Whether the union's current tag state has value
/// "no_password_link_gen_create_report".
///
- (BOOL)isNoPasswordLinkGenCreateReport;

///
/// Retrieves whether the union's current tag state has value
/// "no_password_link_gen_report_failed".
///
/// @return Whether the union's current tag state has value
/// "no_password_link_gen_report_failed".
///
- (BOOL)isNoPasswordLinkGenReportFailed;

///
/// Retrieves whether the union's current tag state has value
/// "no_password_link_view_create_report".
///
/// @return Whether the union's current tag state has value
/// "no_password_link_view_create_report".
///
- (BOOL)isNoPasswordLinkViewCreateReport;

///
/// Retrieves whether the union's current tag state has value
/// "no_password_link_view_report_failed".
///
/// @return Whether the union's current tag state has value
/// "no_password_link_view_report_failed".
///
- (BOOL)isNoPasswordLinkViewReportFailed;

///
/// Retrieves whether the union's current tag state has value
/// "outdated_link_view_create_report".
///
/// @return Whether the union's current tag state has value
/// "outdated_link_view_create_report".
///
- (BOOL)isOutdatedLinkViewCreateReport;

///
/// Retrieves whether the union's current tag state has value
/// "outdated_link_view_report_failed".
///
/// @return Whether the union's current tag state has value
/// "outdated_link_view_report_failed".
///
- (BOOL)isOutdatedLinkViewReportFailed;

///
/// Retrieves whether the union's current tag state has value
/// "paper_admin_export_start".
///
/// @return Whether the union's current tag state has value
/// "paper_admin_export_start".
///
- (BOOL)isPaperAdminExportStart;

///
/// Retrieves whether the union's current tag state has value
/// "smart_sync_create_admin_privilege_report".
///
/// @return Whether the union's current tag state has value
/// "smart_sync_create_admin_privilege_report".
///
- (BOOL)isSmartSyncCreateAdminPrivilegeReport;

///
/// Retrieves whether the union's current tag state has value
/// "team_activity_create_report".
///
/// @return Whether the union's current tag state has value
/// "team_activity_create_report".
///
- (BOOL)isTeamActivityCreateReport;

///
/// Retrieves whether the union's current tag state has value
/// "team_activity_create_report_fail".
///
/// @return Whether the union's current tag state has value
/// "team_activity_create_report_fail".
///
- (BOOL)isTeamActivityCreateReportFail;

///
/// Retrieves whether the union's current tag state has value
/// "collection_share".
///
/// @return Whether the union's current tag state has value "collection_share".
///
- (BOOL)isCollectionShare;

///
/// Retrieves whether the union's current tag state has value
/// "file_transfers_file_add".
///
/// @return Whether the union's current tag state has value
/// "file_transfers_file_add".
///
- (BOOL)isFileTransfersFileAdd;

///
/// Retrieves whether the union's current tag state has value
/// "file_transfers_transfer_delete".
///
/// @return Whether the union's current tag state has value
/// "file_transfers_transfer_delete".
///
- (BOOL)isFileTransfersTransferDelete;

///
/// Retrieves whether the union's current tag state has value
/// "file_transfers_transfer_download".
///
/// @return Whether the union's current tag state has value
/// "file_transfers_transfer_download".
///
- (BOOL)isFileTransfersTransferDownload;

///
/// Retrieves whether the union's current tag state has value
/// "file_transfers_transfer_send".
///
/// @return Whether the union's current tag state has value
/// "file_transfers_transfer_send".
///
- (BOOL)isFileTransfersTransferSend;

///
/// Retrieves whether the union's current tag state has value
/// "file_transfers_transfer_view".
///
/// @return Whether the union's current tag state has value
/// "file_transfers_transfer_view".
///
- (BOOL)isFileTransfersTransferView;

///
/// Retrieves whether the union's current tag state has value
/// "note_acl_invite_only".
///
/// @return Whether the union's current tag state has value
/// "note_acl_invite_only".
///
- (BOOL)isNoteAclInviteOnly;

///
/// Retrieves whether the union's current tag state has value "note_acl_link".
///
/// @return Whether the union's current tag state has value "note_acl_link".
///
- (BOOL)isNoteAclLink;

///
/// Retrieves whether the union's current tag state has value
/// "note_acl_team_link".
///
/// @return Whether the union's current tag state has value
/// "note_acl_team_link".
///
- (BOOL)isNoteAclTeamLink;

///
/// Retrieves whether the union's current tag state has value "note_shared".
///
/// @return Whether the union's current tag state has value "note_shared".
///
- (BOOL)isNoteShared;

///
/// Retrieves whether the union's current tag state has value
/// "note_share_receive".
///
/// @return Whether the union's current tag state has value
/// "note_share_receive".
///
- (BOOL)isNoteShareReceive;

///
/// Retrieves whether the union's current tag state has value
/// "open_note_shared".
///
/// @return Whether the union's current tag state has value "open_note_shared".
///
- (BOOL)isOpenNoteShared;

///
/// Retrieves whether the union's current tag state has value "sf_add_group".
///
/// @return Whether the union's current tag state has value "sf_add_group".
///
- (BOOL)isSfAddGroup;

///
/// Retrieves whether the union's current tag state has value
/// "sf_allow_non_members_to_view_shared_links".
///
/// @return Whether the union's current tag state has value
/// "sf_allow_non_members_to_view_shared_links".
///
- (BOOL)isSfAllowNonMembersToViewSharedLinks;

///
/// Retrieves whether the union's current tag state has value
/// "sf_external_invite_warn".
///
/// @return Whether the union's current tag state has value
/// "sf_external_invite_warn".
///
- (BOOL)isSfExternalInviteWarn;

///
/// Retrieves whether the union's current tag state has value "sf_fb_invite".
///
/// @return Whether the union's current tag state has value "sf_fb_invite".
///
- (BOOL)isSfFbInvite;

///
/// Retrieves whether the union's current tag state has value
/// "sf_fb_invite_change_role".
///
/// @return Whether the union's current tag state has value
/// "sf_fb_invite_change_role".
///
- (BOOL)isSfFbInviteChangeRole;

///
/// Retrieves whether the union's current tag state has value "sf_fb_uninvite".
///
/// @return Whether the union's current tag state has value "sf_fb_uninvite".
///
- (BOOL)isSfFbUninvite;

///
/// Retrieves whether the union's current tag state has value "sf_invite_group".
///
/// @return Whether the union's current tag state has value "sf_invite_group".
///
- (BOOL)isSfInviteGroup;

///
/// Retrieves whether the union's current tag state has value
/// "sf_team_grant_access".
///
/// @return Whether the union's current tag state has value
/// "sf_team_grant_access".
///
- (BOOL)isSfTeamGrantAccess;

///
/// Retrieves whether the union's current tag state has value "sf_team_invite".
///
/// @return Whether the union's current tag state has value "sf_team_invite".
///
- (BOOL)isSfTeamInvite;

///
/// Retrieves whether the union's current tag state has value
/// "sf_team_invite_change_role".
///
/// @return Whether the union's current tag state has value
/// "sf_team_invite_change_role".
///
- (BOOL)isSfTeamInviteChangeRole;

///
/// Retrieves whether the union's current tag state has value "sf_team_join".
///
/// @return Whether the union's current tag state has value "sf_team_join".
///
- (BOOL)isSfTeamJoin;

///
/// Retrieves whether the union's current tag state has value
/// "sf_team_join_from_oob_link".
///
/// @return Whether the union's current tag state has value
/// "sf_team_join_from_oob_link".
///
- (BOOL)isSfTeamJoinFromOobLink;

///
/// Retrieves whether the union's current tag state has value
/// "sf_team_uninvite".
///
/// @return Whether the union's current tag state has value "sf_team_uninvite".
///
- (BOOL)isSfTeamUninvite;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_add_invitees".
///
/// @return Whether the union's current tag state has value
/// "shared_content_add_invitees".
///
- (BOOL)isSharedContentAddInvitees;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_add_link_expiry".
///
/// @return Whether the union's current tag state has value
/// "shared_content_add_link_expiry".
///
- (BOOL)isSharedContentAddLinkExpiry;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_add_link_password".
///
/// @return Whether the union's current tag state has value
/// "shared_content_add_link_password".
///
- (BOOL)isSharedContentAddLinkPassword;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_add_member".
///
/// @return Whether the union's current tag state has value
/// "shared_content_add_member".
///
- (BOOL)isSharedContentAddMember;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_change_downloads_policy".
///
/// @return Whether the union's current tag state has value
/// "shared_content_change_downloads_policy".
///
- (BOOL)isSharedContentChangeDownloadsPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_change_invitee_role".
///
/// @return Whether the union's current tag state has value
/// "shared_content_change_invitee_role".
///
- (BOOL)isSharedContentChangeInviteeRole;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_change_link_audience".
///
/// @return Whether the union's current tag state has value
/// "shared_content_change_link_audience".
///
- (BOOL)isSharedContentChangeLinkAudience;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_change_link_expiry".
///
/// @return Whether the union's current tag state has value
/// "shared_content_change_link_expiry".
///
- (BOOL)isSharedContentChangeLinkExpiry;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_change_link_password".
///
/// @return Whether the union's current tag state has value
/// "shared_content_change_link_password".
///
- (BOOL)isSharedContentChangeLinkPassword;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_change_member_role".
///
/// @return Whether the union's current tag state has value
/// "shared_content_change_member_role".
///
- (BOOL)isSharedContentChangeMemberRole;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_change_viewer_info_policy".
///
/// @return Whether the union's current tag state has value
/// "shared_content_change_viewer_info_policy".
///
- (BOOL)isSharedContentChangeViewerInfoPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_claim_invitation".
///
/// @return Whether the union's current tag state has value
/// "shared_content_claim_invitation".
///
- (BOOL)isSharedContentClaimInvitation;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_copy".
///
/// @return Whether the union's current tag state has value
/// "shared_content_copy".
///
- (BOOL)isSharedContentCopy;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_download".
///
/// @return Whether the union's current tag state has value
/// "shared_content_download".
///
- (BOOL)isSharedContentDownload;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_relinquish_membership".
///
/// @return Whether the union's current tag state has value
/// "shared_content_relinquish_membership".
///
- (BOOL)isSharedContentRelinquishMembership;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_remove_invitees".
///
/// @return Whether the union's current tag state has value
/// "shared_content_remove_invitees".
///
- (BOOL)isSharedContentRemoveInvitees;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_remove_link_expiry".
///
/// @return Whether the union's current tag state has value
/// "shared_content_remove_link_expiry".
///
- (BOOL)isSharedContentRemoveLinkExpiry;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_remove_link_password".
///
/// @return Whether the union's current tag state has value
/// "shared_content_remove_link_password".
///
- (BOOL)isSharedContentRemoveLinkPassword;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_remove_member".
///
/// @return Whether the union's current tag state has value
/// "shared_content_remove_member".
///
- (BOOL)isSharedContentRemoveMember;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_request_access".
///
/// @return Whether the union's current tag state has value
/// "shared_content_request_access".
///
- (BOOL)isSharedContentRequestAccess;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_restore_invitees".
///
/// @return Whether the union's current tag state has value
/// "shared_content_restore_invitees".
///
- (BOOL)isSharedContentRestoreInvitees;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_restore_member".
///
/// @return Whether the union's current tag state has value
/// "shared_content_restore_member".
///
- (BOOL)isSharedContentRestoreMember;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_unshare".
///
/// @return Whether the union's current tag state has value
/// "shared_content_unshare".
///
- (BOOL)isSharedContentUnshare;

///
/// Retrieves whether the union's current tag state has value
/// "shared_content_view".
///
/// @return Whether the union's current tag state has value
/// "shared_content_view".
///
- (BOOL)isSharedContentView;

///
/// Retrieves whether the union's current tag state has value
/// "shared_folder_change_link_policy".
///
/// @return Whether the union's current tag state has value
/// "shared_folder_change_link_policy".
///
- (BOOL)isSharedFolderChangeLinkPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "shared_folder_change_members_inheritance_policy".
///
/// @return Whether the union's current tag state has value
/// "shared_folder_change_members_inheritance_policy".
///
- (BOOL)isSharedFolderChangeMembersInheritancePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "shared_folder_change_members_management_policy".
///
/// @return Whether the union's current tag state has value
/// "shared_folder_change_members_management_policy".
///
- (BOOL)isSharedFolderChangeMembersManagementPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "shared_folder_change_members_policy".
///
/// @return Whether the union's current tag state has value
/// "shared_folder_change_members_policy".
///
- (BOOL)isSharedFolderChangeMembersPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "shared_folder_create".
///
/// @return Whether the union's current tag state has value
/// "shared_folder_create".
///
- (BOOL)isSharedFolderCreate;

///
/// Retrieves whether the union's current tag state has value
/// "shared_folder_decline_invitation".
///
/// @return Whether the union's current tag state has value
/// "shared_folder_decline_invitation".
///
- (BOOL)isSharedFolderDeclineInvitation;

///
/// Retrieves whether the union's current tag state has value
/// "shared_folder_mount".
///
/// @return Whether the union's current tag state has value
/// "shared_folder_mount".
///
- (BOOL)isSharedFolderMount;

///
/// Retrieves whether the union's current tag state has value
/// "shared_folder_nest".
///
/// @return Whether the union's current tag state has value
/// "shared_folder_nest".
///
- (BOOL)isSharedFolderNest;

///
/// Retrieves whether the union's current tag state has value
/// "shared_folder_transfer_ownership".
///
/// @return Whether the union's current tag state has value
/// "shared_folder_transfer_ownership".
///
- (BOOL)isSharedFolderTransferOwnership;

///
/// Retrieves whether the union's current tag state has value
/// "shared_folder_unmount".
///
/// @return Whether the union's current tag state has value
/// "shared_folder_unmount".
///
- (BOOL)isSharedFolderUnmount;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_add_expiry".
///
/// @return Whether the union's current tag state has value
/// "shared_link_add_expiry".
///
- (BOOL)isSharedLinkAddExpiry;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_change_expiry".
///
/// @return Whether the union's current tag state has value
/// "shared_link_change_expiry".
///
- (BOOL)isSharedLinkChangeExpiry;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_change_visibility".
///
/// @return Whether the union's current tag state has value
/// "shared_link_change_visibility".
///
- (BOOL)isSharedLinkChangeVisibility;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_copy".
///
/// @return Whether the union's current tag state has value "shared_link_copy".
///
- (BOOL)isSharedLinkCopy;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_create".
///
/// @return Whether the union's current tag state has value
/// "shared_link_create".
///
- (BOOL)isSharedLinkCreate;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_disable".
///
/// @return Whether the union's current tag state has value
/// "shared_link_disable".
///
- (BOOL)isSharedLinkDisable;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_download".
///
/// @return Whether the union's current tag state has value
/// "shared_link_download".
///
- (BOOL)isSharedLinkDownload;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_remove_expiry".
///
/// @return Whether the union's current tag state has value
/// "shared_link_remove_expiry".
///
- (BOOL)isSharedLinkRemoveExpiry;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_settings_add_expiration".
///
/// @return Whether the union's current tag state has value
/// "shared_link_settings_add_expiration".
///
- (BOOL)isSharedLinkSettingsAddExpiration;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_settings_add_password".
///
/// @return Whether the union's current tag state has value
/// "shared_link_settings_add_password".
///
- (BOOL)isSharedLinkSettingsAddPassword;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_settings_allow_download_disabled".
///
/// @return Whether the union's current tag state has value
/// "shared_link_settings_allow_download_disabled".
///
- (BOOL)isSharedLinkSettingsAllowDownloadDisabled;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_settings_allow_download_enabled".
///
/// @return Whether the union's current tag state has value
/// "shared_link_settings_allow_download_enabled".
///
- (BOOL)isSharedLinkSettingsAllowDownloadEnabled;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_settings_change_audience".
///
/// @return Whether the union's current tag state has value
/// "shared_link_settings_change_audience".
///
- (BOOL)isSharedLinkSettingsChangeAudience;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_settings_change_expiration".
///
/// @return Whether the union's current tag state has value
/// "shared_link_settings_change_expiration".
///
- (BOOL)isSharedLinkSettingsChangeExpiration;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_settings_change_password".
///
/// @return Whether the union's current tag state has value
/// "shared_link_settings_change_password".
///
- (BOOL)isSharedLinkSettingsChangePassword;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_settings_remove_expiration".
///
/// @return Whether the union's current tag state has value
/// "shared_link_settings_remove_expiration".
///
- (BOOL)isSharedLinkSettingsRemoveExpiration;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_settings_remove_password".
///
/// @return Whether the union's current tag state has value
/// "shared_link_settings_remove_password".
///
- (BOOL)isSharedLinkSettingsRemovePassword;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_share".
///
/// @return Whether the union's current tag state has value "shared_link_share".
///
- (BOOL)isSharedLinkShare;

///
/// Retrieves whether the union's current tag state has value
/// "shared_link_view".
///
/// @return Whether the union's current tag state has value "shared_link_view".
///
- (BOOL)isSharedLinkView;

///
/// Retrieves whether the union's current tag state has value
/// "shared_note_opened".
///
/// @return Whether the union's current tag state has value
/// "shared_note_opened".
///
- (BOOL)isSharedNoteOpened;

///
/// Retrieves whether the union's current tag state has value
/// "shmodel_disable_downloads".
///
/// @return Whether the union's current tag state has value
/// "shmodel_disable_downloads".
///
- (BOOL)isShmodelDisableDownloads;

///
/// Retrieves whether the union's current tag state has value
/// "shmodel_enable_downloads".
///
/// @return Whether the union's current tag state has value
/// "shmodel_enable_downloads".
///
- (BOOL)isShmodelEnableDownloads;

///
/// Retrieves whether the union's current tag state has value
/// "shmodel_group_share".
///
/// @return Whether the union's current tag state has value
/// "shmodel_group_share".
///
- (BOOL)isShmodelGroupShare;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_access_granted".
///
/// @return Whether the union's current tag state has value
/// "showcase_access_granted".
///
- (BOOL)isShowcaseAccessGranted;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_add_member".
///
/// @return Whether the union's current tag state has value
/// "showcase_add_member".
///
- (BOOL)isShowcaseAddMember;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_archived".
///
/// @return Whether the union's current tag state has value "showcase_archived".
///
- (BOOL)isShowcaseArchived;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_created".
///
/// @return Whether the union's current tag state has value "showcase_created".
///
- (BOOL)isShowcaseCreated;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_delete_comment".
///
/// @return Whether the union's current tag state has value
/// "showcase_delete_comment".
///
- (BOOL)isShowcaseDeleteComment;

///
/// Retrieves whether the union's current tag state has value "showcase_edited".
///
/// @return Whether the union's current tag state has value "showcase_edited".
///
- (BOOL)isShowcaseEdited;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_edit_comment".
///
/// @return Whether the union's current tag state has value
/// "showcase_edit_comment".
///
- (BOOL)isShowcaseEditComment;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_file_added".
///
/// @return Whether the union's current tag state has value
/// "showcase_file_added".
///
- (BOOL)isShowcaseFileAdded;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_file_download".
///
/// @return Whether the union's current tag state has value
/// "showcase_file_download".
///
- (BOOL)isShowcaseFileDownload;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_file_removed".
///
/// @return Whether the union's current tag state has value
/// "showcase_file_removed".
///
- (BOOL)isShowcaseFileRemoved;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_file_view".
///
/// @return Whether the union's current tag state has value
/// "showcase_file_view".
///
- (BOOL)isShowcaseFileView;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_permanently_deleted".
///
/// @return Whether the union's current tag state has value
/// "showcase_permanently_deleted".
///
- (BOOL)isShowcasePermanentlyDeleted;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_post_comment".
///
/// @return Whether the union's current tag state has value
/// "showcase_post_comment".
///
- (BOOL)isShowcasePostComment;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_remove_member".
///
/// @return Whether the union's current tag state has value
/// "showcase_remove_member".
///
- (BOOL)isShowcaseRemoveMember;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_renamed".
///
/// @return Whether the union's current tag state has value "showcase_renamed".
///
- (BOOL)isShowcaseRenamed;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_request_access".
///
/// @return Whether the union's current tag state has value
/// "showcase_request_access".
///
- (BOOL)isShowcaseRequestAccess;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_resolve_comment".
///
/// @return Whether the union's current tag state has value
/// "showcase_resolve_comment".
///
- (BOOL)isShowcaseResolveComment;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_restored".
///
/// @return Whether the union's current tag state has value "showcase_restored".
///
- (BOOL)isShowcaseRestored;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_trashed".
///
/// @return Whether the union's current tag state has value "showcase_trashed".
///
- (BOOL)isShowcaseTrashed;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_trashed_deprecated".
///
/// @return Whether the union's current tag state has value
/// "showcase_trashed_deprecated".
///
- (BOOL)isShowcaseTrashedDeprecated;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_unresolve_comment".
///
/// @return Whether the union's current tag state has value
/// "showcase_unresolve_comment".
///
- (BOOL)isShowcaseUnresolveComment;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_untrashed".
///
/// @return Whether the union's current tag state has value
/// "showcase_untrashed".
///
- (BOOL)isShowcaseUntrashed;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_untrashed_deprecated".
///
/// @return Whether the union's current tag state has value
/// "showcase_untrashed_deprecated".
///
- (BOOL)isShowcaseUntrashedDeprecated;

///
/// Retrieves whether the union's current tag state has value "showcase_view".
///
/// @return Whether the union's current tag state has value "showcase_view".
///
- (BOOL)isShowcaseView;

///
/// Retrieves whether the union's current tag state has value "sso_add_cert".
///
/// @return Whether the union's current tag state has value "sso_add_cert".
///
- (BOOL)isSsoAddCert;

///
/// Retrieves whether the union's current tag state has value
/// "sso_add_login_url".
///
/// @return Whether the union's current tag state has value "sso_add_login_url".
///
- (BOOL)isSsoAddLoginUrl;

///
/// Retrieves whether the union's current tag state has value
/// "sso_add_logout_url".
///
/// @return Whether the union's current tag state has value
/// "sso_add_logout_url".
///
- (BOOL)isSsoAddLogoutUrl;

///
/// Retrieves whether the union's current tag state has value "sso_change_cert".
///
/// @return Whether the union's current tag state has value "sso_change_cert".
///
- (BOOL)isSsoChangeCert;

///
/// Retrieves whether the union's current tag state has value
/// "sso_change_login_url".
///
/// @return Whether the union's current tag state has value
/// "sso_change_login_url".
///
- (BOOL)isSsoChangeLoginUrl;

///
/// Retrieves whether the union's current tag state has value
/// "sso_change_logout_url".
///
/// @return Whether the union's current tag state has value
/// "sso_change_logout_url".
///
- (BOOL)isSsoChangeLogoutUrl;

///
/// Retrieves whether the union's current tag state has value
/// "sso_change_saml_identity_mode".
///
/// @return Whether the union's current tag state has value
/// "sso_change_saml_identity_mode".
///
- (BOOL)isSsoChangeSamlIdentityMode;

///
/// Retrieves whether the union's current tag state has value "sso_remove_cert".
///
/// @return Whether the union's current tag state has value "sso_remove_cert".
///
- (BOOL)isSsoRemoveCert;

///
/// Retrieves whether the union's current tag state has value
/// "sso_remove_login_url".
///
/// @return Whether the union's current tag state has value
/// "sso_remove_login_url".
///
- (BOOL)isSsoRemoveLoginUrl;

///
/// Retrieves whether the union's current tag state has value
/// "sso_remove_logout_url".
///
/// @return Whether the union's current tag state has value
/// "sso_remove_logout_url".
///
- (BOOL)isSsoRemoveLogoutUrl;

///
/// Retrieves whether the union's current tag state has value
/// "team_folder_change_status".
///
/// @return Whether the union's current tag state has value
/// "team_folder_change_status".
///
- (BOOL)isTeamFolderChangeStatus;

///
/// Retrieves whether the union's current tag state has value
/// "team_folder_create".
///
/// @return Whether the union's current tag state has value
/// "team_folder_create".
///
- (BOOL)isTeamFolderCreate;

///
/// Retrieves whether the union's current tag state has value
/// "team_folder_downgrade".
///
/// @return Whether the union's current tag state has value
/// "team_folder_downgrade".
///
- (BOOL)isTeamFolderDowngrade;

///
/// Retrieves whether the union's current tag state has value
/// "team_folder_permanently_delete".
///
/// @return Whether the union's current tag state has value
/// "team_folder_permanently_delete".
///
- (BOOL)isTeamFolderPermanentlyDelete;

///
/// Retrieves whether the union's current tag state has value
/// "team_folder_rename".
///
/// @return Whether the union's current tag state has value
/// "team_folder_rename".
///
- (BOOL)isTeamFolderRename;

///
/// Retrieves whether the union's current tag state has value
/// "team_selective_sync_settings_changed".
///
/// @return Whether the union's current tag state has value
/// "team_selective_sync_settings_changed".
///
- (BOOL)isTeamSelectiveSyncSettingsChanged;

///
/// Retrieves whether the union's current tag state has value
/// "account_capture_change_policy".
///
/// @return Whether the union's current tag state has value
/// "account_capture_change_policy".
///
- (BOOL)isAccountCaptureChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "allow_download_disabled".
///
/// @return Whether the union's current tag state has value
/// "allow_download_disabled".
///
- (BOOL)isAllowDownloadDisabled;

///
/// Retrieves whether the union's current tag state has value
/// "allow_download_enabled".
///
/// @return Whether the union's current tag state has value
/// "allow_download_enabled".
///
- (BOOL)isAllowDownloadEnabled;

///
/// Retrieves whether the union's current tag state has value
/// "camera_uploads_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "camera_uploads_policy_changed".
///
- (BOOL)isCameraUploadsPolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "classification_change_policy".
///
/// @return Whether the union's current tag state has value
/// "classification_change_policy".
///
- (BOOL)isClassificationChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "computer_backup_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "computer_backup_policy_changed".
///
- (BOOL)isComputerBackupPolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "content_administration_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "content_administration_policy_changed".
///
- (BOOL)isContentAdministrationPolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "data_placement_restriction_change_policy".
///
/// @return Whether the union's current tag state has value
/// "data_placement_restriction_change_policy".
///
- (BOOL)isDataPlacementRestrictionChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "data_placement_restriction_satisfy_policy".
///
/// @return Whether the union's current tag state has value
/// "data_placement_restriction_satisfy_policy".
///
- (BOOL)isDataPlacementRestrictionSatisfyPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "device_approvals_add_exception".
///
/// @return Whether the union's current tag state has value
/// "device_approvals_add_exception".
///
- (BOOL)isDeviceApprovalsAddException;

///
/// Retrieves whether the union's current tag state has value
/// "device_approvals_change_desktop_policy".
///
/// @return Whether the union's current tag state has value
/// "device_approvals_change_desktop_policy".
///
- (BOOL)isDeviceApprovalsChangeDesktopPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "device_approvals_change_mobile_policy".
///
/// @return Whether the union's current tag state has value
/// "device_approvals_change_mobile_policy".
///
- (BOOL)isDeviceApprovalsChangeMobilePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "device_approvals_change_overage_action".
///
/// @return Whether the union's current tag state has value
/// "device_approvals_change_overage_action".
///
- (BOOL)isDeviceApprovalsChangeOverageAction;

///
/// Retrieves whether the union's current tag state has value
/// "device_approvals_change_unlink_action".
///
/// @return Whether the union's current tag state has value
/// "device_approvals_change_unlink_action".
///
- (BOOL)isDeviceApprovalsChangeUnlinkAction;

///
/// Retrieves whether the union's current tag state has value
/// "device_approvals_remove_exception".
///
/// @return Whether the union's current tag state has value
/// "device_approvals_remove_exception".
///
- (BOOL)isDeviceApprovalsRemoveException;

///
/// Retrieves whether the union's current tag state has value
/// "directory_restrictions_add_members".
///
/// @return Whether the union's current tag state has value
/// "directory_restrictions_add_members".
///
- (BOOL)isDirectoryRestrictionsAddMembers;

///
/// Retrieves whether the union's current tag state has value
/// "directory_restrictions_remove_members".
///
/// @return Whether the union's current tag state has value
/// "directory_restrictions_remove_members".
///
- (BOOL)isDirectoryRestrictionsRemoveMembers;

///
/// Retrieves whether the union's current tag state has value
/// "emm_add_exception".
///
/// @return Whether the union's current tag state has value "emm_add_exception".
///
- (BOOL)isEmmAddException;

///
/// Retrieves whether the union's current tag state has value
/// "emm_change_policy".
///
/// @return Whether the union's current tag state has value "emm_change_policy".
///
- (BOOL)isEmmChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "emm_remove_exception".
///
/// @return Whether the union's current tag state has value
/// "emm_remove_exception".
///
- (BOOL)isEmmRemoveException;

///
/// Retrieves whether the union's current tag state has value
/// "extended_version_history_change_policy".
///
/// @return Whether the union's current tag state has value
/// "extended_version_history_change_policy".
///
- (BOOL)isExtendedVersionHistoryChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "file_comments_change_policy".
///
/// @return Whether the union's current tag state has value
/// "file_comments_change_policy".
///
- (BOOL)isFileCommentsChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "file_locking_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "file_locking_policy_changed".
///
- (BOOL)isFileLockingPolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "file_requests_change_policy".
///
/// @return Whether the union's current tag state has value
/// "file_requests_change_policy".
///
- (BOOL)isFileRequestsChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "file_requests_emails_enabled".
///
/// @return Whether the union's current tag state has value
/// "file_requests_emails_enabled".
///
- (BOOL)isFileRequestsEmailsEnabled;

///
/// Retrieves whether the union's current tag state has value
/// "file_requests_emails_restricted_to_team_only".
///
/// @return Whether the union's current tag state has value
/// "file_requests_emails_restricted_to_team_only".
///
- (BOOL)isFileRequestsEmailsRestrictedToTeamOnly;

///
/// Retrieves whether the union's current tag state has value
/// "file_transfers_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "file_transfers_policy_changed".
///
- (BOOL)isFileTransfersPolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "google_sso_change_policy".
///
/// @return Whether the union's current tag state has value
/// "google_sso_change_policy".
///
- (BOOL)isGoogleSsoChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "group_user_management_change_policy".
///
/// @return Whether the union's current tag state has value
/// "group_user_management_change_policy".
///
- (BOOL)isGroupUserManagementChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "integration_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "integration_policy_changed".
///
- (BOOL)isIntegrationPolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "member_requests_change_policy".
///
/// @return Whether the union's current tag state has value
/// "member_requests_change_policy".
///
- (BOOL)isMemberRequestsChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "member_send_invite_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "member_send_invite_policy_changed".
///
- (BOOL)isMemberSendInvitePolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "member_space_limits_add_exception".
///
/// @return Whether the union's current tag state has value
/// "member_space_limits_add_exception".
///
- (BOOL)isMemberSpaceLimitsAddException;

///
/// Retrieves whether the union's current tag state has value
/// "member_space_limits_change_caps_type_policy".
///
/// @return Whether the union's current tag state has value
/// "member_space_limits_change_caps_type_policy".
///
- (BOOL)isMemberSpaceLimitsChangeCapsTypePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "member_space_limits_change_policy".
///
/// @return Whether the union's current tag state has value
/// "member_space_limits_change_policy".
///
- (BOOL)isMemberSpaceLimitsChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "member_space_limits_remove_exception".
///
/// @return Whether the union's current tag state has value
/// "member_space_limits_remove_exception".
///
- (BOOL)isMemberSpaceLimitsRemoveException;

///
/// Retrieves whether the union's current tag state has value
/// "member_suggestions_change_policy".
///
/// @return Whether the union's current tag state has value
/// "member_suggestions_change_policy".
///
- (BOOL)isMemberSuggestionsChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "microsoft_office_addin_change_policy".
///
/// @return Whether the union's current tag state has value
/// "microsoft_office_addin_change_policy".
///
- (BOOL)isMicrosoftOfficeAddinChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "network_control_change_policy".
///
/// @return Whether the union's current tag state has value
/// "network_control_change_policy".
///
- (BOOL)isNetworkControlChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "paper_change_deployment_policy".
///
/// @return Whether the union's current tag state has value
/// "paper_change_deployment_policy".
///
- (BOOL)isPaperChangeDeploymentPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "paper_change_member_link_policy".
///
/// @return Whether the union's current tag state has value
/// "paper_change_member_link_policy".
///
- (BOOL)isPaperChangeMemberLinkPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "paper_change_member_policy".
///
/// @return Whether the union's current tag state has value
/// "paper_change_member_policy".
///
- (BOOL)isPaperChangeMemberPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "paper_change_policy".
///
/// @return Whether the union's current tag state has value
/// "paper_change_policy".
///
- (BOOL)isPaperChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "paper_default_folder_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "paper_default_folder_policy_changed".
///
- (BOOL)isPaperDefaultFolderPolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "paper_desktop_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "paper_desktop_policy_changed".
///
- (BOOL)isPaperDesktopPolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "paper_enabled_users_group_addition".
///
/// @return Whether the union's current tag state has value
/// "paper_enabled_users_group_addition".
///
- (BOOL)isPaperEnabledUsersGroupAddition;

///
/// Retrieves whether the union's current tag state has value
/// "paper_enabled_users_group_removal".
///
/// @return Whether the union's current tag state has value
/// "paper_enabled_users_group_removal".
///
- (BOOL)isPaperEnabledUsersGroupRemoval;

///
/// Retrieves whether the union's current tag state has value
/// "password_strength_requirements_change_policy".
///
/// @return Whether the union's current tag state has value
/// "password_strength_requirements_change_policy".
///
- (BOOL)isPasswordStrengthRequirementsChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "permanent_delete_change_policy".
///
/// @return Whether the union's current tag state has value
/// "permanent_delete_change_policy".
///
- (BOOL)isPermanentDeleteChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "reseller_support_change_policy".
///
/// @return Whether the union's current tag state has value
/// "reseller_support_change_policy".
///
- (BOOL)isResellerSupportChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "rewind_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "rewind_policy_changed".
///
- (BOOL)isRewindPolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "send_for_signature_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "send_for_signature_policy_changed".
///
- (BOOL)isSendForSignaturePolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "sharing_change_folder_join_policy".
///
/// @return Whether the union's current tag state has value
/// "sharing_change_folder_join_policy".
///
- (BOOL)isSharingChangeFolderJoinPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "sharing_change_link_policy".
///
/// @return Whether the union's current tag state has value
/// "sharing_change_link_policy".
///
- (BOOL)isSharingChangeLinkPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "sharing_change_member_policy".
///
/// @return Whether the union's current tag state has value
/// "sharing_change_member_policy".
///
- (BOOL)isSharingChangeMemberPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_change_download_policy".
///
/// @return Whether the union's current tag state has value
/// "showcase_change_download_policy".
///
- (BOOL)isShowcaseChangeDownloadPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_change_enabled_policy".
///
/// @return Whether the union's current tag state has value
/// "showcase_change_enabled_policy".
///
- (BOOL)isShowcaseChangeEnabledPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "showcase_change_external_sharing_policy".
///
/// @return Whether the union's current tag state has value
/// "showcase_change_external_sharing_policy".
///
- (BOOL)isShowcaseChangeExternalSharingPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "smarter_smart_sync_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "smarter_smart_sync_policy_changed".
///
- (BOOL)isSmarterSmartSyncPolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "smart_sync_change_policy".
///
/// @return Whether the union's current tag state has value
/// "smart_sync_change_policy".
///
- (BOOL)isSmartSyncChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "smart_sync_not_opt_out".
///
/// @return Whether the union's current tag state has value
/// "smart_sync_not_opt_out".
///
- (BOOL)isSmartSyncNotOptOut;

///
/// Retrieves whether the union's current tag state has value
/// "smart_sync_opt_out".
///
/// @return Whether the union's current tag state has value
/// "smart_sync_opt_out".
///
- (BOOL)isSmartSyncOptOut;

///
/// Retrieves whether the union's current tag state has value
/// "sso_change_policy".
///
/// @return Whether the union's current tag state has value "sso_change_policy".
///
- (BOOL)isSsoChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "team_branding_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "team_branding_policy_changed".
///
- (BOOL)isTeamBrandingPolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "team_extensions_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "team_extensions_policy_changed".
///
- (BOOL)isTeamExtensionsPolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "team_selective_sync_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "team_selective_sync_policy_changed".
///
- (BOOL)isTeamSelectiveSyncPolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "team_sharing_whitelist_subjects_changed".
///
/// @return Whether the union's current tag state has value
/// "team_sharing_whitelist_subjects_changed".
///
- (BOOL)isTeamSharingWhitelistSubjectsChanged;

///
/// Retrieves whether the union's current tag state has value
/// "tfa_add_exception".
///
/// @return Whether the union's current tag state has value "tfa_add_exception".
///
- (BOOL)isTfaAddException;

///
/// Retrieves whether the union's current tag state has value
/// "tfa_change_policy".
///
/// @return Whether the union's current tag state has value "tfa_change_policy".
///
- (BOOL)isTfaChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "tfa_remove_exception".
///
/// @return Whether the union's current tag state has value
/// "tfa_remove_exception".
///
- (BOOL)isTfaRemoveException;

///
/// Retrieves whether the union's current tag state has value
/// "two_account_change_policy".
///
/// @return Whether the union's current tag state has value
/// "two_account_change_policy".
///
- (BOOL)isTwoAccountChangePolicy;

///
/// Retrieves whether the union's current tag state has value
/// "viewer_info_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "viewer_info_policy_changed".
///
- (BOOL)isViewerInfoPolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "watermarking_policy_changed".
///
/// @return Whether the union's current tag state has value
/// "watermarking_policy_changed".
///
- (BOOL)isWatermarkingPolicyChanged;

///
/// Retrieves whether the union's current tag state has value
/// "web_sessions_change_active_session_limit".
///
/// @return Whether the union's current tag state has value
/// "web_sessions_change_active_session_limit".
///
- (BOOL)isWebSessionsChangeActiveSessionLimit;

///
/// Retrieves whether the union's current tag state has value
/// "web_sessions_change_fixed_length_policy".
///
/// @return Whether the union's current tag state has value
/// "web_sessions_change_fixed_length_policy".
///
- (BOOL)isWebSessionsChangeFixedLengthPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "web_sessions_change_idle_length_policy".
///
/// @return Whether the union's current tag state has value
/// "web_sessions_change_idle_length_policy".
///
- (BOOL)isWebSessionsChangeIdleLengthPolicy;

///
/// Retrieves whether the union's current tag state has value "team_merge_from".
///
/// @return Whether the union's current tag state has value "team_merge_from".
///
- (BOOL)isTeamMergeFrom;

///
/// Retrieves whether the union's current tag state has value "team_merge_to".
///
/// @return Whether the union's current tag state has value "team_merge_to".
///
- (BOOL)isTeamMergeTo;

///
/// Retrieves whether the union's current tag state has value
/// "team_profile_add_background".
///
/// @return Whether the union's current tag state has value
/// "team_profile_add_background".
///
- (BOOL)isTeamProfileAddBackground;

///
/// Retrieves whether the union's current tag state has value
/// "team_profile_add_logo".
///
/// @return Whether the union's current tag state has value
/// "team_profile_add_logo".
///
- (BOOL)isTeamProfileAddLogo;

///
/// Retrieves whether the union's current tag state has value
/// "team_profile_change_background".
///
/// @return Whether the union's current tag state has value
/// "team_profile_change_background".
///
- (BOOL)isTeamProfileChangeBackground;

///
/// Retrieves whether the union's current tag state has value
/// "team_profile_change_default_language".
///
/// @return Whether the union's current tag state has value
/// "team_profile_change_default_language".
///
- (BOOL)isTeamProfileChangeDefaultLanguage;

///
/// Retrieves whether the union's current tag state has value
/// "team_profile_change_logo".
///
/// @return Whether the union's current tag state has value
/// "team_profile_change_logo".
///
- (BOOL)isTeamProfileChangeLogo;

///
/// Retrieves whether the union's current tag state has value
/// "team_profile_change_name".
///
/// @return Whether the union's current tag state has value
/// "team_profile_change_name".
///
- (BOOL)isTeamProfileChangeName;

///
/// Retrieves whether the union's current tag state has value
/// "team_profile_remove_background".
///
/// @return Whether the union's current tag state has value
/// "team_profile_remove_background".
///
- (BOOL)isTeamProfileRemoveBackground;

///
/// Retrieves whether the union's current tag state has value
/// "team_profile_remove_logo".
///
/// @return Whether the union's current tag state has value
/// "team_profile_remove_logo".
///
- (BOOL)isTeamProfileRemoveLogo;

///
/// Retrieves whether the union's current tag state has value
/// "tfa_add_backup_phone".
///
/// @return Whether the union's current tag state has value
/// "tfa_add_backup_phone".
///
- (BOOL)isTfaAddBackupPhone;

///
/// Retrieves whether the union's current tag state has value
/// "tfa_add_security_key".
///
/// @return Whether the union's current tag state has value
/// "tfa_add_security_key".
///
- (BOOL)isTfaAddSecurityKey;

///
/// Retrieves whether the union's current tag state has value
/// "tfa_change_backup_phone".
///
/// @return Whether the union's current tag state has value
/// "tfa_change_backup_phone".
///
- (BOOL)isTfaChangeBackupPhone;

///
/// Retrieves whether the union's current tag state has value
/// "tfa_change_status".
///
/// @return Whether the union's current tag state has value "tfa_change_status".
///
- (BOOL)isTfaChangeStatus;

///
/// Retrieves whether the union's current tag state has value
/// "tfa_remove_backup_phone".
///
/// @return Whether the union's current tag state has value
/// "tfa_remove_backup_phone".
///
- (BOOL)isTfaRemoveBackupPhone;

///
/// Retrieves whether the union's current tag state has value
/// "tfa_remove_security_key".
///
/// @return Whether the union's current tag state has value
/// "tfa_remove_security_key".
///
- (BOOL)isTfaRemoveSecurityKey;

///
/// Retrieves whether the union's current tag state has value "tfa_reset".
///
/// @return Whether the union's current tag state has value "tfa_reset".
///
- (BOOL)isTfaReset;

///
/// Retrieves whether the union's current tag state has value
/// "changed_enterprise_admin_role".
///
/// @return Whether the union's current tag state has value
/// "changed_enterprise_admin_role".
///
- (BOOL)isChangedEnterpriseAdminRole;

///
/// Retrieves whether the union's current tag state has value
/// "changed_enterprise_connected_team_status".
///
/// @return Whether the union's current tag state has value
/// "changed_enterprise_connected_team_status".
///
- (BOOL)isChangedEnterpriseConnectedTeamStatus;

///
/// Retrieves whether the union's current tag state has value
/// "ended_enterprise_admin_session".
///
/// @return Whether the union's current tag state has value
/// "ended_enterprise_admin_session".
///
- (BOOL)isEndedEnterpriseAdminSession;

///
/// Retrieves whether the union's current tag state has value
/// "ended_enterprise_admin_session_deprecated".
///
/// @return Whether the union's current tag state has value
/// "ended_enterprise_admin_session_deprecated".
///
- (BOOL)isEndedEnterpriseAdminSessionDeprecated;

///
/// Retrieves whether the union's current tag state has value
/// "enterprise_settings_locking".
///
/// @return Whether the union's current tag state has value
/// "enterprise_settings_locking".
///
- (BOOL)isEnterpriseSettingsLocking;

///
/// Retrieves whether the union's current tag state has value
/// "guest_admin_change_status".
///
/// @return Whether the union's current tag state has value
/// "guest_admin_change_status".
///
- (BOOL)isGuestAdminChangeStatus;

///
/// Retrieves whether the union's current tag state has value
/// "started_enterprise_admin_session".
///
/// @return Whether the union's current tag state has value
/// "started_enterprise_admin_session".
///
- (BOOL)isStartedEnterpriseAdminSession;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_accepted".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_accepted".
///
- (BOOL)isTeamMergeRequestAccepted;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_accepted_shown_to_primary_team".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_accepted_shown_to_primary_team".
///
- (BOOL)isTeamMergeRequestAcceptedShownToPrimaryTeam;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_accepted_shown_to_secondary_team".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_accepted_shown_to_secondary_team".
///
- (BOOL)isTeamMergeRequestAcceptedShownToSecondaryTeam;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_auto_canceled".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_auto_canceled".
///
- (BOOL)isTeamMergeRequestAutoCanceled;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_canceled".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_canceled".
///
- (BOOL)isTeamMergeRequestCanceled;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_canceled_shown_to_primary_team".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_canceled_shown_to_primary_team".
///
- (BOOL)isTeamMergeRequestCanceledShownToPrimaryTeam;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_canceled_shown_to_secondary_team".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_canceled_shown_to_secondary_team".
///
- (BOOL)isTeamMergeRequestCanceledShownToSecondaryTeam;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_expired".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_expired".
///
- (BOOL)isTeamMergeRequestExpired;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_expired_shown_to_primary_team".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_expired_shown_to_primary_team".
///
- (BOOL)isTeamMergeRequestExpiredShownToPrimaryTeam;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_expired_shown_to_secondary_team".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_expired_shown_to_secondary_team".
///
- (BOOL)isTeamMergeRequestExpiredShownToSecondaryTeam;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_rejected_shown_to_primary_team".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_rejected_shown_to_primary_team".
///
- (BOOL)isTeamMergeRequestRejectedShownToPrimaryTeam;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_rejected_shown_to_secondary_team".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_rejected_shown_to_secondary_team".
///
- (BOOL)isTeamMergeRequestRejectedShownToSecondaryTeam;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_reminder".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_reminder".
///
- (BOOL)isTeamMergeRequestReminder;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_reminder_shown_to_primary_team".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_reminder_shown_to_primary_team".
///
- (BOOL)isTeamMergeRequestReminderShownToPrimaryTeam;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_reminder_shown_to_secondary_team".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_reminder_shown_to_secondary_team".
///
- (BOOL)isTeamMergeRequestReminderShownToSecondaryTeam;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_revoked".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_revoked".
///
- (BOOL)isTeamMergeRequestRevoked;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_sent_shown_to_primary_team".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_sent_shown_to_primary_team".
///
- (BOOL)isTeamMergeRequestSentShownToPrimaryTeam;

///
/// Retrieves whether the union's current tag state has value
/// "team_merge_request_sent_shown_to_secondary_team".
///
/// @return Whether the union's current tag state has value
/// "team_merge_request_sent_shown_to_secondary_team".
///
- (BOOL)isTeamMergeRequestSentShownToSecondaryTeam;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGEventTypeArg` union.
///
@interface DBTEAMLOGEventTypeArgSerializer : NSObject

///
/// Serializes `DBTEAMLOGEventTypeArg` instances.
///
/// @param instance An instance of the `DBTEAMLOGEventTypeArg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGEventTypeArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEventTypeArg *)instance;

///
/// Deserializes `DBTEAMLOGEventTypeArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGEventTypeArg` API object.
///
/// @return An instantiation of the `DBTEAMLOGEventTypeArg` object.
///
+ (DBTEAMLOGEventTypeArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
