///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGDomainVerificationAddDomainSuccessDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DomainVerificationAddDomainSuccessDetails` struct.
///
/// Verified team domain.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGDomainVerificationAddDomainSuccessDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Domain names.
@property (nonatomic, readonly) NSArray<NSString *> *domainNames;

/// Domain name verification method. Might be missing due to historical data
/// gap.
@property (nonatomic, readonly, copy, nullable) NSString *verificationMethod;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param domainNames Domain names.
/// @param verificationMethod Domain name verification method. Might be missing
/// due to historical data gap.
///
/// @return An initialized instance.
///
- (instancetype)initWithDomainNames:(NSArray<NSString *> *)domainNames
                 verificationMethod:(nullable NSString *)verificationMethod;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param domainNames Domain names.
///
/// @return An initialized instance.
///
- (instancetype)initWithDomainNames:(NSArray<NSString *> *)domainNames;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DomainVerificationAddDomainSuccessDetails`
/// struct.
///
@interface DBTEAMLOGDomainVerificationAddDomainSuccessDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGDomainVerificationAddDomainSuccessDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGDomainVerificationAddDomainSuccessDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGDomainVerificationAddDomainSuccessDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainVerificationAddDomainSuccessDetails *)instance;

///
/// Deserializes `DBTEAMLOGDomainVerificationAddDomainSuccessDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGDomainVerificationAddDomainSuccessDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGDomainVerificationAddDomainSuccessDetails` object.
///
+ (DBTEAMLOGDomainVerificationAddDomainSuccessDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
