///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGDispositionActionType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DispositionActionType` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGDispositionActionType : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGDispositionActionTypeTag` enum type represents the possible
/// tag states with which the `DBTEAMLOGDispositionActionType` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGDispositionActionTypeTag){
    /// (no description).
    DBTEAMLOGDispositionActionTypeAutomaticDelete,

    /// (no description).
    DBTEAMLOGDispositionActionTypeAutomaticPermanentlyDelete,

    /// (no description).
    DBTEAMLOGDispositionActionTypeOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGDispositionActionTypeTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "automatic_delete".
///
/// @return An initialized instance.
///
- (instancetype)initWithAutomaticDelete;

///
/// Initializes union class with tag state of "automatic_permanently_delete".
///
/// @return An initialized instance.
///
- (instancetype)initWithAutomaticPermanentlyDelete;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "automatic_delete".
///
/// @return Whether the union's current tag state has value "automatic_delete".
///
- (BOOL)isAutomaticDelete;

///
/// Retrieves whether the union's current tag state has value
/// "automatic_permanently_delete".
///
/// @return Whether the union's current tag state has value
/// "automatic_permanently_delete".
///
- (BOOL)isAutomaticPermanentlyDelete;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGDispositionActionType` union.
///
@interface DBTEAMLOGDispositionActionTypeSerializer : NSObject

///
/// Serializes `DBTEAMLOGDispositionActionType` instances.
///
/// @param instance An instance of the `DBTEAMLOGDispositionActionType` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGDispositionActionType` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDispositionActionType *)instance;

///
/// Deserializes `DBTEAMLOGDispositionActionType` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGDispositionActionType` API object.
///
/// @return An instantiation of the `DBTEAMLOGDispositionActionType` object.
///
+ (DBTEAMLOGDispositionActionType *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
