///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails;
@class DBTEAMLOGDeviceUnlinkPolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DeviceApprovalsChangeUnlinkActionDetails` struct.
///
/// Changed device approvals setting when member unlinks approved device.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// New device unlink policy. Might be missing due to historical data gap.
@property (nonatomic, readonly, nullable) DBTEAMLOGDeviceUnlinkPolicy *dNewValue;

/// Previous device unlink policy. Might be missing due to historical data gap.
@property (nonatomic, readonly, nullable) DBTEAMLOGDeviceUnlinkPolicy *previousValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dNewValue New device unlink policy. Might be missing due to
/// historical data gap.
/// @param previousValue Previous device unlink policy. Might be missing due to
/// historical data gap.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(nullable DBTEAMLOGDeviceUnlinkPolicy *)dNewValue
                    previousValue:(nullable DBTEAMLOGDeviceUnlinkPolicy *)previousValue;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DeviceApprovalsChangeUnlinkActionDetails`
/// struct.
///
@interface DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails *)instance;

///
/// Deserializes `DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails` object.
///
+ (DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
