///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGDeviceApprovalsChangeOverageActionDetails;
@class DBTEAMPOLICIESRolloutMethod;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DeviceApprovalsChangeOverageActionDetails` struct.
///
/// Changed device approvals setting when member is over limit.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGDeviceApprovalsChangeOverageActionDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// New over the limits policy. Might be missing due to historical data gap.
@property (nonatomic, readonly, nullable) DBTEAMPOLICIESRolloutMethod *dNewValue;

/// Previous over the limit policy. Might be missing due to historical data gap.
@property (nonatomic, readonly, nullable) DBTEAMPOLICIESRolloutMethod *previousValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dNewValue New over the limits policy. Might be missing due to
/// historical data gap.
/// @param previousValue Previous over the limit policy. Might be missing due to
/// historical data gap.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(nullable DBTEAMPOLICIESRolloutMethod *)dNewValue
                    previousValue:(nullable DBTEAMPOLICIESRolloutMethod *)previousValue;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DeviceApprovalsChangeOverageActionDetails`
/// struct.
///
@interface DBTEAMLOGDeviceApprovalsChangeOverageActionDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGDeviceApprovalsChangeOverageActionDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGDeviceApprovalsChangeOverageActionDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGDeviceApprovalsChangeOverageActionDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsChangeOverageActionDetails *)instance;

///
/// Deserializes `DBTEAMLOGDeviceApprovalsChangeOverageActionDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGDeviceApprovalsChangeOverageActionDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGDeviceApprovalsChangeOverageActionDetails` object.
///
+ (DBTEAMLOGDeviceApprovalsChangeOverageActionDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
