///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails;
@class DBTEAMLOGDeviceApprovalsPolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DeviceApprovalsChangeMobilePolicyDetails` struct.
///
/// Set/removed limit on number of mobile devices member can link to team
/// Dropbox account.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// New mobile device approvals policy. Might be missing due to historical data
/// gap.
@property (nonatomic, readonly, nullable) DBTEAMLOGDeviceApprovalsPolicy *dNewValue;

/// Previous mobile device approvals policy. Might be missing due to historical
/// data gap.
@property (nonatomic, readonly, nullable) DBTEAMLOGDeviceApprovalsPolicy *previousValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dNewValue New mobile device approvals policy. Might be missing due to
/// historical data gap.
/// @param previousValue Previous mobile device approvals policy. Might be
/// missing due to historical data gap.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(nullable DBTEAMLOGDeviceApprovalsPolicy *)dNewValue
                    previousValue:(nullable DBTEAMLOGDeviceApprovalsPolicy *)previousValue;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DeviceApprovalsChangeMobilePolicyDetails`
/// struct.
///
@interface DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails *)instance;

///
/// Deserializes `DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails` object.
///
+ (DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
