///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMDeleteSecondaryEmailResult;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DeleteSecondaryEmailResult` union.
///
/// Result of trying to delete a secondary email address. 'success' is the only
/// value indicating that a secondary email was successfully deleted. The other
/// values explain the type of error that occurred, and include the email for
/// which the error occured.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMDeleteSecondaryEmailResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMDeleteSecondaryEmailResultTag` enum type represents the possible
/// tag states with which the `DBTEAMDeleteSecondaryEmailResult` union can
/// exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMDeleteSecondaryEmailResultTag){
    /// The secondary email was successfully deleted.
    DBTEAMDeleteSecondaryEmailResultSuccess,

    /// The email address was not found for the user.
    DBTEAMDeleteSecondaryEmailResultNotFound,

    /// The email address is the primary email address of the user, and cannot
    /// be removed.
    DBTEAMDeleteSecondaryEmailResultCannotRemovePrimary,

    /// (no description).
    DBTEAMDeleteSecondaryEmailResultOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMDeleteSecondaryEmailResultTag tag;

/// The secondary email was successfully deleted. @note Ensure the `isSuccess`
/// method returns true before accessing, otherwise a runtime exception will be
/// raised.
@property (nonatomic, readonly, copy) NSString *success;

/// The email address was not found for the user. @note Ensure the `isNotFound`
/// method returns true before accessing, otherwise a runtime exception will be
/// raised.
@property (nonatomic, readonly, copy) NSString *notFound;

/// The email address is the primary email address of the user, and cannot be
/// removed. @note Ensure the `isCannotRemovePrimary` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *cannotRemovePrimary;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "success".
///
/// Description of the "success" tag state: The secondary email was successfully
/// deleted.
///
/// @param success The secondary email was successfully deleted.
///
/// @return An initialized instance.
///
- (instancetype)initWithSuccess:(NSString *)success;

///
/// Initializes union class with tag state of "not_found".
///
/// Description of the "not_found" tag state: The email address was not found
/// for the user.
///
/// @param notFound The email address was not found for the user.
///
/// @return An initialized instance.
///
- (instancetype)initWithNotFound:(NSString *)notFound;

///
/// Initializes union class with tag state of "cannot_remove_primary".
///
/// Description of the "cannot_remove_primary" tag state: The email address is
/// the primary email address of the user, and cannot be removed.
///
/// @param cannotRemovePrimary The email address is the primary email address of
/// the user, and cannot be removed.
///
/// @return An initialized instance.
///
- (instancetype)initWithCannotRemovePrimary:(NSString *)cannotRemovePrimary;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "success".
///
/// @note Call this method and ensure it returns true before accessing the
/// `success` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "success".
///
- (BOOL)isSuccess;

///
/// Retrieves whether the union's current tag state has value "not_found".
///
/// @note Call this method and ensure it returns true before accessing the
/// `notFound` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "not_found".
///
- (BOOL)isNotFound;

///
/// Retrieves whether the union's current tag state has value
/// "cannot_remove_primary".
///
/// @note Call this method and ensure it returns true before accessing the
/// `cannotRemovePrimary` property, otherwise a runtime exception will be
/// thrown.
///
/// @return Whether the union's current tag state has value
/// "cannot_remove_primary".
///
- (BOOL)isCannotRemovePrimary;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMDeleteSecondaryEmailResult` union.
///
@interface DBTEAMDeleteSecondaryEmailResultSerializer : NSObject

///
/// Serializes `DBTEAMDeleteSecondaryEmailResult` instances.
///
/// @param instance An instance of the `DBTEAMDeleteSecondaryEmailResult` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMDeleteSecondaryEmailResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMDeleteSecondaryEmailResult *)instance;

///
/// Deserializes `DBTEAMDeleteSecondaryEmailResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMDeleteSecondaryEmailResult` API object.
///
/// @return An instantiation of the `DBTEAMDeleteSecondaryEmailResult` object.
///
+ (DBTEAMDeleteSecondaryEmailResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
