///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGSharedFolderAccessError;
@class DBSHARINGUpdateFolderPolicyError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UpdateFolderPolicyError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGUpdateFolderPolicyError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBSHARINGUpdateFolderPolicyErrorTag` enum type represents the possible
/// tag states with which the `DBSHARINGUpdateFolderPolicyError` union can
/// exist.
typedef NS_CLOSED_ENUM(NSInteger, DBSHARINGUpdateFolderPolicyErrorTag){
    /// (no description).
    DBSHARINGUpdateFolderPolicyErrorAccessError,

    /// `memberPolicy` in `DBSHARINGUpdateFolderPolicyArg` was set even though
    /// user is not on a team.
    DBSHARINGUpdateFolderPolicyErrorNotOnTeam,

    /// Team policy is more restrictive than `memberPolicy` in
    /// `DBSHARINGShareFolderArg`.
    DBSHARINGUpdateFolderPolicyErrorTeamPolicyDisallowsMemberPolicy,

    /// The current account is not allowed to select the specified
    /// `sharedLinkPolicy` in `DBSHARINGShareFolderArg`.
    DBSHARINGUpdateFolderPolicyErrorDisallowedSharedLinkPolicy,

    /// The current user does not have permission to perform this action.
    DBSHARINGUpdateFolderPolicyErrorNoPermission,

    /// This action cannot be performed on a team shared folder.
    DBSHARINGUpdateFolderPolicyErrorTeamFolder,

    /// (no description).
    DBSHARINGUpdateFolderPolicyErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBSHARINGUpdateFolderPolicyErrorTag tag;

/// (no description). @note Ensure the `isAccessError` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBSHARINGSharedFolderAccessError *accessError;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "access_error".
///
/// @param accessError (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithAccessError:(DBSHARINGSharedFolderAccessError *)accessError;

///
/// Initializes union class with tag state of "not_on_team".
///
/// Description of the "not_on_team" tag state: `memberPolicy` in
/// `DBSHARINGUpdateFolderPolicyArg` was set even though user is not on a team.
///
/// @return An initialized instance.
///
- (instancetype)initWithNotOnTeam;

///
/// Initializes union class with tag state of
/// "team_policy_disallows_member_policy".
///
/// Description of the "team_policy_disallows_member_policy" tag state: Team
/// policy is more restrictive than `memberPolicy` in `DBSHARINGShareFolderArg`.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamPolicyDisallowsMemberPolicy;

///
/// Initializes union class with tag state of "disallowed_shared_link_policy".
///
/// Description of the "disallowed_shared_link_policy" tag state: The current
/// account is not allowed to select the specified `sharedLinkPolicy` in
/// `DBSHARINGShareFolderArg`.
///
/// @return An initialized instance.
///
- (instancetype)initWithDisallowedSharedLinkPolicy;

///
/// Initializes union class with tag state of "no_permission".
///
/// Description of the "no_permission" tag state: The current user does not have
/// permission to perform this action.
///
/// @return An initialized instance.
///
- (instancetype)initWithNoPermission;

///
/// Initializes union class with tag state of "team_folder".
///
/// Description of the "team_folder" tag state: This action cannot be performed
/// on a team shared folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamFolder;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "access_error".
///
/// @note Call this method and ensure it returns true before accessing the
/// `accessError` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "access_error".
///
- (BOOL)isAccessError;

///
/// Retrieves whether the union's current tag state has value "not_on_team".
///
/// @return Whether the union's current tag state has value "not_on_team".
///
- (BOOL)isNotOnTeam;

///
/// Retrieves whether the union's current tag state has value
/// "team_policy_disallows_member_policy".
///
/// @return Whether the union's current tag state has value
/// "team_policy_disallows_member_policy".
///
- (BOOL)isTeamPolicyDisallowsMemberPolicy;

///
/// Retrieves whether the union's current tag state has value
/// "disallowed_shared_link_policy".
///
/// @return Whether the union's current tag state has value
/// "disallowed_shared_link_policy".
///
- (BOOL)isDisallowedSharedLinkPolicy;

///
/// Retrieves whether the union's current tag state has value "no_permission".
///
/// @return Whether the union's current tag state has value "no_permission".
///
- (BOOL)isNoPermission;

///
/// Retrieves whether the union's current tag state has value "team_folder".
///
/// @return Whether the union's current tag state has value "team_folder".
///
- (BOOL)isTeamFolder;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBSHARINGUpdateFolderPolicyError` union.
///
@interface DBSHARINGUpdateFolderPolicyErrorSerializer : NSObject

///
/// Serializes `DBSHARINGUpdateFolderPolicyError` instances.
///
/// @param instance An instance of the `DBSHARINGUpdateFolderPolicyError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGUpdateFolderPolicyError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGUpdateFolderPolicyError *)instance;

///
/// Deserializes `DBSHARINGUpdateFolderPolicyError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGUpdateFolderPolicyError` API object.
///
/// @return An instantiation of the `DBSHARINGUpdateFolderPolicyError` object.
///
+ (DBSHARINGUpdateFolderPolicyError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
