///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGShareFolderLaunch;
@class DBSHARINGSharedFolderMetadata;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ShareFolderLaunch` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGShareFolderLaunch : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBSHARINGShareFolderLaunchTag` enum type represents the possible tag
/// states with which the `DBSHARINGShareFolderLaunch` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBSHARINGShareFolderLaunchTag){
    /// This response indicates that the processing is asynchronous. The string
    /// is an id that can be used to obtain the status of the asynchronous job.
    DBSHARINGShareFolderLaunchAsyncJobId,

    /// (no description).
    DBSHARINGShareFolderLaunchComplete,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBSHARINGShareFolderLaunchTag tag;

/// This response indicates that the processing is asynchronous. The string is
/// an id that can be used to obtain the status of the asynchronous job. @note
/// Ensure the `isAsyncJobId` method returns true before accessing, otherwise a
/// runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *asyncJobId;

/// (no description). @note Ensure the `isComplete` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBSHARINGSharedFolderMetadata *complete;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "async_job_id".
///
/// Description of the "async_job_id" tag state: This response indicates that
/// the processing is asynchronous. The string is an id that can be used to
/// obtain the status of the asynchronous job.
///
/// @param asyncJobId This response indicates that the processing is
/// asynchronous. The string is an id that can be used to obtain the status of
/// the asynchronous job.
///
/// @return An initialized instance.
///
- (instancetype)initWithAsyncJobId:(NSString *)asyncJobId;

///
/// Initializes union class with tag state of "complete".
///
/// @param complete (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithComplete:(DBSHARINGSharedFolderMetadata *)complete;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "async_job_id".
///
/// @note Call this method and ensure it returns true before accessing the
/// `asyncJobId` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "async_job_id".
///
- (BOOL)isAsyncJobId;

///
/// Retrieves whether the union's current tag state has value "complete".
///
/// @note Call this method and ensure it returns true before accessing the
/// `complete` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "complete".
///
- (BOOL)isComplete;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBSHARINGShareFolderLaunch` union.
///
@interface DBSHARINGShareFolderLaunchSerializer : NSObject

///
/// Serializes `DBSHARINGShareFolderLaunch` instances.
///
/// @param instance An instance of the `DBSHARINGShareFolderLaunch` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGShareFolderLaunch` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGShareFolderLaunch *)instance;

///
/// Deserializes `DBSHARINGShareFolderLaunch` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGShareFolderLaunch` API object.
///
/// @return An instantiation of the `DBSHARINGShareFolderLaunch` object.
///
+ (DBSHARINGShareFolderLaunch *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
