///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSHARINGMembershipInfo.h"
#import "DBSerializableProtocol.h"

@class DBSHARINGAccessLevel;
@class DBSHARINGInviteeInfo;
@class DBSHARINGInviteeMembershipInfo;
@class DBSHARINGMemberPermission;
@class DBSHARINGUserInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `InviteeMembershipInfo` struct.
///
/// Information about an invited member of a shared content.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGInviteeMembershipInfo : DBSHARINGMembershipInfo <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Recipient of the invitation.
@property (nonatomic, readonly) DBSHARINGInviteeInfo *invitee;

/// The user this invitation is tied to, if available.
@property (nonatomic, readonly, nullable) DBSHARINGUserInfo *user;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param accessType The access type for this member. It contains inherited
/// access type from parent folder, and acquired access type from this folder.
/// @param invitee Recipient of the invitation.
/// @param permissions The permissions that requesting user has on this member.
/// The set of permissions corresponds to the MemberActions in the request.
/// @param initials Never set.
/// @param isInherited True if the member has access from a parent folder.
/// @param user The user this invitation is tied to, if available.
///
/// @return An initialized instance.
///
- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType
                           invitee:(DBSHARINGInviteeInfo *)invitee
                       permissions:(nullable NSArray<DBSHARINGMemberPermission *> *)permissions
                          initials:(nullable NSString *)initials
                       isInherited:(nullable NSNumber *)isInherited
                              user:(nullable DBSHARINGUserInfo *)user;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param accessType The access type for this member. It contains inherited
/// access type from parent folder, and acquired access type from this folder.
/// @param invitee Recipient of the invitation.
///
/// @return An initialized instance.
///
- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType invitee:(DBSHARINGInviteeInfo *)invitee;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `InviteeMembershipInfo` struct.
///
@interface DBSHARINGInviteeMembershipInfoSerializer : NSObject

///
/// Serializes `DBSHARINGInviteeMembershipInfo` instances.
///
/// @param instance An instance of the `DBSHARINGInviteeMembershipInfo` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGInviteeMembershipInfo` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGInviteeMembershipInfo *)instance;

///
/// Deserializes `DBSHARINGInviteeMembershipInfo` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGInviteeMembershipInfo` API object.
///
/// @return An instantiation of the `DBSHARINGInviteeMembershipInfo` object.
///
+ (DBSHARINGInviteeMembershipInfo *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
