///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGCreateSharedLinkArg;
@class DBSHARINGPendingUploadMode;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `CreateSharedLinkArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGCreateSharedLinkArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The path to share.
@property (nonatomic, readonly, copy) NSString *path;

/// Whether to return a shortened URL.
@property (nonatomic, readonly) NSNumber *shortUrl;

/// If it's okay to share a path that does not yet exist, set this to either
/// `file` in `DBSHARINGPendingUploadMode` or `folder` in
/// `DBSHARINGPendingUploadMode` to indicate whether to assume it's a file or
/// folder.
@property (nonatomic, readonly, nullable) DBSHARINGPendingUploadMode *pendingUpload;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param path The path to share.
/// @param shortUrl Whether to return a shortened URL.
/// @param pendingUpload If it's okay to share a path that does not yet exist,
/// set this to either `file` in `DBSHARINGPendingUploadMode` or `folder` in
/// `DBSHARINGPendingUploadMode` to indicate whether to assume it's a file or
/// folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(NSString *)path
                    shortUrl:(nullable NSNumber *)shortUrl
               pendingUpload:(nullable DBSHARINGPendingUploadMode *)pendingUpload;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param path The path to share.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(NSString *)path;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `CreateSharedLinkArg` struct.
///
@interface DBSHARINGCreateSharedLinkArgSerializer : NSObject

///
/// Serializes `DBSHARINGCreateSharedLinkArg` instances.
///
/// @param instance An instance of the `DBSHARINGCreateSharedLinkArg` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGCreateSharedLinkArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGCreateSharedLinkArg *)instance;

///
/// Deserializes `DBSHARINGCreateSharedLinkArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGCreateSharedLinkArg` API object.
///
/// @return An instantiation of the `DBSHARINGCreateSharedLinkArg` object.
///
+ (DBSHARINGCreateSharedLinkArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
