///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGAudienceRestrictingSharedFolder;
@class DBSHARINGLinkAudience;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AudienceRestrictingSharedFolder` struct.
///
/// Information about the shared folder that prevents the link audience for this
/// link from being more restrictive.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGAudienceRestrictingSharedFolder : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The ID of the shared folder.
@property (nonatomic, readonly, copy) NSString *sharedFolderId;

/// The name of the shared folder.
@property (nonatomic, readonly, copy) NSString *name;

/// The link audience of the shared folder.
@property (nonatomic, readonly) DBSHARINGLinkAudience *audience;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param sharedFolderId The ID of the shared folder.
/// @param name The name of the shared folder.
/// @param audience The link audience of the shared folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId
                                  name:(NSString *)name
                              audience:(DBSHARINGLinkAudience *)audience;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `AudienceRestrictingSharedFolder` struct.
///
@interface DBSHARINGAudienceRestrictingSharedFolderSerializer : NSObject

///
/// Serializes `DBSHARINGAudienceRestrictingSharedFolder` instances.
///
/// @param instance An instance of the
/// `DBSHARINGAudienceRestrictingSharedFolder` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGAudienceRestrictingSharedFolder` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGAudienceRestrictingSharedFolder *)instance;

///
/// Deserializes `DBSHARINGAudienceRestrictingSharedFolder` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGAudienceRestrictingSharedFolder` API object.
///
/// @return An instantiation of the `DBSHARINGAudienceRestrictingSharedFolder`
/// object.
///
+ (DBSHARINGAudienceRestrictingSharedFolder *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
