///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBPAPERFolderSharingPolicyType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `FolderSharingPolicyType` union.
///
/// The sharing policy of a Paper folder. The sharing policy of subfolders is
/// inherited from the root folder.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBPAPERFolderSharingPolicyType : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBPAPERFolderSharingPolicyTypeTag` enum type represents the possible
/// tag states with which the `DBPAPERFolderSharingPolicyType` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBPAPERFolderSharingPolicyTypeTag){
    /// Everyone in your team and anyone directly invited can access this
    /// folder.
    DBPAPERFolderSharingPolicyTypeTeam,

    /// Only people directly invited can access this folder.
    DBPAPERFolderSharingPolicyTypeInviteOnly,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBPAPERFolderSharingPolicyTypeTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "team".
///
/// Description of the "team" tag state: Everyone in your team and anyone
/// directly invited can access this folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeam;

///
/// Initializes union class with tag state of "invite_only".
///
/// Description of the "invite_only" tag state: Only people directly invited can
/// access this folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithInviteOnly;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "team".
///
/// @return Whether the union's current tag state has value "team".
///
- (BOOL)isTeam;

///
/// Retrieves whether the union's current tag state has value "invite_only".
///
/// @return Whether the union's current tag state has value "invite_only".
///
- (BOOL)isInviteOnly;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBPAPERFolderSharingPolicyType` union.
///
@interface DBPAPERFolderSharingPolicyTypeSerializer : NSObject

///
/// Serializes `DBPAPERFolderSharingPolicyType` instances.
///
/// @param instance An instance of the `DBPAPERFolderSharingPolicyType` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBPAPERFolderSharingPolicyType` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBPAPERFolderSharingPolicyType *)instance;

///
/// Deserializes `DBPAPERFolderSharingPolicyType` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBPAPERFolderSharingPolicyType` API object.
///
/// @return An instantiation of the `DBPAPERFolderSharingPolicyType` object.
///
+ (DBPAPERFolderSharingPolicyType *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
