///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESPathOrLink;
@class DBFILESThumbnailFormat;
@class DBFILESThumbnailMode;
@class DBFILESThumbnailSize;
@class DBFILESThumbnailV2Arg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ThumbnailV2Arg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESThumbnailV2Arg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Information specifying which file to preview. This could be a path to a
/// file, a shared link pointing to a file, or a shared link pointing to a
/// folder, with a relative path.
@property (nonatomic, readonly) DBFILESPathOrLink *resource;

/// The format for the thumbnail image, jpeg (default) or png. For  images that
/// are photos, jpeg should be preferred, while png is  better for screenshots
/// and digital arts.
@property (nonatomic, readonly) DBFILESThumbnailFormat *format;

/// The size for the thumbnail image.
@property (nonatomic, readonly) DBFILESThumbnailSize *size;

/// How to resize and crop the image to achieve the desired size.
@property (nonatomic, readonly) DBFILESThumbnailMode *mode;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param resource Information specifying which file to preview. This could be
/// a path to a file, a shared link pointing to a file, or a shared link
/// pointing to a folder, with a relative path.
/// @param format The format for the thumbnail image, jpeg (default) or png. For
/// images that are photos, jpeg should be preferred, while png is  better for
/// screenshots and digital arts.
/// @param size The size for the thumbnail image.
/// @param mode How to resize and crop the image to achieve the desired size.
///
/// @return An initialized instance.
///
- (instancetype)initWithResource:(DBFILESPathOrLink *)resource
                          format:(nullable DBFILESThumbnailFormat *)format
                            size:(nullable DBFILESThumbnailSize *)size
                            mode:(nullable DBFILESThumbnailMode *)mode;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param resource Information specifying which file to preview. This could be
/// a path to a file, a shared link pointing to a file, or a shared link
/// pointing to a folder, with a relative path.
///
/// @return An initialized instance.
///
- (instancetype)initWithResource:(DBFILESPathOrLink *)resource;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ThumbnailV2Arg` struct.
///
@interface DBFILESThumbnailV2ArgSerializer : NSObject

///
/// Serializes `DBFILESThumbnailV2Arg` instances.
///
/// @param instance An instance of the `DBFILESThumbnailV2Arg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESThumbnailV2Arg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESThumbnailV2Arg *)instance;

///
/// Deserializes `DBFILESThumbnailV2Arg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESThumbnailV2Arg` API object.
///
/// @return An instantiation of the `DBFILESThumbnailV2Arg` object.
///
+ (DBFILESThumbnailV2Arg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
