///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESGetThumbnailBatchError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GetThumbnailBatchError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESGetThumbnailBatchError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESGetThumbnailBatchErrorTag` enum type represents the possible tag
/// states with which the `DBFILESGetThumbnailBatchError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESGetThumbnailBatchErrorTag){
    /// The operation involves more than 25 files.
    DBFILESGetThumbnailBatchErrorTooManyFiles,

    /// (no description).
    DBFILESGetThumbnailBatchErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESGetThumbnailBatchErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "too_many_files".
///
/// Description of the "too_many_files" tag state: The operation involves more
/// than 25 files.
///
/// @return An initialized instance.
///
- (instancetype)initWithTooManyFiles;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "too_many_files".
///
/// @return Whether the union's current tag state has value "too_many_files".
///
- (BOOL)isTooManyFiles;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESGetThumbnailBatchError` union.
///
@interface DBFILESGetThumbnailBatchErrorSerializer : NSObject

///
/// Serializes `DBFILESGetThumbnailBatchError` instances.
///
/// @param instance An instance of the `DBFILESGetThumbnailBatchError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESGetThumbnailBatchError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESGetThumbnailBatchError *)instance;

///
/// Deserializes `DBFILESGetThumbnailBatchError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESGetThumbnailBatchError` API object.
///
/// @return An instantiation of the `DBFILESGetThumbnailBatchError` object.
///
+ (DBFILESGetThumbnailBatchError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
