///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESCreateFolderArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `CreateFolderArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESCreateFolderArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Path in the user's Dropbox to create.
@property (nonatomic, readonly, copy) NSString *path;

/// If there's a conflict, have the Dropbox server try to autorename the folder
/// to avoid the conflict.
@property (nonatomic, readonly) NSNumber *autorename;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param path Path in the user's Dropbox to create.
/// @param autorename If there's a conflict, have the Dropbox server try to
/// autorename the folder to avoid the conflict.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(NSString *)path autorename:(nullable NSNumber *)autorename;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param path Path in the user's Dropbox to create.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(NSString *)path;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `CreateFolderArg` struct.
///
@interface DBFILESCreateFolderArgSerializer : NSObject

///
/// Serializes `DBFILESCreateFolderArg` instances.
///
/// @param instance An instance of the `DBFILESCreateFolderArg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESCreateFolderArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESCreateFolderArg *)instance;

///
/// Deserializes `DBFILESCreateFolderArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESCreateFolderArg` API object.
///
/// @return An instantiation of the `DBFILESCreateFolderArg` object.
///
+ (DBFILESCreateFolderArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
