///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBFILESCommitInfo.h"
#import "DBSerializableProtocol.h"

@class DBFILEPROPERTIESPropertyGroup;
@class DBFILESCommitInfoWithProperties;
@class DBFILESWriteMode;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `CommitInfoWithProperties` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESCommitInfoWithProperties : DBFILESCommitInfo <DBSerializable, NSCopying>

#pragma mark - Instance fields

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param path Path in the user's Dropbox to save the file.
/// @param mode Selects what to do if the file already exists.
/// @param autorename If there's a conflict, as determined by mode, have the
/// Dropbox server try to autorename the file to avoid conflict.
/// @param clientModified The value to store as the clientModified timestamp.
/// Dropbox automatically records the time at which the file was written to the
/// Dropbox servers. It can also record an additional timestamp, provided by
/// Dropbox desktop clients, mobile clients, and API apps of when the file was
/// actually created or modified.
/// @param mute Normally, users are made aware of any file modifications in
/// their Dropbox account via notifications in the client software. If true,
/// this tells the clients that this modification shouldn't result in a user
/// notification.
/// @param propertyGroups List of custom properties to add to file.
/// @param strictConflict Be more strict about how each WriteMode detects
/// conflict. For example, always return a conflict error when mode = `update`
/// in `DBFILESWriteMode` and the given "rev" doesn't match the existing file's
/// "rev", even if the existing file has been deleted. This also forces a
/// conflict even when the target path refers to a file with identical contents.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(NSString *)path
                        mode:(nullable DBFILESWriteMode *)mode
                  autorename:(nullable NSNumber *)autorename
              clientModified:(nullable NSDate *)clientModified
                        mute:(nullable NSNumber *)mute
              propertyGroups:(nullable NSArray<DBFILEPROPERTIESPropertyGroup *> *)propertyGroups
              strictConflict:(nullable NSNumber *)strictConflict;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param path Path in the user's Dropbox to save the file.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(NSString *)path;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `CommitInfoWithProperties` struct.
///
@interface DBFILESCommitInfoWithPropertiesSerializer : NSObject

///
/// Serializes `DBFILESCommitInfoWithProperties` instances.
///
/// @param instance An instance of the `DBFILESCommitInfoWithProperties` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESCommitInfoWithProperties` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESCommitInfoWithProperties *)instance;

///
/// Deserializes `DBFILESCommitInfoWithProperties` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESCommitInfoWithProperties` API object.
///
/// @return An instantiation of the `DBFILESCommitInfoWithProperties` object.
///
+ (DBFILESCommitInfoWithProperties *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
