///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILEPROPERTIESPropertyFieldTemplate;
@class DBFILEPROPERTIESPropertyType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PropertyFieldTemplate` struct.
///
/// Defines how a single property field may be structured. Used exclusively by
/// PropertyGroupTemplate.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILEPROPERTIESPropertyFieldTemplate : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Key of the property field being described. Property field keys can be up to
/// 256 bytes.
@property (nonatomic, readonly, copy) NSString *name;

/// Description of the property field. Property field descriptions can be up to
/// 1024 bytes.
@property (nonatomic, readonly, copy) NSString *description_;

/// Data type of the value of this property field. This type will be enforced
/// upon property creation and modifications.
@property (nonatomic, readonly) DBFILEPROPERTIESPropertyType *type;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param name Key of the property field being described. Property field keys
/// can be up to 256 bytes.
/// @param description_ Description of the property field. Property field
/// descriptions can be up to 1024 bytes.
/// @param type Data type of the value of this property field. This type will be
/// enforced upon property creation and modifications.
///
/// @return An initialized instance.
///
- (instancetype)initWithName:(NSString *)name
                description_:(NSString *)description_
                        type:(DBFILEPROPERTIESPropertyType *)type;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `PropertyFieldTemplate` struct.
///
@interface DBFILEPROPERTIESPropertyFieldTemplateSerializer : NSObject

///
/// Serializes `DBFILEPROPERTIESPropertyFieldTemplate` instances.
///
/// @param instance An instance of the `DBFILEPROPERTIESPropertyFieldTemplate`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESPropertyFieldTemplate` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILEPROPERTIESPropertyFieldTemplate *)instance;

///
/// Deserializes `DBFILEPROPERTIESPropertyFieldTemplate` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILEPROPERTIESPropertyFieldTemplate` API object.
///
/// @return An instantiation of the `DBFILEPROPERTIESPropertyFieldTemplate`
/// object.
///
+ (DBFILEPROPERTIESPropertyFieldTemplate *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
